"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["node_modules_ionic_core_components_swipe-back_js"],{

/***/ "./node_modules/@ionic/core/components/swipe-back.js":
/*!***********************************************************!*\
  !*** ./node_modules/@ionic/core/components/swipe-back.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSwipeBackGesture: () => (/* binding */ createSwipeBackGesture)
/* harmony export */ });
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers.js */ "./node_modules/@ionic/core/components/helpers.js");
/* harmony import */ var _dir_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dir.js */ "./node_modules/@ionic/core/components/dir.js");
/* harmony import */ var _index3_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./index3.js */ "./node_modules/@ionic/core/components/index3.js");
/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */




const createSwipeBackGesture = (el, canStartHandler, onStartHandler, onMoveHandler, onEndHandler) => {
    const win = el.ownerDocument.defaultView;
    let rtl = (0,_dir_js__WEBPACK_IMPORTED_MODULE_0__.i)(el);
    /**
     * Determine if a gesture is near the edge
     * of the screen. If true, then the swipe
     * to go back gesture should proceed.
     */
    const isAtEdge = (detail) => {
        const threshold = 50;
        const { startX } = detail;
        if (rtl) {
            return startX >= win.innerWidth - threshold;
        }
        return startX <= threshold;
    };
    const getDeltaX = (detail) => {
        return rtl ? -detail.deltaX : detail.deltaX;
    };
    const getVelocityX = (detail) => {
        return rtl ? -detail.velocityX : detail.velocityX;
    };
    const canStart = (detail) => {
        /**
         * The user's locale can change mid-session,
         * so we need to check text direction at
         * the beginning of every gesture.
         */
        rtl = (0,_dir_js__WEBPACK_IMPORTED_MODULE_0__.i)(el);
        return isAtEdge(detail) && canStartHandler();
    };
    const onMove = (detail) => {
        // set the transition animation's progress
        const delta = getDeltaX(detail);
        const stepValue = delta / win.innerWidth;
        onMoveHandler(stepValue);
    };
    const onEnd = (detail) => {
        // the swipe back gesture has ended
        const delta = getDeltaX(detail);
        const width = win.innerWidth;
        const stepValue = delta / width;
        const velocity = getVelocityX(detail);
        const z = width / 2.0;
        const shouldComplete = velocity >= 0 && (velocity > 0.2 || delta > z);
        const missing = shouldComplete ? 1 - stepValue : stepValue;
        const missingDistance = missing * width;
        let realDur = 0;
        if (missingDistance > 5) {
            const dur = missingDistance / Math.abs(velocity);
            realDur = Math.min(dur, 540);
        }
        onEndHandler(shouldComplete, stepValue <= 0 ? 0.01 : (0,_helpers_js__WEBPACK_IMPORTED_MODULE_1__.m)(0, stepValue, 0.9999), realDur);
    };
    return (0,_index3_js__WEBPACK_IMPORTED_MODULE_2__.createGesture)({
        el,
        gestureName: 'goback-swipe',
        /**
         * Swipe to go back should have priority over other horizontal swipe
         * gestures. These gestures have a priority of 100 which is why 101 was chosen here.
         */
        gesturePriority: 101,
        threshold: 10,
        canStart,
        onStart: onStartHandler,
        onMove,
        onEnd,
    });
};




/***/ })

}]);