/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/js/Admin/Components/Header/MenuItem.jsx":
/*!***********************************************************!*\
  !*** ./resources/js/Admin/Components/Header/MenuItem.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Frontend_Components_Header_DropDown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/Frontend/Components/Header/DropDown */ "./resources/js/Frontend/Components/Header/DropDown.js");
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function MenuItem(_ref) {
  var item = _ref.item;
  var hasChildren = item.children.length > 0;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("li", {
    className: hasChildren ? "menu-item-has-children" : "menu-item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
      href: item.url,
      children: item.name
    }), hasChildren && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Frontend_Components_Header_DropDown__WEBPACK_IMPORTED_MODULE_1__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("ul", {
        children: item.children.map(function (childItem) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(MenuItem, {
            item: childItem
          }, childItem.id);
        })
      })
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MenuItem);

/***/ }),

/***/ "./resources/js/Admin/Components/Modal/SmallModal.jsx":
/*!************************************************************!*\
  !*** ./resources/js/Admin/Components/Modal/SmallModal.jsx ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SmallModal)
/* harmony export */ });
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function SmallModal(_ref) {
  var isModal = _ref.isModal,
    closeModal = _ref.closeModal,
    title = _ref.title,
    actionButtonTitle = _ref.actionButtonTitle,
    dismissButtonTitle = _ref.dismissButtonTitle,
    onSubmit = _ref.onSubmit,
    children = _ref.children,
    processing = _ref.processing;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: isModal && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "modal fade show",
        id: "exampleModal",
        style: {
          display: isModal ? "block" : "none"
        },
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("form", {
          className: "modal-dialog",
          onSubmit: onSubmit,
          style: {
            position: "relative",
            zIndex: "9999"
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
            className: "modal-content",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
              className: "modal-header",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h5", {
                className: "modal-title cs_fs_24 cs_normal",
                id: "exampleModalLabel",
                children: title
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("button", {
                onClick: function onClick() {
                  return closeModal(false);
                },
                type: "button",
                className: "cs_modal_close",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_0__.Icon, {
                  icon: "lucide:x",
                  width: "18",
                  height: "18"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
              className: "modal-body",
              children: children
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
              className: "modal-footer",
              children: [dismissButtonTitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("button", {
                onClick: function onClick() {
                  return closeModal(false);
                },
                type: "button",
                className: "btn btn-secondary",
                children: dismissButtonTitle
              }), actionButtonTitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("button", {
                type: "submit",
                className: "btn btn-primary",
                disabled: processing,
                children: actionButtonTitle
              })]
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "cs_modal_overlay",
          onClick: function onClick() {
            return closeModal(false);
          }
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Admin/Utils/SweetAlert.js":
/*!************************************************!*\
  !*** ./resources/js/Admin/Utils/SweetAlert.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   showAlert: () => (/* binding */ showAlert)
/* harmony export */ });
/* harmony import */ var sweetalert2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! sweetalert2 */ "sweetalert2");
/* harmony import */ var sweetalert2__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(sweetalert2__WEBPACK_IMPORTED_MODULE_0__);

var showAlert = function showAlert(title, text, confirmButtonText, confirmCallback) {
  sweetalert2__WEBPACK_IMPORTED_MODULE_0___default().fire({
    title: title,
    text: text,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: confirmButtonText
  }).then(function (result) {
    if (result.isConfirmed) {
      confirmCallback(); // Call the callback function if the user confirms
    }
  });
};

/***/ }),

/***/ "./resources/js/Components/Amount.jsx":
/*!********************************************!*\
  !*** ./resources/js/Components/Amount.jsx ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Amount)
/* harmony export */ });
/* harmony import */ var _utils_formatCurrency__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/utils/formatCurrency */ "./resources/js/utils/formatCurrency.js");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Amount(_ref) {
  var amount = _ref.amount;
  var _usePage$props$curren = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.currency,
    currency_symbol = _usePage$props$curren.currency_symbol,
    currency_position = _usePage$props$curren.currency_position,
    decimal_separator = _usePage$props$curren.decimal_separator,
    no_of_decimal = _usePage$props$curren.no_of_decimal;
  var formattedAmount = (0,_utils_formatCurrency__WEBPACK_IMPORTED_MODULE_0__["default"])(amount, no_of_decimal, decimal_separator);
  var data = null;
  if (currency_position === "left") {
    data = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
      children: [currency_symbol, formattedAmount]
    });
  } else if (currency_position === "right") {
    data = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
      children: [formattedAmount, currency_symbol]
    });
  } else if (currency_position === "left_space") {
    data = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
      children: [currency_symbol, " ", formattedAmount]
    });
  } else if (currency_position === "right_space") {
    data = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
      children: [formattedAmount, " ", currency_symbol]
    });
  } else {
    data = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
      children: [currency_symbol, formattedAmount]
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: data
  });
}

/***/ }),

/***/ "./resources/js/Components/ApplicationLogo.jsx":
/*!*****************************************************!*\
  !*** ./resources/js/Components/ApplicationLogo.jsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ApplicationLogo)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

function ApplicationLogo(props) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", _objectSpread(_objectSpread({}, props), {}, {
    viewBox: "0 0 316 316",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M305.8 81.125C305.77 80.995 305.69 80.885 305.65 80.755C305.56 80.525 305.49 80.285 305.37 80.075C305.29 79.935 305.17 79.815 305.07 79.685C304.94 79.515 304.83 79.325 304.68 79.175C304.55 79.045 304.39 78.955 304.25 78.845C304.09 78.715 303.95 78.575 303.77 78.475L251.32 48.275C249.97 47.495 248.31 47.495 246.96 48.275L194.51 78.475C194.33 78.575 194.19 78.725 194.03 78.845C193.89 78.955 193.73 79.045 193.6 79.175C193.45 79.325 193.34 79.515 193.21 79.685C193.11 79.815 192.99 79.935 192.91 80.075C192.79 80.285 192.71 80.525 192.63 80.755C192.58 80.875 192.51 80.995 192.48 81.125C192.38 81.495 192.33 81.875 192.33 82.265V139.625L148.62 164.795V52.575C148.62 52.185 148.57 51.805 148.47 51.435C148.44 51.305 148.36 51.195 148.32 51.065C148.23 50.835 148.16 50.595 148.04 50.385C147.96 50.245 147.84 50.125 147.74 49.995C147.61 49.825 147.5 49.635 147.35 49.485C147.22 49.355 147.06 49.265 146.92 49.155C146.76 49.025 146.62 48.885 146.44 48.785L93.99 18.585C92.64 17.805 90.98 17.805 89.63 18.585L37.18 48.785C37 48.885 36.86 49.035 36.7 49.155C36.56 49.265 36.4 49.355 36.27 49.485C36.12 49.635 36.01 49.825 35.88 49.995C35.78 50.125 35.66 50.245 35.58 50.385C35.46 50.595 35.38 50.835 35.3 51.065C35.25 51.185 35.18 51.305 35.15 51.435C35.05 51.805 35 52.185 35 52.575V232.235C35 233.795 35.84 235.245 37.19 236.025L142.1 296.425C142.33 296.555 142.58 296.635 142.82 296.725C142.93 296.765 143.04 296.835 143.16 296.865C143.53 296.965 143.9 297.015 144.28 297.015C144.66 297.015 145.03 296.965 145.4 296.865C145.5 296.835 145.59 296.775 145.69 296.745C145.95 296.655 146.21 296.565 146.45 296.435L251.36 236.035C252.72 235.255 253.55 233.815 253.55 232.245V174.885L303.81 145.945C305.17 145.165 306 143.725 306 142.155V82.265C305.95 81.875 305.89 81.495 305.8 81.125ZM144.2 227.205L100.57 202.515L146.39 176.135L196.66 147.195L240.33 172.335L208.29 190.625L144.2 227.205ZM244.75 114.995V164.795L226.39 154.225L201.03 139.625V89.825L219.39 100.395L244.75 114.995ZM249.12 57.105L292.81 82.265L249.12 107.425L205.43 82.265L249.12 57.105ZM114.49 184.425L96.13 194.995V85.305L121.49 70.705L139.85 60.135V169.815L114.49 184.425ZM91.76 27.425L135.45 52.585L91.76 77.745L48.07 52.585L91.76 27.425ZM43.67 60.135L62.03 70.705L87.39 85.305V202.545V202.555V202.565C87.39 202.735 87.44 202.895 87.46 203.055C87.49 203.265 87.49 203.485 87.55 203.695V203.705C87.6 203.875 87.69 204.035 87.76 204.195C87.84 204.375 87.89 204.575 87.99 204.745C87.99 204.745 87.99 204.755 88 204.755C88.09 204.905 88.22 205.035 88.33 205.175C88.45 205.335 88.55 205.495 88.69 205.635L88.7 205.645C88.82 205.765 88.98 205.855 89.12 205.965C89.28 206.085 89.42 206.225 89.59 206.325C89.6 206.325 89.6 206.325 89.61 206.335C89.62 206.335 89.62 206.345 89.63 206.345L139.87 234.775V285.065L43.67 229.705V60.135ZM244.75 229.705L148.58 285.075V234.775L219.8 194.115L244.75 179.875V229.705ZM297.2 139.625L253.49 164.795V114.995L278.85 100.395L297.21 89.825V139.625H297.2Z"
    })
  }));
}

/***/ }),

/***/ "./resources/js/Components/Checkbox.jsx":
/*!**********************************************!*\
  !*** ./resources/js/Components/Checkbox.jsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Checkbox)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["className"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var s = Object.getOwnPropertySymbols(e); for (r = 0; r < s.length; r++) o = s[r], t.includes(o) || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.includes(n)) continue; t[n] = r[n]; } return t; }
function Checkbox(_ref) {
  var _ref$className = _ref.className,
    className = _ref$className === void 0 ? "" : _ref$className,
    props = _objectWithoutProperties(_ref, _excluded);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", _objectSpread(_objectSpread({}, props), {}, {
    type: "checkbox",
    className: "rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500 " + className
  }));
}

/***/ }),

/***/ "./resources/js/Components/InputError.jsx":
/*!************************************************!*\
  !*** ./resources/js/Components/InputError.jsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InputError)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["message", "className"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var s = Object.getOwnPropertySymbols(e); for (r = 0; r < s.length; r++) o = s[r], t.includes(o) || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.includes(n)) continue; t[n] = r[n]; } return t; }
function InputError(_ref) {
  var message = _ref.message,
    _ref$className = _ref.className,
    className = _ref$className === void 0 ? "" : _ref$className,
    props = _objectWithoutProperties(_ref, _excluded);
  return message ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", _objectSpread(_objectSpread({}, props), {}, {
    className: "text-sm text-red-600 " + className,
    children: message
  })) : null;
}

/***/ }),

/***/ "./resources/js/Components/InputLabel.jsx":
/*!************************************************!*\
  !*** ./resources/js/Components/InputLabel.jsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InputLabel)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["value", "className", "children"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var s = Object.getOwnPropertySymbols(e); for (r = 0; r < s.length; r++) o = s[r], t.includes(o) || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.includes(n)) continue; t[n] = r[n]; } return t; }
function InputLabel(_ref) {
  var value = _ref.value,
    _ref$className = _ref.className,
    className = _ref$className === void 0 ? "" : _ref$className,
    children = _ref.children,
    props = _objectWithoutProperties(_ref, _excluded);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", _objectSpread(_objectSpread({}, props), {}, {
    className: "block font-medium text-sm text-gray-700 " + className,
    children: value ? value : children
  }));
}

/***/ }),

/***/ "./resources/js/Components/NavigationLink.jsx":
/*!****************************************************!*\
  !*** ./resources/js/Components/NavigationLink.jsx ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NavigationLink)
/* harmony export */ });
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["href", "children"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var s = Object.getOwnPropertySymbols(e); for (r = 0; r < s.length; r++) o = s[r], t.includes(o) || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.includes(n)) continue; t[n] = r[n]; } return t; }


function NavigationLink(_ref) {
  var href = _ref.href,
    children = _ref.children,
    props = _objectWithoutProperties(_ref, _excluded);
  var baseUrl = window.location.origin;
  var isInternalLink = href ? href.startsWith(baseUrl) : false;
  return isInternalLink ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_0__.Link, _objectSpread(_objectSpread({
    href: href
  }, props), {}, {
    children: children
  })) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", _objectSpread(_objectSpread({
    href: href
  }, props), {}, {
    children: children
  }));
}

/***/ }),

/***/ "./resources/js/Components/PrimaryButton.jsx":
/*!***************************************************!*\
  !*** ./resources/js/Components/PrimaryButton.jsx ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PrimaryButton)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["className", "disabled", "children"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var s = Object.getOwnPropertySymbols(e); for (r = 0; r < s.length; r++) o = s[r], t.includes(o) || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.includes(n)) continue; t[n] = r[n]; } return t; }
function PrimaryButton(_ref) {
  var _ref$className = _ref.className,
    className = _ref$className === void 0 ? "" : _ref$className,
    disabled = _ref.disabled,
    children = _ref.children,
    props = _objectWithoutProperties(_ref, _excluded);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", _objectSpread(_objectSpread({}, props), {}, {
    className: "inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150 ".concat(disabled && "opacity-25", " ") + className,
    disabled: disabled,
    children: children
  }));
}

/***/ }),

/***/ "./resources/js/Components/TextInput.jsx":
/*!***********************************************!*\
  !*** ./resources/js/Components/TextInput.jsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["type", "className", "isFocused"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var s = Object.getOwnPropertySymbols(e); for (r = 0; r < s.length; r++) o = s[r], t.includes(o) || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.includes(n)) continue; t[n] = r[n]; } return t; }


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function TextInput(_ref, ref) {
  var _ref$type = _ref.type,
    type = _ref$type === void 0 ? "text" : _ref$type,
    _ref$className = _ref.className,
    className = _ref$className === void 0 ? "" : _ref$className,
    _ref$isFocused = _ref.isFocused,
    isFocused = _ref$isFocused === void 0 ? false : _ref$isFocused,
    props = _objectWithoutProperties(_ref, _excluded);
  var input = ref ? ref : (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (isFocused) {
      input.current.focus();
    }
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("input", _objectSpread(_objectSpread({}, props), {}, {
    type: type,
    className: "border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm " + className,
    ref: input
  }));
}));

/***/ }),

/***/ "./resources/js/Frontend/Components/About/About1.jsx":
/*!***********************************************************!*\
  !*** ./resources/js/Frontend/Components/About/About1.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ About1)
/* harmony export */ });
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function About1(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "cs_shape_wrap_1",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "cs_shape_1"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "cs_section_heading cs_style_1",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_grid_style_4",
        children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
            className: "cs_grid_item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
              className: "cs_card cs_style_1 cs_shining",
              children: [item.feature_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                className: "cs_card_img cs_shining_item",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                  src: item.feature_image_url,
                  alt: "Thumb"
                })
              }), item.feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
                className: "cs_card_title cs_fs_30 cs_normal",
                dangerouslySetInnerHTML: {
                  __html: item.feature_title
                }
              }), item.feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
                className: "cs_card_subtitle",
                dangerouslySetInnerHTML: {
                  __html: item.feature_subtitle
                }
              }), (item.feature_btn_url || item.feature_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_0__["default"], {
                href: item.feature_btn_url,
                btnText: item.feature_btn_text,
                btnClass: "cs_btn cs_style_1 cs_type_1 cs_primary_color cs_shining_btn"
              })]
            })
          }, index);
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/About/About2.jsx":
/*!***********************************************************!*\
  !*** ./resources/js/Frontend/Components/About/About2.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ About2)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function About2(_ref) {
  var data = _ref.data;
  var image_url = data.image_url,
    section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    section_description = data.section_description,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: "row cs_gap_y_40",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "col-xl-5 col-lg-6",
        children: image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
          src: image_url,
          alt: section_title
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "col-lg-6 offset-xl-1",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_height_26 cs_height_lg_20"
            })]
          }), section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
              className: "mb-0",
              dangerouslySetInnerHTML: {
                __html: section_description
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_height_30 cs_height_lg_30"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", {
          className: "cs_list cs_style_1 cs_mp0",
          children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", {
              children: [(item.feature_title || item.feature_subtitle) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("i", {
                className: "cs_tick_icon cs_accent_color d-flex",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
                  width: 18,
                  height: 17,
                  viewBox: "0 0 18 17",
                  fill: "none",
                  xmlns: "http://www.w3.org/2000/svg",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
                    d: "M0 9.62275C0.0320847 8.83012 0.390363 8.2499 1.11227 7.93388C1.84487 7.61269 2.54004 7.73702 3.1443 8.25508C4.06406 9.0477 4.96777 9.85587 5.87684 10.6589C6.04796 10.8091 6.21908 10.9645 6.39554 11.1148C6.65757 11.3427 6.88751 11.3323 7.12279 11.0733C9.096 8.91819 11.0639 6.75789 13.0371 4.5976C14.3686 3.13668 15.7054 1.68094 17.037 0.220014C17.2027 0.0386945 17.3952 -0.0493752 17.6412 0.0283334C17.8498 0.0956808 18.0102 0.277001 17.9995 0.494585C17.9941 0.608557 17.946 0.732891 17.8819 0.831322C16.3685 3.19884 14.8552 5.56118 13.3419 7.92352C11.5986 10.6433 9.85534 13.3631 8.11207 16.0881C7.80727 16.5647 7.39551 16.8859 6.81264 16.974C6.15491 17.0776 5.60947 16.8704 5.19237 16.3782C3.69508 14.6116 2.20849 12.8399 0.716557 11.0681C0.433143 10.7469 0.133686 10.4257 0.0534744 9.98539C0.0267372 9.85587 0.0160423 9.73154 0 9.62275Z",
                    fill: "currentColor"
                  })
                })
              }), item.feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", {
                className: "cs_fs_24 cs_normal mb-0",
                dangerouslySetInnerHTML: {
                  __html: item.feature_title
                }
              }), item.feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
                dangerouslySetInnerHTML: {
                  __html: item.feature_subtitle
                }
              })]
            }, index);
          })
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/About/About3.jsx":
/*!***********************************************************!*\
  !*** ./resources/js/Frontend/Components/About/About3.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ About3)
/* harmony export */ });
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function About3(_ref) {
  var data = _ref.data;
  var image_url = data.image_url,
    section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    section_description = data.section_description,
    action_text = data.action_text,
    action_url = data.action_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "cs_cta cs_style_2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "cs_cta_left",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
          className: "cs_cta_uptitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_cta_title cs_bold cs_fs_60",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        }), section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
          className: "cs_cta_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_description
          }
        }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_0__["default"], {
          href: action_url,
          btnText: action_text,
          btnClass: "cs_btn cs_style_1 cs_type_4 cs_primary_color cs_fs_18 cs_medium"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_cta_right",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
          src: image_url,
          alt: section_title
        })
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/About/About4.jsx":
/*!***********************************************************!*\
  !*** ./resources/js/Frontend/Components/About/About4.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ About4)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function About4(_ref) {
  var data = _ref.data;
  var image_url = data.image_url,
    section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    section_description = data.section_description,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: "row align-items-center cs_gap_y_40",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "col-lg-6",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          className: "cs_image_card cs_style_2",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
            className: "cs_image_card_in",
            children: image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
              src: image_url,
              alt: section_title,
              className: "w-100"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
            className: "cs_shape_1 cs_accent_color",
            width: 148,
            height: 145,
            viewBox: "0 0 148 145",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("mask", {
              id: "mask0_10",
              style: {
                maskType: "luminance"
              },
              maskUnits: "userSpaceOnUse",
              x: 0,
              y: 0,
              width: 148,
              height: 145,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
                d: "M0.609375 51.478L99.2245 0.776666L147.089 93.8749L48.4743 144.576L0.609375 51.478Z",
                fill: "white"
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("g", {
              mask: "url(#mask0_10)",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
                d: "M51.6057 140.309C51.82 140.725 51.9057 141.196 51.8522 141.661C51.7986 142.126 51.6081 142.564 51.3048 142.921C51.0015 143.279 50.5991 143.538 50.1484 143.667C49.6978 143.795 49.2193 143.787 48.7736 143.644C48.1761 143.453 47.6795 143.033 47.3928 142.476C47.1043 141.916 47.049 141.265 47.2391 140.664C47.4291 140.063 47.849 139.561 48.4074 139.268C48.9711 138.986 49.6228 138.938 50.2214 139.133C50.82 139.328 51.3173 139.75 51.6057 140.309ZM65.0908 133.376C65.2996 133.793 65.38 134.263 65.322 134.726C65.2639 135.189 65.07 135.624 64.7646 135.977C64.459 136.331 64.0559 136.586 63.6059 136.712C63.1559 136.837 62.679 136.828 62.2349 136.684C61.7907 136.54 61.3994 136.267 61.1103 135.901C60.8213 135.534 60.6474 135.091 60.6108 134.625C60.5742 134.16 60.6763 133.694 60.9044 133.287C61.1325 132.879 61.4763 132.548 61.8924 132.335C62.1711 132.192 62.4752 132.105 62.7874 132.08C63.0996 132.054 63.4136 132.091 63.7113 132.188C64.0087 132.285 64.2837 132.44 64.5205 132.644C64.7573 132.848 64.9512 133.097 65.0908 133.376ZM78.5766 126.443C78.7854 126.86 78.8658 127.329 78.8078 127.792C78.7497 128.255 78.5558 128.691 78.2504 129.044C77.9448 129.397 77.5417 129.653 77.0917 129.778C76.6417 129.904 76.1648 129.894 75.7207 129.75C75.1999 129.582 74.7541 129.238 74.4592 128.777C74.1644 128.316 74.0388 127.768 74.1039 127.224C74.169 126.681 74.4208 126.177 74.8163 125.798C75.2118 125.419 75.7264 125.188 76.2725 125.146C76.5846 125.121 76.8983 125.159 77.1958 125.256C77.4932 125.353 77.7685 125.507 78.0059 125.711C78.2428 125.914 78.4364 126.163 78.5766 126.443ZM92.0654 119.508C92.2217 119.82 92.3068 120.162 92.3147 120.511C92.3226 120.86 92.253 121.207 92.111 121.526C91.969 121.845 91.758 122.128 91.4933 122.356C91.2285 122.584 90.9166 122.751 90.5799 122.845C90.13 122.969 89.6534 122.959 89.2098 122.814C88.7663 122.67 88.3754 122.398 88.0861 122.032C87.8701 121.758 87.7176 121.44 87.6395 121.1C87.5613 120.761 87.5594 120.408 87.634 120.067C87.7086 119.726 87.8578 119.406 88.0709 119.129C88.2839 118.852 88.5556 118.626 88.8663 118.467C89.145 118.323 89.4492 118.237 89.7613 118.211C90.0735 118.186 90.3875 118.223 90.6852 118.32C90.9827 118.416 91.2578 118.571 91.4948 118.775C91.7317 118.979 91.9257 119.228 92.0654 119.508ZM105.55 112.575C105.759 112.992 105.84 113.461 105.782 113.924C105.723 114.387 105.53 114.822 105.224 115.176C104.919 115.529 104.516 115.784 104.066 115.91C103.616 116.036 103.139 116.026 102.695 115.882C102.25 115.738 101.859 115.465 101.57 115.099C101.281 114.733 101.107 114.289 101.071 113.824C101.034 113.358 101.136 112.893 101.364 112.485C101.592 112.077 101.936 111.746 102.352 111.533C102.631 111.39 102.935 111.303 103.247 111.278C103.559 111.253 103.873 111.29 104.17 111.387C104.468 111.483 104.743 111.638 104.98 111.842C105.217 112.046 105.411 112.295 105.55 112.575ZM119.036 105.641C119.245 106.058 119.325 106.528 119.267 106.991C119.209 107.454 119.015 107.889 118.709 108.243C118.404 108.596 118.001 108.851 117.551 108.976C117.101 109.102 116.624 109.092 116.18 108.948C115.736 108.804 115.345 108.532 115.056 108.166C114.767 107.8 114.593 107.356 114.556 106.891C114.52 106.425 114.622 105.96 114.85 105.552C115.078 105.144 115.421 104.813 115.837 104.6C116.116 104.457 116.42 104.37 116.732 104.345C117.044 104.32 117.358 104.356 117.656 104.453C117.954 104.55 118.229 104.705 118.466 104.909C118.703 105.113 118.897 105.362 119.036 105.641ZM132.522 98.7077C132.704 99.072 132.789 99.4773 132.768 99.8843C132.748 100.291 132.622 100.686 132.404 101.031C132.185 101.375 131.881 101.658 131.522 101.85C131.162 102.043 130.759 102.14 130.351 102.132C129.943 102.123 129.545 102.009 129.194 101.801C128.843 101.594 128.553 101.299 128.35 100.945C128.147 100.592 128.039 100.192 128.037 99.7846C128.035 99.3771 128.138 98.9758 128.336 98.6195C128.604 98.1403 129.031 97.7686 129.542 97.5681C130.054 97.3675 130.619 97.3505 131.141 97.5199C131.439 97.6169 131.714 97.7718 131.951 97.9757C132.188 98.1795 132.382 98.4283 132.522 98.7077ZM146.007 91.7745C146.164 92.0863 146.249 92.429 146.257 92.7778C146.265 93.1266 146.195 93.473 146.053 93.792C145.911 94.111 145.7 94.3948 145.436 94.6228C145.171 94.8509 144.859 95.0176 144.522 95.1111C144.072 95.2364 143.596 95.2262 143.152 95.0817C142.708 94.9373 142.317 94.6649 142.028 94.299C141.739 93.933 141.565 93.4894 141.528 93.0243C141.491 92.5591 141.594 92.0934 141.822 91.686C141.993 91.3794 142.231 91.1147 142.517 90.911C142.804 90.7073 143.132 90.5696 143.478 90.508C143.824 90.4464 144.179 90.4624 144.518 90.5548C144.856 90.6472 145.17 90.8138 145.436 91.0424C145.673 91.2457 145.867 91.4944 146.007 91.7745ZM45.0765 127.61C45.2184 127.886 45.3044 128.187 45.3296 128.497C45.3549 128.806 45.3188 129.118 45.2236 129.414C45.1283 129.709 44.9757 129.984 44.7745 130.221C44.5732 130.458 44.3273 130.653 44.0507 130.795C43.7741 130.937 43.4722 131.023 43.1624 131.049C42.8526 131.075 42.5408 131.039 42.2449 130.945C41.9489 130.85 41.6747 130.698 41.4377 130.497C41.2008 130.296 41.0058 130.051 40.8639 129.775C40.5773 129.217 40.5244 128.568 40.7168 127.971C40.9092 127.374 41.3311 126.877 41.8897 126.59C42.4483 126.303 43.0979 126.249 43.6955 126.44C44.2932 126.632 44.7899 127.052 45.0765 127.61ZM58.5623 120.676C58.7041 120.953 58.7901 121.254 58.8153 121.564C58.8405 121.873 58.8044 122.185 58.7091 122.481C58.6138 122.776 58.4611 123.051 58.2598 123.288C58.0584 123.525 57.8124 123.72 57.5357 123.862C57.2591 124.004 56.9572 124.09 56.6472 124.116C56.3373 124.142 56.0255 124.106 55.7295 124.011C55.4336 123.916 55.1593 123.764 54.9224 123.563C54.6854 123.363 54.4904 123.117 54.3486 122.841C54.2067 122.565 54.1207 122.263 54.0956 121.954C54.0704 121.644 54.1065 121.333 54.2018 121.037C54.2971 120.741 54.4497 120.467 54.651 120.23C54.8523 119.993 55.0983 119.798 55.3749 119.656C55.6515 119.514 55.9534 119.428 56.2633 119.402C56.5731 119.377 56.8849 119.412 57.1808 119.507C57.4767 119.602 57.7509 119.754 57.9878 119.955C58.2247 120.155 58.4197 120.401 58.5615 120.677L58.5623 120.676ZM72.0473 113.743C72.1963 114.02 72.2884 114.324 72.3185 114.637C72.3485 114.949 72.3158 115.265 72.2222 115.565C72.1287 115.866 71.9761 116.144 71.7736 116.385C71.571 116.626 71.3225 116.824 71.0425 116.968C70.7625 117.112 70.4567 117.199 70.143 117.223C69.8292 117.248 69.5138 117.209 69.2152 117.111C68.9166 117.012 68.6408 116.855 68.4039 116.648C68.167 116.442 67.9738 116.19 67.8355 115.908C67.549 115.35 67.496 114.701 67.6884 114.104C67.8808 113.507 68.3027 113.01 68.8613 112.723C69.4199 112.436 70.0695 112.382 70.6671 112.573C71.2648 112.765 71.7608 113.186 72.0473 113.743ZM85.5362 106.808C85.6781 107.084 85.7641 107.386 85.7894 107.695C85.8146 108.005 85.7786 108.316 85.6833 108.612C85.5881 108.908 85.4355 109.182 85.2342 109.419C85.033 109.656 84.787 109.851 84.5104 109.993C84.2338 110.135 83.932 110.222 83.6221 110.247C83.3123 110.273 83.0005 110.238 82.7046 110.143C82.4087 110.048 82.1344 109.896 81.8975 109.695C81.6605 109.495 81.4655 109.249 81.3236 108.973C81.0371 108.415 80.9842 107.767 81.1765 107.169C81.3689 106.572 81.7908 106.075 82.3494 105.788C82.908 105.501 83.5576 105.447 84.1553 105.639C84.7529 105.83 85.2496 106.251 85.5362 106.808ZM99.0213 99.8752C99.1702 100.152 99.2624 100.455 99.2924 100.768C99.3224 101.081 99.2897 101.397 99.1961 101.697C99.1026 101.998 98.9501 102.276 98.7475 102.517C98.5449 102.758 98.2964 102.956 98.0164 103.1C97.7365 103.244 97.4307 103.331 97.1169 103.355C96.8032 103.38 96.4878 103.341 96.1892 103.243C95.8906 103.144 95.6148 102.987 95.3779 102.78C95.1409 102.574 94.9477 102.322 94.8095 102.04C94.6676 101.764 94.5815 101.462 94.5563 101.153C94.531 100.843 94.5671 100.532 94.6623 100.236C94.7576 99.9401 94.9102 99.6659 95.1114 99.4289C95.3127 99.1919 95.5586 98.9968 95.8352 98.8547C96.1118 98.7125 96.4137 98.6261 96.7235 98.6005C97.0334 98.5748 97.3451 98.6104 97.6411 98.7051C97.937 98.7998 98.2112 98.9519 98.4482 99.1526C98.6851 99.3532 98.8794 99.5991 99.0213 99.8752ZM112.507 92.9416C112.656 93.2183 112.748 93.522 112.778 93.8348C112.808 94.1477 112.776 94.4635 112.682 94.7638C112.588 95.064 112.436 95.3427 112.233 95.5836C112.031 95.8244 111.782 96.0226 111.502 96.1665C111.222 96.3103 110.916 96.3971 110.603 96.4216C110.289 96.446 109.974 96.4078 109.675 96.3091C109.376 96.2103 109.101 96.0531 108.864 95.8465C108.627 95.64 108.434 95.3883 108.295 95.1061C108.009 94.5485 107.956 93.8997 108.148 93.3024C108.341 92.7051 108.762 92.2082 109.321 91.9211C109.88 91.6341 110.529 91.5803 111.127 91.7716C111.725 91.9629 112.22 92.384 112.507 92.9416ZM125.993 86.0081C126.153 86.319 126.242 86.6615 126.253 87.011C126.264 87.3605 126.198 87.7083 126.058 88.0292C125.919 88.3502 125.71 88.6363 125.447 88.8671C125.183 89.0978 124.872 89.2674 124.535 89.3635C124.085 89.492 123.607 89.4845 123.161 89.3421C122.716 89.1996 122.323 88.9286 122.031 88.5631C121.813 88.2897 121.659 87.9713 121.579 87.6309C121.5 87.2904 121.497 86.9365 121.571 86.5946C121.645 86.2527 121.795 85.9315 122.008 85.6541C122.222 85.3767 122.494 85.15 122.806 84.9905C123.364 84.7034 124.014 84.6494 124.611 84.8402C125.209 85.031 125.706 85.4511 125.993 86.0081ZM139.478 79.075C139.638 79.3859 139.727 79.7284 139.738 80.0779C139.75 80.4275 139.683 80.7753 139.544 81.0963C139.404 81.4173 139.195 81.7035 138.932 81.9342C138.668 82.1649 138.357 82.3344 138.02 82.4304C137.57 82.5587 137.092 82.5512 136.646 82.4088C136.201 82.2663 135.808 81.9954 135.516 81.63C135.225 81.2641 135.049 80.82 135.012 80.3539C134.974 79.8879 135.075 79.4209 135.303 79.0121C135.511 78.637 135.817 78.3253 136.188 78.1103C136.56 77.8954 136.982 77.7852 137.411 77.7917C137.84 77.7982 138.259 77.921 138.623 78.147C138.987 78.3731 139.283 78.6939 139.478 79.075ZM38.5472 114.91C38.7073 115.221 38.7962 115.564 38.8075 115.913C38.8189 116.263 38.7524 116.611 38.6129 116.932C38.4734 117.253 38.2644 117.539 38.0009 117.769C37.7374 118 37.426 118.169 37.0892 118.265C36.7528 118.361 36.3995 118.382 36.0546 118.325C35.7096 118.268 35.3816 118.136 35.0941 117.938C34.8065 117.739 34.5666 117.48 34.3916 117.178C34.2166 116.876 34.1107 116.538 34.0817 116.19C34.0563 115.881 34.0922 115.569 34.1873 115.273C34.2825 114.978 34.4352 114.703 34.6365 114.466C34.8378 114.229 35.0838 114.034 35.3606 113.892C35.6373 113.75 35.9392 113.664 36.2492 113.638C36.7156 113.6 37.1829 113.7 37.592 113.927C38.0011 114.153 38.3332 114.495 38.5472 114.91ZM52.033 107.977C52.1929 108.288 52.2817 108.63 52.293 108.98C52.3043 109.329 52.2378 109.677 52.0983 109.998C51.9588 110.319 51.7498 110.605 51.4864 110.835C51.223 111.066 50.9117 111.236 50.575 111.332C50.2385 111.428 49.8851 111.448 49.5399 111.392C49.1948 111.335 48.8666 111.203 48.579 111.005C48.2913 110.806 48.0513 110.547 47.8762 110.244C47.7011 109.942 47.5953 109.605 47.5664 109.257C47.5409 108.947 47.5768 108.635 47.672 108.34C47.7672 108.044 47.9198 107.769 48.1211 107.532C48.3224 107.295 48.5685 107.1 48.8452 106.958C49.1219 106.816 49.4239 106.73 49.7338 106.705C50.2004 106.666 50.6678 106.766 51.077 106.992C51.4862 107.219 51.8189 107.561 52.033 107.977ZM65.5181 101.044C65.6781 101.355 65.767 101.697 65.7784 102.047C65.7898 102.396 65.7233 102.744 65.5838 103.065C65.4443 103.386 65.2352 103.672 64.9717 103.903C64.7082 104.133 64.3968 104.303 64.06 104.398C63.7236 104.495 63.3702 104.515 63.0251 104.458C62.6801 104.402 62.352 104.27 62.0644 104.071C61.7768 103.873 61.5369 103.613 61.3619 103.311C61.1869 103.008 61.0811 102.671 61.0522 102.323C61.0267 102.013 61.0626 101.702 61.1578 101.406C61.253 101.11 61.4056 100.836 61.6069 100.599C61.8082 100.362 62.0543 100.167 62.331 100.025C62.6077 99.8827 62.9097 99.7965 63.2196 99.7711C63.6861 99.7324 64.1534 99.8327 64.5625 100.059C64.9715 100.286 65.3041 100.628 65.5181 101.044ZM79.007 94.1088C79.167 94.4196 79.2559 94.7621 79.2673 95.1116C79.2786 95.4611 79.2122 95.8089 79.0727 96.1299C78.9332 96.4508 78.7241 96.7369 78.4606 96.9675C78.1971 97.1981 77.8857 97.3675 77.5489 97.4634C77.2125 97.5596 76.859 97.5802 76.5139 97.5237C76.1688 97.4671 75.8406 97.3349 75.553 97.1364C75.2654 96.9379 75.0254 96.6782 74.8504 96.3759C74.6755 96.0735 74.5698 95.7361 74.541 95.3879C74.509 95.0002 74.5733 94.6105 74.7282 94.2533C74.8831 93.8961 75.1238 93.5825 75.4289 93.3403C75.7341 93.0981 76.0942 92.9348 76.4775 92.8649C76.8607 92.7949 77.2551 92.8205 77.6258 92.9394C77.9217 93.034 78.196 93.186 78.433 93.3866C78.67 93.5873 78.865 93.8327 79.007 94.1088ZM92.492 87.1756C92.652 87.4864 92.7409 87.829 92.7523 88.1785C92.7637 88.528 92.6972 88.8758 92.5577 89.1967C92.4182 89.5177 92.2092 89.8038 91.9456 90.0344C91.6821 90.265 91.3707 90.4344 91.0339 90.5303C90.6975 90.6265 90.344 90.6471 89.9989 90.5906C89.6538 90.534 89.3257 90.4018 89.038 90.2033C88.7504 90.0048 88.5105 89.7451 88.3355 89.4428C88.1605 89.1404 88.0549 88.803 88.0261 88.4548C88.0006 88.1453 88.0365 87.8337 88.1317 87.5378C88.2269 87.242 88.3795 86.9677 88.5809 86.7307C88.7822 86.4937 89.0282 86.2986 89.3049 86.1565C89.5817 86.0145 89.8836 85.9283 90.1936 85.9029C90.66 85.8642 91.1273 85.9645 91.5364 86.191C91.9455 86.4175 92.278 86.7602 92.492 87.1756ZM105.978 80.2421C106.138 80.5529 106.227 80.8955 106.238 81.245C106.249 81.5945 106.183 81.9423 106.044 82.2632C105.904 82.5842 105.695 82.8703 105.431 83.1009C105.168 83.3315 104.857 83.5009 104.52 83.5968C104.183 83.6928 103.83 83.7133 103.485 83.6567C103.14 83.6001 102.812 83.4678 102.524 83.2694C102.237 83.0709 101.997 82.8113 101.822 82.509C101.647 82.2068 101.541 81.8694 101.512 81.5213C101.486 81.2118 101.522 80.9002 101.618 80.6043C101.713 80.3085 101.865 80.0342 102.067 79.7972C102.268 79.5602 102.514 79.3651 102.791 79.223C103.067 79.081 103.369 78.9948 103.679 78.9694C104.146 78.9307 104.613 79.031 105.022 79.2575C105.431 79.484 105.764 79.8267 105.978 80.2421ZM119.464 73.3086C119.678 73.7243 119.763 74.1942 119.709 74.6588C119.655 75.1235 119.465 75.5619 119.161 75.9185C118.858 76.2748 118.456 76.5335 118.006 76.6621C117.556 76.7907 117.079 76.7834 116.633 76.6411C116.188 76.4989 115.795 76.228 115.503 75.8626C115.212 75.4973 115.036 75.0538 114.997 74.5882C114.954 74.0433 115.1 73.5 115.412 73.0504C115.724 72.6009 116.182 72.2729 116.708 72.1222C117.235 71.9714 117.797 72.0072 118.299 72.2235C118.801 72.4398 119.213 72.8232 119.464 73.3086ZM132.949 66.3755C133.163 66.7911 133.248 67.2611 133.194 67.7257C133.141 68.1904 132.95 68.6288 132.646 68.9854C132.266 69.4314 131.733 69.7205 131.151 69.7969C130.57 69.8732 129.981 69.7312 129.499 69.3984C129.017 69.0657 128.676 68.5658 128.542 67.9957C128.408 67.4256 128.49 66.8258 128.774 66.3126C128.982 65.9384 129.289 65.6277 129.66 65.4135C130.031 65.1993 130.453 65.0896 130.882 65.096C131.31 65.1025 131.729 65.2249 132.093 65.4502C132.457 65.6755 132.752 65.9953 132.949 66.3755ZM32.018 102.211C32.178 102.522 32.2669 102.864 32.2783 103.214C32.2896 103.563 32.2232 103.911 32.0837 104.232C31.9442 104.553 31.7351 104.839 31.4716 105.07C31.2081 105.3 30.8967 105.47 30.5599 105.566C30.2236 105.662 29.8703 105.682 29.5253 105.625C29.1804 105.569 28.8523 105.437 28.5648 105.238C28.2773 105.04 28.0374 104.78 27.8624 104.478C27.6873 104.176 27.5815 103.839 27.5524 103.491C27.5142 103.025 27.6154 102.557 27.8432 102.148C28.0709 101.739 28.415 101.407 28.8318 101.193C29.3903 100.906 30.0396 100.852 30.6371 101.043C31.2346 101.234 31.731 101.654 32.018 102.211ZM45.5038 95.2774C45.6637 95.5883 45.7524 95.9308 45.7637 96.2802C45.775 96.6297 45.7085 96.9774 45.569 97.2983C45.4296 97.6192 45.2206 97.9053 44.9572 98.136C44.6937 98.3666 44.3824 98.5361 44.0457 98.6321C43.7093 98.7283 43.3558 98.7489 43.0107 98.6923C42.6656 98.6358 42.3374 98.5036 42.0497 98.3052C41.762 98.1068 41.522 97.8471 41.347 97.5448C41.1719 97.2426 41.0661 96.9052 41.0371 96.557C40.9989 96.0908 41.1001 95.6236 41.3278 95.2145C41.5556 94.8054 41.8996 94.4729 42.3164 94.2591C42.875 93.9722 43.5244 93.9183 44.122 94.1092C44.7196 94.3001 45.2166 94.7203 45.5038 95.2774ZM58.9888 88.3443C59.1489 88.6551 59.2378 88.9977 59.2491 89.3472C59.2605 89.6967 59.194 90.0445 59.0545 90.3654C58.915 90.6864 58.706 90.9725 58.4425 91.2031C58.179 91.4337 57.8676 91.6031 57.5308 91.699C57.1944 91.795 56.8409 91.8155 56.4959 91.7589C56.1508 91.7023 55.8227 91.57 55.5351 91.3716C55.2476 91.1731 55.0076 90.9135 54.8326 90.6112C54.6576 90.309 54.5518 89.9716 54.5229 89.6235C54.4847 89.1573 54.5859 88.6901 54.8136 88.281C55.0414 87.8719 55.3855 87.5394 55.8023 87.3256C56.3607 87.0387 57.0101 86.9848 57.6076 87.1759C58.2051 87.3669 58.7019 87.7872 58.9888 88.3443ZM72.4777 81.4092C72.6377 81.72 72.7267 82.0626 72.738 82.4121C72.7494 82.7616 72.6829 83.1094 72.5434 83.4303C72.4039 83.7513 72.1949 84.0374 71.9314 84.268C71.6678 84.4986 71.3564 84.668 71.0197 84.7639C70.6832 84.8601 70.3298 84.8807 69.9846 84.8242C69.6395 84.7676 69.3114 84.6354 69.0237 84.4369C68.7361 84.2384 68.4962 83.9787 68.3212 83.6764C68.1462 83.374 68.0406 83.0366 68.0118 82.6884C67.9799 82.3007 68.0443 81.911 68.1993 81.5539C68.3542 81.1968 68.595 80.8833 68.9001 80.6411C69.2053 80.399 69.5655 80.2358 69.9487 80.1659C70.3319 80.0961 70.7263 80.1217 71.0969 80.2407C71.6946 80.4312 72.1913 80.8522 72.4777 81.4092ZM85.9628 74.4761C86.1228 74.7869 86.2117 75.1295 86.2231 75.479C86.2344 75.8285 86.168 76.1763 86.0285 76.4972C85.889 76.8182 85.6799 77.1043 85.4164 77.3349C85.1529 77.5655 84.8415 77.7349 84.5047 77.8308C84.1683 77.927 83.8148 77.9476 83.4697 77.891C83.1246 77.8345 82.7964 77.7023 82.5088 77.5038C82.2212 77.3053 81.9812 77.0456 81.8063 76.7432C81.6313 76.4409 81.5256 76.1035 81.4968 75.7553C81.4586 75.2891 81.5598 74.8219 81.7876 74.4128C82.0153 74.0037 82.3594 73.6712 82.7762 73.4574C83.3347 73.1707 83.9839 73.117 84.5814 73.308C85.1788 73.499 85.6756 73.9191 85.9628 74.4761ZM99.4486 67.5426C99.6086 67.8534 99.6975 68.196 99.7089 68.5455C99.7202 68.895 99.6538 69.2428 99.5143 69.5637C99.3748 69.8847 99.1657 70.1708 98.9022 70.4014C98.6387 70.632 98.3273 70.8014 97.9905 70.8973C97.6541 70.9933 97.3007 71.0138 96.9556 70.9572C96.6106 70.9006 96.2825 70.7683 95.9949 70.5699C95.7073 70.3714 95.4674 70.1118 95.2924 69.8095C95.1173 69.5073 95.0116 69.1699 94.9826 68.8218C94.9572 68.5122 94.9931 68.2007 95.0883 67.9048C95.1835 67.609 95.3361 67.3347 95.5374 67.0977C95.7387 66.8607 95.9848 66.6656 96.2615 66.5235C96.5382 66.3815 96.8402 66.2953 97.1501 66.2698C97.6166 66.2312 98.0839 66.3314 98.4929 66.558C98.902 66.7845 99.2346 67.1271 99.4486 67.5426ZM112.934 60.6091C113.148 61.0248 113.234 61.4947 113.18 61.9593C113.126 62.424 112.936 62.8624 112.632 63.219C112.329 63.5753 111.927 63.834 111.477 63.9626C111.027 64.0912 110.549 64.0839 110.104 63.9416C109.658 63.7993 109.265 63.5285 108.974 63.1631C108.683 62.7978 108.507 62.3543 108.468 61.8887C108.424 61.3438 108.571 60.8005 108.883 60.3509C109.195 59.9014 109.653 59.5734 110.179 59.4227C110.705 59.2719 111.267 59.3077 111.77 59.524C112.272 59.7403 112.683 60.1237 112.934 60.6091ZM126.419 53.676C126.633 54.0916 126.719 54.5616 126.665 55.0262C126.611 55.4909 126.421 55.9293 126.117 56.2859C125.736 56.7319 125.204 57.021 124.622 57.0973C124.041 57.1737 123.452 57.0317 122.97 56.6989C122.487 56.3662 122.146 55.8663 122.012 55.2962C121.878 54.7261 121.961 54.1263 122.245 53.613C122.453 53.2389 122.759 52.9282 123.131 52.714C123.502 52.4998 123.924 52.3901 124.353 52.3965C124.781 52.403 125.199 52.5254 125.563 52.7507C125.927 52.976 126.223 53.2958 126.419 53.676ZM25.4887 89.5114C25.6488 89.8222 25.7377 90.1648 25.749 90.5143C25.7604 90.8638 25.6939 91.2116 25.5544 91.5325C25.4149 91.8535 25.2059 92.1396 24.9424 92.3702C24.6789 92.6008 24.3675 92.7702 24.0307 92.8661C23.6943 92.9621 23.341 92.9825 22.9961 92.9259C22.6511 92.8693 22.3231 92.7371 22.0356 92.5387C21.7481 92.3404 21.5082 92.0808 21.3331 91.7787C21.1581 91.4766 21.0522 91.1394 21.0232 90.7914C20.9913 90.4037 21.0557 90.014 21.2107 89.6569C21.3656 89.2997 21.6064 88.9862 21.9116 88.7441C22.2167 88.502 22.5769 88.3387 22.9601 88.2689C23.3433 88.199 23.7377 88.2247 24.1083 88.3436C24.706 88.5342 25.2023 88.9544 25.4887 89.5114ZM38.9749 82.5787C39.1348 82.8895 39.2236 83.232 39.2349 83.5815C39.2462 83.931 39.1797 84.2787 39.0402 84.5996C38.9007 84.9205 38.6917 85.2066 38.4283 85.4372C38.1649 85.6679 37.8536 85.8373 37.5169 85.9333C37.1804 86.0295 36.827 86.0501 36.4818 85.9936C36.1367 85.9371 35.8085 85.8048 35.5209 85.6064C35.2332 85.408 34.9932 85.1484 34.8181 84.8461C34.643 84.5438 34.5372 84.2065 34.5083 83.8582C34.47 83.3921 34.5712 82.9248 34.799 82.5158C35.0267 82.1067 35.3708 81.7742 35.7876 81.5603C36.346 81.2735 36.9952 81.2195 37.5927 81.4103C38.1902 81.6011 38.6876 82.0218 38.9749 82.5787ZM52.46 75.6456C52.62 75.9564 52.7089 76.2989 52.7203 76.6484C52.7317 76.9979 52.6652 77.3457 52.5257 77.6667C52.3862 77.9876 52.1771 78.2737 51.9136 78.5043C51.6501 78.735 51.3387 78.9043 51.0019 79.0002C50.6655 79.0963 50.3121 79.1167 49.967 79.0601C49.622 79.0035 49.2939 78.8713 49.0063 78.6728C48.7187 78.4744 48.4788 78.2147 48.3038 77.9125C48.1288 77.6102 48.023 77.2729 47.9941 76.9247C47.9559 76.4586 48.057 75.9913 48.2848 75.5823C48.5125 75.1732 48.8566 74.8407 49.2734 74.6268C49.8317 74.34 50.4809 74.2861 51.0783 74.477C51.6757 74.6679 52.1729 75.0886 52.46 75.6456ZM65.9489 68.7105C66.1089 69.0213 66.1978 69.3638 66.2092 69.7133C66.2205 70.0628 66.1541 70.4106 66.0146 70.7316C65.8751 71.0525 65.666 71.3387 65.4025 71.5693C65.139 71.7999 64.8276 71.9692 64.4908 72.0651C64.1544 72.1614 63.8009 72.1819 63.4558 72.1254C63.1107 72.0689 62.7825 71.9366 62.4949 71.7382C62.2073 71.5397 61.9673 71.2799 61.7924 70.9776C61.6174 70.6753 61.5117 70.3379 61.4829 69.9897C61.4509 69.602 61.5152 69.2122 61.6701 68.855C61.825 68.4979 62.0657 68.1842 62.3708 67.942C62.676 67.6998 63.0361 67.5365 63.4194 67.4666C63.8026 67.3967 64.197 67.4223 64.5677 67.5412C65.1657 67.7325 65.6624 68.1534 65.9489 68.7105ZM79.4339 61.7774C79.5939 62.0882 79.6828 62.4307 79.6942 62.7802C79.7056 63.1297 79.6391 63.4775 79.4996 63.7985C79.3601 64.1194 79.1511 64.4055 78.8875 64.6361C78.624 64.8668 78.3126 65.0361 77.9758 65.132C77.6394 65.2282 77.286 65.2488 76.9408 65.1923C76.5957 65.1358 76.2676 65.0035 75.9799 64.805C75.6923 64.6066 75.4524 64.3468 75.2774 64.0445C75.1024 63.7422 74.9968 63.4048 74.968 63.0565C74.9298 62.5904 75.031 62.1231 75.2587 61.7141C75.4865 61.305 75.8305 60.9725 76.2473 60.7586C76.8057 60.472 77.4548 60.4183 78.0521 60.6091C78.6494 60.8 79.1466 61.2206 79.4339 61.7774ZM92.9197 54.8439C93.0798 55.1547 93.1687 55.4972 93.18 55.8467C93.1914 56.1962 93.1249 56.544 92.9854 56.865C92.8459 57.1859 92.6369 57.472 92.3734 57.7026C92.1098 57.9333 91.7985 58.1026 91.4617 58.1985C91.1253 58.2946 90.7718 58.315 90.4268 58.2584C90.0817 58.2018 89.7536 58.0696 89.466 57.8711C89.1784 57.6727 88.9385 57.413 88.7635 57.1108C88.5885 56.8085 88.4827 56.4712 88.4538 56.123C88.4284 55.8135 88.4643 55.5019 88.5595 55.2061C88.6546 54.9102 88.8073 54.6359 89.0086 54.3989C89.2099 54.1619 89.4559 53.9668 89.7327 53.8247C90.0094 53.6827 90.3113 53.5965 90.6213 53.5711C91.0876 53.5324 91.5547 53.6326 91.9637 53.859C92.3727 54.0854 92.7056 54.4286 92.9197 54.8439ZM106.405 47.9096C106.619 48.3253 106.705 48.7952 106.651 49.2598C106.597 49.7245 106.406 50.1629 106.103 50.5195C105.8 50.8757 105.398 51.1345 104.948 51.2631C104.498 51.3917 104.02 51.3844 103.575 51.2421C103.129 51.0998 102.736 50.8289 102.445 50.4636C102.154 50.0982 101.978 49.6548 101.938 49.1892C101.907 48.8016 101.972 48.4122 102.127 48.0554C102.283 47.6986 102.523 47.3853 102.829 47.1433C103.134 46.9013 103.493 46.738 103.876 46.6679C104.259 46.5977 104.654 46.6228 105.024 46.741C105.621 46.932 106.119 47.3525 106.405 47.9096ZM119.891 40.9772C120.105 41.3929 120.19 41.8628 120.136 42.3275C120.083 42.7921 119.892 43.2306 119.588 43.5871C119.285 43.9435 118.883 44.2024 118.433 44.3311C117.983 44.4598 117.505 44.4525 117.06 44.3101C116.615 44.1678 116.222 43.8967 115.931 43.5312C115.639 43.1657 115.463 42.7221 115.425 42.2564C115.393 41.8689 115.458 41.4795 115.613 41.1226C115.768 40.7658 116.009 40.4525 116.314 40.2104C116.619 39.9683 116.979 39.805 117.362 39.7348C117.745 39.6646 118.139 39.6897 118.509 39.8079C119.107 39.9992 119.604 40.4202 119.891 40.9772ZM18.9128 76.7211C19.0728 77.0319 19.1617 77.3744 19.1731 77.724C19.1845 78.0735 19.118 78.4213 18.9785 78.7422C18.839 79.0632 18.63 79.3493 18.3664 79.5799C18.1029 79.8105 17.7915 79.9799 17.4547 80.0757C17.1183 80.1718 16.7649 80.1923 16.4198 80.1357C16.0748 80.0791 15.7467 79.9468 15.4591 79.7484C15.1715 79.5499 14.9316 79.2903 14.7566 78.988C14.5816 78.6858 14.4758 78.3484 14.4469 78.0003C14.415 77.6126 14.4794 77.2229 14.6344 76.8658C14.7893 76.5087 15.0301 76.1951 15.3352 75.953C15.6404 75.7109 16.0006 75.5476 16.3838 75.4778C16.767 75.4079 17.1614 75.4336 17.532 75.5525C17.8279 75.6469 18.1022 75.7987 18.3391 75.9993C18.576 76.1998 18.771 76.4451 18.9128 76.7211ZM32.3986 69.7876C32.5585 70.0984 32.6473 70.4409 32.6585 70.7904C32.6698 71.1399 32.6033 71.4876 32.4639 71.8085C32.3244 72.1294 32.1154 72.4155 31.852 72.6461C31.5886 72.8768 31.2773 73.0462 30.9406 73.1422C30.6041 73.2384 30.2506 73.259 29.9055 73.2025C29.5604 73.146 29.2322 73.0138 28.9445 72.8154C28.6569 72.6169 28.4169 72.3573 28.2418 72.055C28.0667 71.7527 27.9609 71.4154 27.9319 71.0672C27.8938 70.601 27.9951 70.1338 28.2228 69.7248C28.4505 69.3157 28.7945 68.9832 29.2113 68.7692C29.7698 68.4823 30.4192 68.4284 31.0168 68.6194C31.6144 68.8103 32.1114 69.2305 32.3986 69.7876ZM45.8837 62.8545C46.0437 63.1653 46.1326 63.5078 46.144 63.8573C46.1553 64.2068 46.0889 64.5546 45.9494 64.8756C45.8099 65.1965 45.6008 65.4826 45.3373 65.7133C45.0738 65.9439 44.7624 66.1132 44.4256 66.2091C44.0892 66.3052 43.7358 66.3257 43.3907 66.2691C43.0457 66.2124 42.7175 66.0802 42.43 65.8817C42.1424 65.6833 41.9025 65.4236 41.7274 65.1214C41.5524 64.8191 41.4467 64.4818 41.4177 64.1337C41.3859 63.746 41.4502 63.3563 41.6052 62.9992C41.7602 62.642 42.0009 62.3285 42.3061 62.0864C42.6113 61.8443 42.9714 61.681 43.3546 61.6112C43.7378 61.5413 44.1322 61.567 44.5029 61.6859C44.7988 61.7803 45.073 61.9321 45.31 62.1326C45.5469 62.3332 45.7419 62.5785 45.8837 62.8545ZM59.3725 55.9194C59.5326 56.2302 59.6215 56.5727 59.6328 56.9222C59.6442 57.2718 59.5777 57.6196 59.4382 57.9405C59.2987 58.2615 59.0897 58.5476 58.8262 58.7782C58.5627 59.0088 58.2513 59.1782 57.9145 59.274C57.5781 59.3703 57.2246 59.3909 56.8795 59.3343C56.5343 59.2778 56.2062 59.1455 55.9186 58.9471C55.6309 58.7486 55.391 58.4889 55.216 58.1865C55.0411 57.8842 54.9354 57.5468 54.9066 57.1986C54.8622 56.6535 55.0084 56.1095 55.3202 55.6595C55.632 55.2094 56.0902 54.881 56.6167 54.7302C57.1433 54.5794 57.7056 54.6155 58.208 54.8324C58.7103 55.0494 59.1223 55.4332 59.3725 55.9194ZM72.8576 48.9863C73.0176 49.2971 73.1065 49.6396 73.1179 49.9891C73.1292 50.3386 73.0628 50.6864 72.9233 51.0074C72.7838 51.3283 72.5747 51.6145 72.3112 51.8451C72.0477 52.0757 71.7363 52.245 71.3995 52.3409C71.0631 52.4372 70.7096 52.4577 70.3645 52.4012C70.0194 52.3447 69.6912 52.2124 69.4036 52.0139C69.116 51.8155 68.8761 51.5557 68.7011 51.2534C68.5261 50.9511 68.4204 50.6137 68.3917 50.2655C68.3598 49.8778 68.4242 49.4881 68.5791 49.131C68.7341 48.7738 68.9748 48.4603 69.28 48.2182C69.5852 47.9761 69.9453 47.8128 70.3285 47.743C70.7118 47.6731 71.1062 47.6988 71.4768 47.8177C71.7727 47.9121 72.0469 48.0639 72.2839 48.2644C72.5208 48.465 72.7158 48.7103 72.8576 48.9863ZM86.3434 42.0528C86.5034 42.3636 86.5923 42.7061 86.6037 43.0556C86.6151 43.4051 86.5486 43.7529 86.4091 44.0739C86.2696 44.3948 86.0605 44.6809 85.797 44.9116C85.5335 45.1422 85.2221 45.3115 84.8853 45.4074C84.5489 45.5035 84.1955 45.524 83.8504 45.4674C83.5054 45.4107 83.1773 45.2785 82.8897 45.08C82.6021 44.8816 82.3622 44.6219 82.1872 44.3197C82.0122 44.0174 81.9064 43.6801 81.8775 43.3319C81.8521 43.0224 81.8881 42.7109 81.9834 42.4151C82.0786 42.1193 82.2312 41.8451 82.4325 41.6081C82.6338 41.3711 82.8798 41.176 83.1565 41.0339C83.4331 40.8918 83.7351 40.8055 84.0449 40.78C84.5114 40.7413 84.9787 40.8416 85.3878 41.0681C85.7968 41.2947 86.1294 41.6373 86.3434 42.0528ZM99.8292 35.1193C100.043 35.5349 100.129 36.0049 100.075 36.4695C100.021 36.9341 99.8303 37.3726 99.527 37.7292C99.3002 37.9957 99.0173 38.2089 98.6985 38.3534C98.3796 38.4978 98.0328 38.5701 97.683 38.5648C97.3331 38.5596 96.9889 38.477 96.675 38.323C96.3611 38.169 96.0853 37.9475 95.8675 37.6742C95.6496 37.4009 95.4953 37.0824 95.4158 36.742C95.3362 36.4016 95.3334 36.0476 95.4076 35.7057C95.4817 35.3639 95.631 35.0426 95.8445 34.7652C96.058 34.4878 96.3305 34.2612 96.6422 34.1017C97.2007 33.8151 97.8498 33.7612 98.4473 33.952C99.0447 34.1428 99.5417 34.5625 99.8292 35.1193ZM113.314 28.1862C113.528 28.6018 113.614 29.0717 113.56 29.5364C113.506 30.0011 113.315 30.4395 113.012 30.796C112.709 31.1525 112.307 31.4113 111.857 31.54C111.407 31.6687 110.929 31.6614 110.484 31.519C110.038 31.3767 109.645 31.1056 109.354 30.7401C109.063 30.3746 108.887 29.931 108.848 29.4653C108.817 29.0779 108.882 28.6886 109.038 28.3319C109.193 27.9753 109.433 27.6621 109.738 27.4202C110.043 27.1783 110.403 27.015 110.786 26.9448C111.169 26.8745 111.563 26.8996 111.933 27.0176C112.229 27.112 112.504 27.2638 112.741 27.4643C112.978 27.6648 113.172 27.9101 113.314 28.1862ZM12.4302 64.1124C12.5904 64.4232 12.6795 64.7658 12.6909 65.1154C12.7024 65.465 12.636 65.8128 12.4965 66.1339C12.357 66.4549 12.148 66.7411 11.8844 66.9718C11.6209 67.2025 11.3094 67.3719 10.9726 67.4678C10.6361 67.5638 10.2826 67.5842 9.93751 67.5275C9.59241 67.4708 9.26428 67.3385 8.97668 67.14C8.68908 66.9415 8.44914 66.6817 8.2741 66.3794C8.09906 66.0771 7.99327 65.7398 7.96432 65.3916C7.93243 65.0039 7.99683 64.6142 8.15179 64.2571C8.30676 63.9 8.5475 63.5864 8.85267 63.3443C9.15784 63.1022 9.518 62.9389 9.90121 62.8691C10.2844 62.7992 10.6788 62.8249 11.0494 62.9438C11.6475 63.1352 12.1438 63.5553 12.4302 64.1124ZM25.916 57.1789C26.0761 57.4897 26.165 57.8323 26.1764 58.1818C26.1877 58.5314 26.1213 58.8792 25.9819 59.2002C25.8424 59.5212 25.6334 59.8073 25.37 60.0381C25.1065 60.2688 24.7952 60.4383 24.4584 60.5343C24.1219 60.6304 23.7683 60.6509 23.4232 60.5943C23.078 60.5377 22.7498 60.4054 22.4621 60.207C22.1744 60.0085 21.9344 59.7488 21.7593 59.4464C21.5842 59.1441 21.4783 58.8067 21.4494 58.4585C21.4112 57.9923 21.5123 57.525 21.7401 57.116C21.9678 56.7069 22.3119 56.3744 22.7287 56.1605C23.2873 55.8736 23.9366 55.8197 24.5342 56.0106C25.1319 56.2016 25.6288 56.6218 25.916 57.1789ZM39.4011 50.2458C39.6149 50.6614 39.7004 51.1311 39.6468 51.5957C39.5931 52.0602 39.4027 52.4986 39.0996 52.8553C38.873 53.122 38.5901 53.3353 38.2713 53.4799C37.9525 53.6245 37.6056 53.6969 37.2557 53.6917C36.9058 53.6866 36.5615 53.6041 36.2475 53.4502C35.9335 53.2963 35.6577 53.0747 35.4398 52.8015C35.222 52.528 35.0678 52.2094 34.9883 51.8689C34.9089 51.5284 34.9062 51.1744 34.9803 50.8325C35.0545 50.4905 35.2037 50.1692 35.4172 49.8917C35.6307 49.6142 35.9032 49.3874 36.2149 49.2278C36.7733 48.941 37.4224 48.8871 38.0198 49.078C38.6172 49.2688 39.114 49.6889 39.4011 50.2458ZM52.89 43.3107C53.1038 43.7264 53.1892 44.1963 53.1354 44.6609C53.0816 45.1255 52.891 45.5639 52.5877 45.9206C52.361 46.1871 52.0782 46.4003 51.7594 46.5448C51.4407 46.6893 51.0939 46.7615 50.7441 46.7564C50.3943 46.7512 50.0501 46.6687 49.7362 46.5148C49.4223 46.361 49.1465 46.1395 48.9286 45.8664C48.7111 45.5929 48.557 45.2744 48.4776 44.934C48.3983 44.5936 48.3955 44.2397 48.4696 43.8979C48.5437 43.5561 48.6927 43.2348 48.906 42.9573C49.1193 42.6798 49.3915 42.4529 49.703 42.2931C50.2614 42.006 50.9107 41.9519 51.5083 42.1427C52.1058 42.3336 52.6028 42.7536 52.89 43.3107ZM66.375 36.3776C66.5889 36.7932 66.6744 37.2629 66.6207 37.7275C66.567 38.192 66.3766 38.6304 66.0735 38.9871C65.8469 39.2538 65.564 39.4671 65.2452 39.6117C64.9264 39.7563 64.5796 39.8287 64.2296 39.8235C63.8797 39.8184 63.5354 39.7359 63.2215 39.582C62.9075 39.4281 62.6316 39.2065 62.4137 38.9333C62.1226 38.5675 61.947 38.1233 61.909 37.6573C61.871 37.1912 61.9725 36.7242 62.2005 36.3154C62.4092 35.9413 62.7155 35.6306 63.0867 35.4164C63.4579 35.2021 63.8802 35.0924 64.3086 35.0989C64.737 35.1053 65.1555 35.2277 65.5194 35.453C65.8834 35.6784 66.1788 35.9974 66.375 36.3776ZM79.8608 29.4441C80.0747 29.8598 80.1601 30.3297 80.1063 30.7943C80.0525 31.2589 79.8619 31.6973 79.5586 32.054C79.3319 32.3205 79.049 32.5337 78.7303 32.6782C78.4115 32.8227 78.0648 32.8949 77.715 32.8897C77.3652 32.8846 77.021 32.8021 76.7071 32.6482C76.3932 32.4943 76.1174 32.2729 75.8995 31.9998C75.6817 31.7263 75.5275 31.4077 75.4481 31.0672C75.3686 30.7267 75.3659 30.3727 75.44 30.0308C75.5142 29.6888 75.6634 29.3675 75.8769 29.09C76.0904 28.8125 76.3629 28.5857 76.6746 28.4261C77.233 28.1395 77.8821 28.0857 78.4794 28.2766C79.0767 28.4674 79.5736 28.8873 79.8608 29.4441ZM93.3466 22.5106C93.5606 22.9262 93.6461 23.3962 93.5923 23.8608C93.5385 24.3254 93.3478 24.7638 93.0444 25.1205C92.8177 25.387 92.5348 25.6001 92.2161 25.7446C91.8973 25.8892 91.5506 25.9614 91.2008 25.9562C90.851 25.9511 90.5068 25.8686 90.1929 25.7147C89.879 25.5608 89.6032 25.3394 89.3853 25.0663C89.1673 24.7929 89.0128 24.4745 88.9332 24.134C88.8536 23.7935 88.8507 23.4394 88.9248 23.0975C88.9989 22.7555 89.1481 22.4342 89.3617 22.1567C89.5753 21.8792 89.8478 21.6525 90.1597 21.493C90.7182 21.2063 91.3673 21.1525 91.9647 21.3433C92.5621 21.5341 93.0591 21.9538 93.3466 22.5106ZM106.832 15.5775C107.046 15.9931 107.131 16.463 107.077 16.9277C107.024 17.3924 106.833 17.8308 106.529 18.1873C106.303 18.454 106.02 18.6673 105.701 18.8119C105.382 18.9565 105.036 19.0288 104.686 19.0236C104.336 19.0184 103.992 18.9359 103.678 18.7819C103.364 18.628 103.088 18.4064 102.87 18.1332C102.579 17.7673 102.404 17.3232 102.366 16.8571C102.328 16.3911 102.429 15.924 102.657 15.5153C102.866 15.1412 103.172 14.8305 103.543 14.6162C103.915 14.402 104.337 14.2923 104.765 14.2987C105.194 14.3052 105.612 14.4276 105.976 14.6529C106.34 14.8782 106.635 15.1972 106.832 15.5775ZM5.90138 51.4137C6.06142 51.7245 6.15033 52.067 6.16169 52.4165C6.17305 52.766 6.10659 53.1138 5.96709 53.4348C5.82759 53.7557 5.61854 54.0418 5.35503 54.2724C5.09152 54.503 4.78013 54.6724 4.44333 54.7683C4.10691 54.8644 3.75348 54.8848 3.40843 54.8282C3.06338 54.7716 2.73527 54.6393 2.44769 54.4409C2.16011 54.2425 1.92019 53.9828 1.74517 53.6806C1.57015 53.3783 1.46438 53.041 1.43547 52.6928C1.40358 52.3051 1.46797 51.9155 1.62294 51.5583C1.77791 51.2012 2.01865 50.8877 2.32382 50.6455C2.62899 50.4034 2.98915 50.2402 3.37236 50.1703C3.75556 50.1005 4.14997 50.1262 4.52059 50.2451C4.81649 50.3395 5.09076 50.4913 5.3277 50.6918C5.56463 50.8923 5.75958 51.1376 5.90138 51.4137ZM19.3872 44.4802C19.5471 44.791 19.6359 45.1335 19.6471 45.4829C19.6584 45.8324 19.5919 46.1801 19.4524 46.501C19.313 46.822 19.104 47.108 18.8406 47.3387C18.5771 47.5693 18.2658 47.7388 17.9291 47.8348C17.5927 47.931 17.2392 47.9516 16.8941 47.895C16.549 47.8385 16.2208 47.7063 15.9331 47.5079C15.6455 47.3095 15.4055 47.0498 15.2304 46.7475C15.0553 46.4453 14.9495 46.1079 14.9205 45.7597C14.8951 45.4502 14.931 45.1386 15.0262 44.8427C15.1214 44.5469 15.274 44.2726 15.4753 44.0356C15.6766 43.7986 15.9226 43.6035 16.1994 43.4614C16.4761 43.3194 16.7781 43.2332 17.088 43.2078C17.5545 43.1689 18.0219 43.269 18.4312 43.4955C18.8404 43.722 19.1731 44.0646 19.3872 44.4802ZM32.8722 37.547C33.0323 37.8578 33.1212 38.2004 33.1326 38.5499C33.1439 38.8994 33.0774 39.2472 32.9379 39.5681C32.7984 39.8891 32.5894 40.1752 32.3259 40.4058C32.0624 40.6364 31.751 40.8058 31.4142 40.9017C31.0778 40.9977 30.7243 41.0182 30.3793 40.9616C30.0342 40.905 29.7061 40.7727 29.4186 40.5743C29.131 40.3758 28.891 40.1162 28.716 39.8139C28.541 39.5117 28.4352 39.1744 28.4063 38.8262C28.3744 38.4385 28.4388 38.0488 28.5938 37.6917C28.7488 37.3346 28.9895 37.021 29.2947 36.7789C29.5999 36.5368 29.96 36.3736 30.3432 36.3037C30.7264 36.2339 31.1208 36.2595 31.4914 36.3785C31.7873 36.4729 32.0616 36.6247 32.2986 36.8252C32.5355 37.0257 32.7304 37.271 32.8722 37.547ZM46.3611 30.612C46.5212 30.9228 46.6101 31.2653 46.6214 31.6148C46.6328 31.9643 46.5663 32.3121 46.4268 32.633C46.2873 32.954 46.0783 33.2401 45.8148 33.4707C45.5513 33.7013 45.2399 33.8707 44.9031 33.9666C44.5666 34.0627 44.2132 34.0831 43.8682 34.0265C43.5231 33.9699 43.195 33.8376 42.9074 33.6392C42.6198 33.4408 42.3799 33.1811 42.2049 32.8788C42.0299 32.5766 41.9241 32.2393 41.8952 31.8911C41.8508 31.346 41.9969 30.8021 42.3088 30.352C42.6206 29.9019 43.0788 29.5735 43.6053 29.4227C44.1319 29.2719 44.6942 29.3081 45.1965 29.525C45.6989 29.7419 46.1109 30.1258 46.3611 30.612ZM59.8462 23.6788C60.0062 23.9896 60.0951 24.3322 60.1065 24.6817C60.1178 25.0312 60.0514 25.379 59.9119 25.6999C59.7724 26.0209 59.5633 26.307 59.2998 26.5376C59.0363 26.7682 58.7249 26.9376 58.3881 27.0335C58.0517 27.1295 57.6983 27.15 57.3532 27.0934C57.0082 27.0368 56.6801 26.9045 56.3925 26.7061C56.1049 26.5077 55.865 26.248 55.69 25.9457C55.5149 25.6435 55.4092 25.3062 55.3802 24.958C55.3422 24.4918 55.4434 24.0247 55.6711 23.6156C55.8989 23.2065 56.2429 22.874 56.6596 22.6601C57.2181 22.3734 57.8673 22.3197 58.4648 22.5107C59.0622 22.7017 59.559 23.1218 59.8462 23.6788ZM73.332 16.7453C73.492 17.0561 73.5809 17.3987 73.5923 17.7482C73.6036 18.0977 73.5372 18.4455 73.3977 18.7664C73.2582 19.0874 73.0491 19.3735 72.7856 19.6041C72.5221 19.8347 72.2107 20.0041 71.8739 20.1C71.5375 20.196 71.1841 20.2165 70.839 20.1599C70.494 20.1033 70.1659 19.971 69.8783 19.7726C69.5907 19.5741 69.3508 19.3145 69.1758 19.0122C69.0007 18.71 68.895 18.3726 68.8661 18.0245C68.8279 17.5583 68.929 17.0911 69.1568 16.682C69.3845 16.2729 69.7286 15.9404 70.1454 15.7266C70.7039 15.4397 71.3532 15.3858 71.9507 15.5769C72.5482 15.7679 73.045 16.1882 73.332 16.7453ZM86.8178 9.81182C87.0317 10.2275 87.1172 10.6974 87.0634 11.162C87.0096 11.6267 86.8189 12.0651 86.5155 12.4217C86.2888 12.6883 86.0059 12.9014 85.687 13.0459C85.3682 13.1904 85.0214 13.2626 84.6716 13.2573C84.3217 13.2521 83.9775 13.1695 83.6636 13.0155C83.3497 12.8616 83.0739 12.64 82.8561 12.3668C82.638 12.0934 82.4836 11.775 82.404 11.4345C82.3243 11.094 82.3214 10.7399 82.3955 10.398C82.4697 10.056 82.6189 9.73464 82.8325 9.45715C83.046 9.17965 83.3186 8.95296 83.6304 8.79345C84.189 8.50677 84.8383 8.45298 85.4359 8.6439C86.0334 8.83482 86.5304 9.25485 86.8178 9.81182ZM100.303 2.87871C100.517 3.29433 100.602 3.76429 100.549 4.22895C100.495 4.69361 100.304 5.13203 100.001 5.48858C99.6974 5.84501 99.2955 6.10389 98.8455 6.23256C98.3956 6.36123 97.9177 6.35393 97.4723 6.21157C97.0269 6.06921 96.6339 5.79818 96.3428 5.43268C96.0517 5.06717 95.8757 4.62358 95.8369 4.15787C95.8059 3.77042 95.8709 3.38117 96.0261 3.02449C96.1813 2.66781 96.4221 2.35467 96.727 2.11274C97.0319 1.8708 97.3917 1.70752 97.7745 1.6373C98.1573 1.56708 98.5515 1.5921 98.922 1.71013C99.2179 1.80453 99.4922 1.95634 99.7292 2.15686C99.9661 2.35738 100.161 2.60268 100.303 2.87871Z",
                fill: "currentColor"
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
            className: "cs_shape_2 cs_accent_color",
            width: 148,
            height: 145,
            viewBox: "0 0 148 145",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("mask", {
              id: "mask0_12",
              style: {
                maskType: "luminance"
              },
              maskUnits: "userSpaceOnUse",
              x: 0,
              y: 0,
              width: 148,
              height: 145,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
                d: "M0.609375 51.478L99.2245 0.776666L147.089 93.8749L48.4743 144.576L0.609375 51.478Z",
                fill: "white"
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("g", {
              mask: "url(#mask0_12)",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
                d: "M51.6057 140.309C51.82 140.725 51.9057 141.196 51.8522 141.661C51.7986 142.126 51.6081 142.564 51.3048 142.921C51.0015 143.279 50.5991 143.538 50.1484 143.667C49.6978 143.795 49.2193 143.787 48.7736 143.644C48.1761 143.453 47.6795 143.033 47.3928 142.476C47.1043 141.916 47.049 141.265 47.2391 140.664C47.4291 140.063 47.849 139.561 48.4074 139.268C48.9711 138.986 49.6228 138.938 50.2214 139.133C50.82 139.328 51.3173 139.75 51.6057 140.309ZM65.0908 133.376C65.2996 133.793 65.38 134.263 65.322 134.726C65.2639 135.189 65.07 135.624 64.7646 135.977C64.459 136.331 64.0559 136.586 63.6059 136.712C63.1559 136.837 62.679 136.828 62.2349 136.684C61.7907 136.54 61.3994 136.267 61.1103 135.901C60.8213 135.534 60.6474 135.091 60.6108 134.625C60.5742 134.16 60.6763 133.694 60.9044 133.287C61.1325 132.879 61.4763 132.548 61.8924 132.335C62.1711 132.192 62.4752 132.105 62.7874 132.08C63.0996 132.054 63.4136 132.091 63.7113 132.188C64.0087 132.285 64.2837 132.44 64.5205 132.644C64.7573 132.848 64.9512 133.097 65.0908 133.376ZM78.5766 126.443C78.7854 126.86 78.8658 127.329 78.8078 127.792C78.7497 128.255 78.5558 128.691 78.2504 129.044C77.9448 129.397 77.5417 129.653 77.0917 129.778C76.6417 129.904 76.1648 129.894 75.7207 129.75C75.1999 129.582 74.7541 129.238 74.4592 128.777C74.1644 128.316 74.0388 127.768 74.1039 127.224C74.169 126.681 74.4208 126.177 74.8163 125.798C75.2118 125.419 75.7264 125.188 76.2725 125.146C76.5846 125.121 76.8983 125.159 77.1958 125.256C77.4932 125.353 77.7685 125.507 78.0059 125.711C78.2428 125.914 78.4364 126.163 78.5766 126.443ZM92.0654 119.508C92.2217 119.82 92.3068 120.162 92.3147 120.511C92.3226 120.86 92.253 121.207 92.111 121.526C91.969 121.845 91.758 122.128 91.4933 122.356C91.2285 122.584 90.9166 122.751 90.5799 122.845C90.13 122.969 89.6534 122.959 89.2098 122.814C88.7663 122.67 88.3754 122.398 88.0861 122.032C87.8701 121.758 87.7176 121.44 87.6395 121.1C87.5613 120.761 87.5594 120.408 87.634 120.067C87.7086 119.726 87.8578 119.406 88.0709 119.129C88.2839 118.852 88.5556 118.626 88.8663 118.467C89.145 118.323 89.4492 118.237 89.7613 118.211C90.0735 118.186 90.3875 118.223 90.6852 118.32C90.9827 118.416 91.2578 118.571 91.4948 118.775C91.7317 118.979 91.9257 119.228 92.0654 119.508ZM105.55 112.575C105.759 112.992 105.84 113.461 105.782 113.924C105.723 114.387 105.53 114.822 105.224 115.176C104.919 115.529 104.516 115.784 104.066 115.91C103.616 116.036 103.139 116.026 102.695 115.882C102.25 115.738 101.859 115.465 101.57 115.099C101.281 114.733 101.107 114.289 101.071 113.824C101.034 113.358 101.136 112.893 101.364 112.485C101.592 112.077 101.936 111.746 102.352 111.533C102.631 111.39 102.935 111.303 103.247 111.278C103.559 111.253 103.873 111.29 104.17 111.387C104.468 111.483 104.743 111.638 104.98 111.842C105.217 112.046 105.411 112.295 105.55 112.575ZM119.036 105.641C119.245 106.058 119.325 106.528 119.267 106.991C119.209 107.454 119.015 107.889 118.709 108.243C118.404 108.596 118.001 108.851 117.551 108.976C117.101 109.102 116.624 109.092 116.18 108.948C115.736 108.804 115.345 108.532 115.056 108.166C114.767 107.8 114.593 107.356 114.556 106.891C114.52 106.425 114.622 105.96 114.85 105.552C115.078 105.144 115.421 104.813 115.837 104.6C116.116 104.457 116.42 104.37 116.732 104.345C117.044 104.32 117.358 104.356 117.656 104.453C117.954 104.55 118.229 104.705 118.466 104.909C118.703 105.113 118.897 105.362 119.036 105.641ZM132.522 98.7077C132.704 99.072 132.789 99.4773 132.768 99.8843C132.748 100.291 132.622 100.686 132.404 101.031C132.185 101.375 131.881 101.658 131.522 101.85C131.162 102.043 130.759 102.14 130.351 102.132C129.943 102.123 129.545 102.009 129.194 101.801C128.843 101.594 128.553 101.299 128.35 100.945C128.147 100.592 128.039 100.192 128.037 99.7846C128.035 99.3771 128.138 98.9758 128.336 98.6195C128.604 98.1403 129.031 97.7686 129.542 97.5681C130.054 97.3675 130.619 97.3505 131.141 97.5199C131.439 97.6169 131.714 97.7718 131.951 97.9757C132.188 98.1795 132.382 98.4283 132.522 98.7077ZM146.007 91.7745C146.164 92.0863 146.249 92.429 146.257 92.7778C146.265 93.1266 146.195 93.473 146.053 93.792C145.911 94.111 145.7 94.3948 145.436 94.6228C145.171 94.8509 144.859 95.0176 144.522 95.1111C144.072 95.2364 143.596 95.2262 143.152 95.0817C142.708 94.9373 142.317 94.6649 142.028 94.299C141.739 93.933 141.565 93.4894 141.528 93.0243C141.491 92.5591 141.594 92.0934 141.822 91.686C141.993 91.3794 142.231 91.1147 142.517 90.911C142.804 90.7073 143.132 90.5696 143.478 90.508C143.824 90.4464 144.179 90.4624 144.518 90.5548C144.856 90.6472 145.17 90.8138 145.436 91.0424C145.673 91.2457 145.867 91.4944 146.007 91.7745ZM45.0765 127.61C45.2184 127.886 45.3044 128.187 45.3296 128.497C45.3549 128.806 45.3188 129.118 45.2236 129.414C45.1283 129.709 44.9757 129.984 44.7745 130.221C44.5732 130.458 44.3273 130.653 44.0507 130.795C43.7741 130.937 43.4722 131.023 43.1624 131.049C42.8526 131.075 42.5408 131.039 42.2449 130.945C41.9489 130.85 41.6747 130.698 41.4377 130.497C41.2008 130.296 41.0058 130.051 40.8639 129.775C40.5773 129.217 40.5244 128.568 40.7168 127.971C40.9092 127.374 41.3311 126.877 41.8897 126.59C42.4483 126.303 43.0979 126.249 43.6955 126.44C44.2932 126.632 44.7899 127.052 45.0765 127.61ZM58.5623 120.676C58.7041 120.953 58.7901 121.254 58.8153 121.564C58.8405 121.873 58.8044 122.185 58.7091 122.481C58.6138 122.776 58.4611 123.051 58.2598 123.288C58.0584 123.525 57.8124 123.72 57.5357 123.862C57.2591 124.004 56.9572 124.09 56.6472 124.116C56.3373 124.142 56.0255 124.106 55.7295 124.011C55.4336 123.916 55.1593 123.764 54.9224 123.563C54.6854 123.363 54.4904 123.117 54.3486 122.841C54.2067 122.565 54.1207 122.263 54.0956 121.954C54.0704 121.644 54.1065 121.333 54.2018 121.037C54.2971 120.741 54.4497 120.467 54.651 120.23C54.8523 119.993 55.0983 119.798 55.3749 119.656C55.6515 119.514 55.9534 119.428 56.2633 119.402C56.5731 119.377 56.8849 119.412 57.1808 119.507C57.4767 119.602 57.7509 119.754 57.9878 119.955C58.2247 120.155 58.4197 120.401 58.5615 120.677L58.5623 120.676ZM72.0473 113.743C72.1963 114.02 72.2884 114.324 72.3185 114.637C72.3485 114.949 72.3158 115.265 72.2222 115.565C72.1287 115.866 71.9761 116.144 71.7736 116.385C71.571 116.626 71.3225 116.824 71.0425 116.968C70.7625 117.112 70.4567 117.199 70.143 117.223C69.8292 117.248 69.5138 117.209 69.2152 117.111C68.9166 117.012 68.6408 116.855 68.4039 116.648C68.167 116.442 67.9738 116.19 67.8355 115.908C67.549 115.35 67.496 114.701 67.6884 114.104C67.8808 113.507 68.3027 113.01 68.8613 112.723C69.4199 112.436 70.0695 112.382 70.6671 112.573C71.2648 112.765 71.7608 113.186 72.0473 113.743ZM85.5362 106.808C85.6781 107.084 85.7641 107.386 85.7894 107.695C85.8146 108.005 85.7786 108.316 85.6833 108.612C85.5881 108.908 85.4355 109.182 85.2342 109.419C85.033 109.656 84.787 109.851 84.5104 109.993C84.2338 110.135 83.932 110.222 83.6221 110.247C83.3123 110.273 83.0005 110.238 82.7046 110.143C82.4087 110.048 82.1344 109.896 81.8975 109.695C81.6605 109.495 81.4655 109.249 81.3236 108.973C81.0371 108.415 80.9842 107.767 81.1765 107.169C81.3689 106.572 81.7908 106.075 82.3494 105.788C82.908 105.501 83.5576 105.447 84.1553 105.639C84.7529 105.83 85.2496 106.251 85.5362 106.808ZM99.0213 99.8752C99.1702 100.152 99.2624 100.455 99.2924 100.768C99.3224 101.081 99.2897 101.397 99.1961 101.697C99.1026 101.998 98.9501 102.276 98.7475 102.517C98.5449 102.758 98.2964 102.956 98.0164 103.1C97.7365 103.244 97.4307 103.331 97.1169 103.355C96.8032 103.38 96.4878 103.341 96.1892 103.243C95.8906 103.144 95.6148 102.987 95.3779 102.78C95.1409 102.574 94.9477 102.322 94.8095 102.04C94.6676 101.764 94.5815 101.462 94.5563 101.153C94.531 100.843 94.5671 100.532 94.6623 100.236C94.7576 99.9401 94.9102 99.6659 95.1114 99.4289C95.3127 99.1919 95.5586 98.9968 95.8352 98.8547C96.1118 98.7125 96.4137 98.6261 96.7235 98.6005C97.0334 98.5748 97.3451 98.6104 97.6411 98.7051C97.937 98.7998 98.2112 98.9519 98.4482 99.1526C98.6851 99.3532 98.8794 99.5991 99.0213 99.8752ZM112.507 92.9416C112.656 93.2183 112.748 93.522 112.778 93.8348C112.808 94.1477 112.776 94.4635 112.682 94.7638C112.588 95.064 112.436 95.3427 112.233 95.5836C112.031 95.8244 111.782 96.0226 111.502 96.1665C111.222 96.3103 110.916 96.3971 110.603 96.4216C110.289 96.446 109.974 96.4078 109.675 96.3091C109.376 96.2103 109.101 96.0531 108.864 95.8465C108.627 95.64 108.434 95.3883 108.295 95.1061C108.009 94.5485 107.956 93.8997 108.148 93.3024C108.341 92.7051 108.762 92.2082 109.321 91.9211C109.88 91.6341 110.529 91.5803 111.127 91.7716C111.725 91.9629 112.22 92.384 112.507 92.9416ZM125.993 86.0081C126.153 86.319 126.242 86.6615 126.253 87.011C126.264 87.3605 126.198 87.7083 126.058 88.0292C125.919 88.3502 125.71 88.6363 125.447 88.8671C125.183 89.0978 124.872 89.2674 124.535 89.3635C124.085 89.492 123.607 89.4845 123.161 89.3421C122.716 89.1996 122.323 88.9286 122.031 88.5631C121.813 88.2897 121.659 87.9713 121.579 87.6309C121.5 87.2904 121.497 86.9365 121.571 86.5946C121.645 86.2527 121.795 85.9315 122.008 85.6541C122.222 85.3767 122.494 85.15 122.806 84.9905C123.364 84.7034 124.014 84.6494 124.611 84.8402C125.209 85.031 125.706 85.4511 125.993 86.0081ZM139.478 79.075C139.638 79.3859 139.727 79.7284 139.738 80.0779C139.75 80.4275 139.683 80.7753 139.544 81.0963C139.404 81.4173 139.195 81.7035 138.932 81.9342C138.668 82.1649 138.357 82.3344 138.02 82.4304C137.57 82.5587 137.092 82.5512 136.646 82.4088C136.201 82.2663 135.808 81.9954 135.516 81.63C135.225 81.2641 135.049 80.82 135.012 80.3539C134.974 79.8879 135.075 79.4209 135.303 79.0121C135.511 78.637 135.817 78.3253 136.188 78.1103C136.56 77.8954 136.982 77.7852 137.411 77.7917C137.84 77.7982 138.259 77.921 138.623 78.147C138.987 78.3731 139.283 78.6939 139.478 79.075ZM38.5472 114.91C38.7073 115.221 38.7962 115.564 38.8075 115.913C38.8189 116.263 38.7524 116.611 38.6129 116.932C38.4734 117.253 38.2644 117.539 38.0009 117.769C37.7374 118 37.426 118.169 37.0892 118.265C36.7528 118.361 36.3995 118.382 36.0546 118.325C35.7096 118.268 35.3816 118.136 35.0941 117.938C34.8065 117.739 34.5666 117.48 34.3916 117.178C34.2166 116.876 34.1107 116.538 34.0817 116.19C34.0563 115.881 34.0922 115.569 34.1873 115.273C34.2825 114.978 34.4352 114.703 34.6365 114.466C34.8378 114.229 35.0838 114.034 35.3606 113.892C35.6373 113.75 35.9392 113.664 36.2492 113.638C36.7156 113.6 37.1829 113.7 37.592 113.927C38.0011 114.153 38.3332 114.495 38.5472 114.91ZM52.033 107.977C52.1929 108.288 52.2817 108.63 52.293 108.98C52.3043 109.329 52.2378 109.677 52.0983 109.998C51.9588 110.319 51.7498 110.605 51.4864 110.835C51.223 111.066 50.9117 111.236 50.575 111.332C50.2385 111.428 49.8851 111.448 49.5399 111.392C49.1948 111.335 48.8666 111.203 48.579 111.005C48.2913 110.806 48.0513 110.547 47.8762 110.244C47.7011 109.942 47.5953 109.605 47.5664 109.257C47.5409 108.947 47.5768 108.635 47.672 108.34C47.7672 108.044 47.9198 107.769 48.1211 107.532C48.3224 107.295 48.5685 107.1 48.8452 106.958C49.1219 106.816 49.4239 106.73 49.7338 106.705C50.2004 106.666 50.6678 106.766 51.077 106.992C51.4862 107.219 51.8189 107.561 52.033 107.977ZM65.5181 101.044C65.6781 101.355 65.767 101.697 65.7784 102.047C65.7898 102.396 65.7233 102.744 65.5838 103.065C65.4443 103.386 65.2352 103.672 64.9717 103.903C64.7082 104.133 64.3968 104.303 64.06 104.398C63.7236 104.495 63.3702 104.515 63.0251 104.458C62.6801 104.402 62.352 104.27 62.0644 104.071C61.7768 103.873 61.5369 103.613 61.3619 103.311C61.1869 103.008 61.0811 102.671 61.0522 102.323C61.0267 102.013 61.0626 101.702 61.1578 101.406C61.253 101.11 61.4056 100.836 61.6069 100.599C61.8082 100.362 62.0543 100.167 62.331 100.025C62.6077 99.8827 62.9097 99.7965 63.2196 99.7711C63.6861 99.7324 64.1534 99.8327 64.5625 100.059C64.9715 100.286 65.3041 100.628 65.5181 101.044ZM79.007 94.1088C79.167 94.4196 79.2559 94.7621 79.2673 95.1116C79.2786 95.4611 79.2122 95.8089 79.0727 96.1299C78.9332 96.4508 78.7241 96.7369 78.4606 96.9675C78.1971 97.1981 77.8857 97.3675 77.5489 97.4634C77.2125 97.5596 76.859 97.5802 76.5139 97.5237C76.1688 97.4671 75.8406 97.3349 75.553 97.1364C75.2654 96.9379 75.0254 96.6782 74.8504 96.3759C74.6755 96.0735 74.5698 95.7361 74.541 95.3879C74.509 95.0002 74.5733 94.6105 74.7282 94.2533C74.8831 93.8961 75.1238 93.5825 75.4289 93.3403C75.7341 93.0981 76.0942 92.9348 76.4775 92.8649C76.8607 92.7949 77.2551 92.8205 77.6258 92.9394C77.9217 93.034 78.196 93.186 78.433 93.3866C78.67 93.5873 78.865 93.8327 79.007 94.1088ZM92.492 87.1756C92.652 87.4864 92.7409 87.829 92.7523 88.1785C92.7637 88.528 92.6972 88.8758 92.5577 89.1967C92.4182 89.5177 92.2092 89.8038 91.9456 90.0344C91.6821 90.265 91.3707 90.4344 91.0339 90.5303C90.6975 90.6265 90.344 90.6471 89.9989 90.5906C89.6538 90.534 89.3257 90.4018 89.038 90.2033C88.7504 90.0048 88.5105 89.7451 88.3355 89.4428C88.1605 89.1404 88.0549 88.803 88.0261 88.4548C88.0006 88.1453 88.0365 87.8337 88.1317 87.5378C88.2269 87.242 88.3795 86.9677 88.5809 86.7307C88.7822 86.4937 89.0282 86.2986 89.3049 86.1565C89.5817 86.0145 89.8836 85.9283 90.1936 85.9029C90.66 85.8642 91.1273 85.9645 91.5364 86.191C91.9455 86.4175 92.278 86.7602 92.492 87.1756ZM105.978 80.2421C106.138 80.5529 106.227 80.8955 106.238 81.245C106.249 81.5945 106.183 81.9423 106.044 82.2632C105.904 82.5842 105.695 82.8703 105.431 83.1009C105.168 83.3315 104.857 83.5009 104.52 83.5968C104.183 83.6928 103.83 83.7133 103.485 83.6567C103.14 83.6001 102.812 83.4678 102.524 83.2694C102.237 83.0709 101.997 82.8113 101.822 82.509C101.647 82.2068 101.541 81.8694 101.512 81.5213C101.486 81.2118 101.522 80.9002 101.618 80.6043C101.713 80.3085 101.865 80.0342 102.067 79.7972C102.268 79.5602 102.514 79.3651 102.791 79.223C103.067 79.081 103.369 78.9948 103.679 78.9694C104.146 78.9307 104.613 79.031 105.022 79.2575C105.431 79.484 105.764 79.8267 105.978 80.2421ZM119.464 73.3086C119.678 73.7243 119.763 74.1942 119.709 74.6588C119.655 75.1235 119.465 75.5619 119.161 75.9185C118.858 76.2748 118.456 76.5335 118.006 76.6621C117.556 76.7907 117.079 76.7834 116.633 76.6411C116.188 76.4989 115.795 76.228 115.503 75.8626C115.212 75.4973 115.036 75.0538 114.997 74.5882C114.954 74.0433 115.1 73.5 115.412 73.0504C115.724 72.6009 116.182 72.2729 116.708 72.1222C117.235 71.9714 117.797 72.0072 118.299 72.2235C118.801 72.4398 119.213 72.8232 119.464 73.3086ZM132.949 66.3755C133.163 66.7911 133.248 67.2611 133.194 67.7257C133.141 68.1904 132.95 68.6288 132.646 68.9854C132.266 69.4314 131.733 69.7205 131.151 69.7969C130.57 69.8732 129.981 69.7312 129.499 69.3984C129.017 69.0657 128.676 68.5658 128.542 67.9957C128.408 67.4256 128.49 66.8258 128.774 66.3126C128.982 65.9384 129.289 65.6277 129.66 65.4135C130.031 65.1993 130.453 65.0896 130.882 65.096C131.31 65.1025 131.729 65.2249 132.093 65.4502C132.457 65.6755 132.752 65.9953 132.949 66.3755ZM32.018 102.211C32.178 102.522 32.2669 102.864 32.2783 103.214C32.2896 103.563 32.2232 103.911 32.0837 104.232C31.9442 104.553 31.7351 104.839 31.4716 105.07C31.2081 105.3 30.8967 105.47 30.5599 105.566C30.2236 105.662 29.8703 105.682 29.5253 105.625C29.1804 105.569 28.8523 105.437 28.5648 105.238C28.2773 105.04 28.0374 104.78 27.8624 104.478C27.6873 104.176 27.5815 103.839 27.5524 103.491C27.5142 103.025 27.6154 102.557 27.8432 102.148C28.0709 101.739 28.415 101.407 28.8318 101.193C29.3903 100.906 30.0396 100.852 30.6371 101.043C31.2346 101.234 31.731 101.654 32.018 102.211ZM45.5038 95.2774C45.6637 95.5883 45.7524 95.9308 45.7637 96.2802C45.775 96.6297 45.7085 96.9774 45.569 97.2983C45.4296 97.6192 45.2206 97.9053 44.9572 98.136C44.6937 98.3666 44.3824 98.5361 44.0457 98.6321C43.7093 98.7283 43.3558 98.7489 43.0107 98.6923C42.6656 98.6358 42.3374 98.5036 42.0497 98.3052C41.762 98.1068 41.522 97.8471 41.347 97.5448C41.1719 97.2426 41.0661 96.9052 41.0371 96.557C40.9989 96.0908 41.1001 95.6236 41.3278 95.2145C41.5556 94.8054 41.8996 94.4729 42.3164 94.2591C42.875 93.9722 43.5244 93.9183 44.122 94.1092C44.7196 94.3001 45.2166 94.7203 45.5038 95.2774ZM58.9888 88.3443C59.1489 88.6551 59.2378 88.9977 59.2491 89.3472C59.2605 89.6967 59.194 90.0445 59.0545 90.3654C58.915 90.6864 58.706 90.9725 58.4425 91.2031C58.179 91.4337 57.8676 91.6031 57.5308 91.699C57.1944 91.795 56.8409 91.8155 56.4959 91.7589C56.1508 91.7023 55.8227 91.57 55.5351 91.3716C55.2476 91.1731 55.0076 90.9135 54.8326 90.6112C54.6576 90.309 54.5518 89.9716 54.5229 89.6235C54.4847 89.1573 54.5859 88.6901 54.8136 88.281C55.0414 87.8719 55.3855 87.5394 55.8023 87.3256C56.3607 87.0387 57.0101 86.9848 57.6076 87.1759C58.2051 87.3669 58.7019 87.7872 58.9888 88.3443ZM72.4777 81.4092C72.6377 81.72 72.7267 82.0626 72.738 82.4121C72.7494 82.7616 72.6829 83.1094 72.5434 83.4303C72.4039 83.7513 72.1949 84.0374 71.9314 84.268C71.6678 84.4986 71.3564 84.668 71.0197 84.7639C70.6832 84.8601 70.3298 84.8807 69.9846 84.8242C69.6395 84.7676 69.3114 84.6354 69.0237 84.4369C68.7361 84.2384 68.4962 83.9787 68.3212 83.6764C68.1462 83.374 68.0406 83.0366 68.0118 82.6884C67.9799 82.3007 68.0443 81.911 68.1993 81.5539C68.3542 81.1968 68.595 80.8833 68.9001 80.6411C69.2053 80.399 69.5655 80.2358 69.9487 80.1659C70.3319 80.0961 70.7263 80.1217 71.0969 80.2407C71.6946 80.4312 72.1913 80.8522 72.4777 81.4092ZM85.9628 74.4761C86.1228 74.7869 86.2117 75.1295 86.2231 75.479C86.2344 75.8285 86.168 76.1763 86.0285 76.4972C85.889 76.8182 85.6799 77.1043 85.4164 77.3349C85.1529 77.5655 84.8415 77.7349 84.5047 77.8308C84.1683 77.927 83.8148 77.9476 83.4697 77.891C83.1246 77.8345 82.7964 77.7023 82.5088 77.5038C82.2212 77.3053 81.9812 77.0456 81.8063 76.7432C81.6313 76.4409 81.5256 76.1035 81.4968 75.7553C81.4586 75.2891 81.5598 74.8219 81.7876 74.4128C82.0153 74.0037 82.3594 73.6712 82.7762 73.4574C83.3347 73.1707 83.9839 73.117 84.5814 73.308C85.1788 73.499 85.6756 73.9191 85.9628 74.4761ZM99.4486 67.5426C99.6086 67.8534 99.6975 68.196 99.7089 68.5455C99.7202 68.895 99.6538 69.2428 99.5143 69.5637C99.3748 69.8847 99.1657 70.1708 98.9022 70.4014C98.6387 70.632 98.3273 70.8014 97.9905 70.8973C97.6541 70.9933 97.3007 71.0138 96.9556 70.9572C96.6106 70.9006 96.2825 70.7683 95.9949 70.5699C95.7073 70.3714 95.4674 70.1118 95.2924 69.8095C95.1173 69.5073 95.0116 69.1699 94.9826 68.8218C94.9572 68.5122 94.9931 68.2007 95.0883 67.9048C95.1835 67.609 95.3361 67.3347 95.5374 67.0977C95.7387 66.8607 95.9848 66.6656 96.2615 66.5235C96.5382 66.3815 96.8402 66.2953 97.1501 66.2698C97.6166 66.2312 98.0839 66.3314 98.4929 66.558C98.902 66.7845 99.2346 67.1271 99.4486 67.5426ZM112.934 60.6091C113.148 61.0248 113.234 61.4947 113.18 61.9593C113.126 62.424 112.936 62.8624 112.632 63.219C112.329 63.5753 111.927 63.834 111.477 63.9626C111.027 64.0912 110.549 64.0839 110.104 63.9416C109.658 63.7993 109.265 63.5285 108.974 63.1631C108.683 62.7978 108.507 62.3543 108.468 61.8887C108.424 61.3438 108.571 60.8005 108.883 60.3509C109.195 59.9014 109.653 59.5734 110.179 59.4227C110.705 59.2719 111.267 59.3077 111.77 59.524C112.272 59.7403 112.683 60.1237 112.934 60.6091ZM126.419 53.676C126.633 54.0916 126.719 54.5616 126.665 55.0262C126.611 55.4909 126.421 55.9293 126.117 56.2859C125.736 56.7319 125.204 57.021 124.622 57.0973C124.041 57.1737 123.452 57.0317 122.97 56.6989C122.487 56.3662 122.146 55.8663 122.012 55.2962C121.878 54.7261 121.961 54.1263 122.245 53.613C122.453 53.2389 122.759 52.9282 123.131 52.714C123.502 52.4998 123.924 52.3901 124.353 52.3965C124.781 52.403 125.199 52.5254 125.563 52.7507C125.927 52.976 126.223 53.2958 126.419 53.676ZM25.4887 89.5114C25.6488 89.8222 25.7377 90.1648 25.749 90.5143C25.7604 90.8638 25.6939 91.2116 25.5544 91.5325C25.4149 91.8535 25.2059 92.1396 24.9424 92.3702C24.6789 92.6008 24.3675 92.7702 24.0307 92.8661C23.6943 92.9621 23.341 92.9825 22.9961 92.9259C22.6511 92.8693 22.3231 92.7371 22.0356 92.5387C21.7481 92.3404 21.5082 92.0808 21.3331 91.7787C21.1581 91.4766 21.0522 91.1394 21.0232 90.7914C20.9913 90.4037 21.0557 90.014 21.2107 89.6569C21.3656 89.2997 21.6064 88.9862 21.9116 88.7441C22.2167 88.502 22.5769 88.3387 22.9601 88.2689C23.3433 88.199 23.7377 88.2247 24.1083 88.3436C24.706 88.5342 25.2023 88.9544 25.4887 89.5114ZM38.9749 82.5787C39.1348 82.8895 39.2236 83.232 39.2349 83.5815C39.2462 83.931 39.1797 84.2787 39.0402 84.5996C38.9007 84.9205 38.6917 85.2066 38.4283 85.4372C38.1649 85.6679 37.8536 85.8373 37.5169 85.9333C37.1804 86.0295 36.827 86.0501 36.4818 85.9936C36.1367 85.9371 35.8085 85.8048 35.5209 85.6064C35.2332 85.408 34.9932 85.1484 34.8181 84.8461C34.643 84.5438 34.5372 84.2065 34.5083 83.8582C34.47 83.3921 34.5712 82.9248 34.799 82.5158C35.0267 82.1067 35.3708 81.7742 35.7876 81.5603C36.346 81.2735 36.9952 81.2195 37.5927 81.4103C38.1902 81.6011 38.6876 82.0218 38.9749 82.5787ZM52.46 75.6456C52.62 75.9564 52.7089 76.2989 52.7203 76.6484C52.7317 76.9979 52.6652 77.3457 52.5257 77.6667C52.3862 77.9876 52.1771 78.2737 51.9136 78.5043C51.6501 78.735 51.3387 78.9043 51.0019 79.0002C50.6655 79.0963 50.3121 79.1167 49.967 79.0601C49.622 79.0035 49.2939 78.8713 49.0063 78.6728C48.7187 78.4744 48.4788 78.2147 48.3038 77.9125C48.1288 77.6102 48.023 77.2729 47.9941 76.9247C47.9559 76.4586 48.057 75.9913 48.2848 75.5823C48.5125 75.1732 48.8566 74.8407 49.2734 74.6268C49.8317 74.34 50.4809 74.2861 51.0783 74.477C51.6757 74.6679 52.1729 75.0886 52.46 75.6456ZM65.9489 68.7105C66.1089 69.0213 66.1978 69.3638 66.2092 69.7133C66.2205 70.0628 66.1541 70.4106 66.0146 70.7316C65.8751 71.0525 65.666 71.3387 65.4025 71.5693C65.139 71.7999 64.8276 71.9692 64.4908 72.0651C64.1544 72.1614 63.8009 72.1819 63.4558 72.1254C63.1107 72.0689 62.7825 71.9366 62.4949 71.7382C62.2073 71.5397 61.9673 71.2799 61.7924 70.9776C61.6174 70.6753 61.5117 70.3379 61.4829 69.9897C61.4509 69.602 61.5152 69.2122 61.6701 68.855C61.825 68.4979 62.0657 68.1842 62.3708 67.942C62.676 67.6998 63.0361 67.5365 63.4194 67.4666C63.8026 67.3967 64.197 67.4223 64.5677 67.5412C65.1657 67.7325 65.6624 68.1534 65.9489 68.7105ZM79.4339 61.7774C79.5939 62.0882 79.6828 62.4307 79.6942 62.7802C79.7056 63.1297 79.6391 63.4775 79.4996 63.7985C79.3601 64.1194 79.1511 64.4055 78.8875 64.6361C78.624 64.8668 78.3126 65.0361 77.9758 65.132C77.6394 65.2282 77.286 65.2488 76.9408 65.1923C76.5957 65.1358 76.2676 65.0035 75.9799 64.805C75.6923 64.6066 75.4524 64.3468 75.2774 64.0445C75.1024 63.7422 74.9968 63.4048 74.968 63.0565C74.9298 62.5904 75.031 62.1231 75.2587 61.7141C75.4865 61.305 75.8305 60.9725 76.2473 60.7586C76.8057 60.472 77.4548 60.4183 78.0521 60.6091C78.6494 60.8 79.1466 61.2206 79.4339 61.7774ZM92.9197 54.8439C93.0798 55.1547 93.1687 55.4972 93.18 55.8467C93.1914 56.1962 93.1249 56.544 92.9854 56.865C92.8459 57.1859 92.6369 57.472 92.3734 57.7026C92.1098 57.9333 91.7985 58.1026 91.4617 58.1985C91.1253 58.2946 90.7718 58.315 90.4268 58.2584C90.0817 58.2018 89.7536 58.0696 89.466 57.8711C89.1784 57.6727 88.9385 57.413 88.7635 57.1108C88.5885 56.8085 88.4827 56.4712 88.4538 56.123C88.4284 55.8135 88.4643 55.5019 88.5595 55.2061C88.6546 54.9102 88.8073 54.6359 89.0086 54.3989C89.2099 54.1619 89.4559 53.9668 89.7327 53.8247C90.0094 53.6827 90.3113 53.5965 90.6213 53.5711C91.0876 53.5324 91.5547 53.6326 91.9637 53.859C92.3727 54.0854 92.7056 54.4286 92.9197 54.8439ZM106.405 47.9096C106.619 48.3253 106.705 48.7952 106.651 49.2598C106.597 49.7245 106.406 50.1629 106.103 50.5195C105.8 50.8757 105.398 51.1345 104.948 51.2631C104.498 51.3917 104.02 51.3844 103.575 51.2421C103.129 51.0998 102.736 50.8289 102.445 50.4636C102.154 50.0982 101.978 49.6548 101.938 49.1892C101.907 48.8016 101.972 48.4122 102.127 48.0554C102.283 47.6986 102.523 47.3853 102.829 47.1433C103.134 46.9013 103.493 46.738 103.876 46.6679C104.259 46.5977 104.654 46.6228 105.024 46.741C105.621 46.932 106.119 47.3525 106.405 47.9096ZM119.891 40.9772C120.105 41.3929 120.19 41.8628 120.136 42.3275C120.083 42.7921 119.892 43.2306 119.588 43.5871C119.285 43.9435 118.883 44.2024 118.433 44.3311C117.983 44.4598 117.505 44.4525 117.06 44.3101C116.615 44.1678 116.222 43.8967 115.931 43.5312C115.639 43.1657 115.463 42.7221 115.425 42.2564C115.393 41.8689 115.458 41.4795 115.613 41.1226C115.768 40.7658 116.009 40.4525 116.314 40.2104C116.619 39.9683 116.979 39.805 117.362 39.7348C117.745 39.6646 118.139 39.6897 118.509 39.8079C119.107 39.9992 119.604 40.4202 119.891 40.9772ZM18.9128 76.7211C19.0728 77.0319 19.1617 77.3744 19.1731 77.724C19.1845 78.0735 19.118 78.4213 18.9785 78.7422C18.839 79.0632 18.63 79.3493 18.3664 79.5799C18.1029 79.8105 17.7915 79.9799 17.4547 80.0757C17.1183 80.1718 16.7649 80.1923 16.4198 80.1357C16.0748 80.0791 15.7467 79.9468 15.4591 79.7484C15.1715 79.5499 14.9316 79.2903 14.7566 78.988C14.5816 78.6858 14.4758 78.3484 14.4469 78.0003C14.415 77.6126 14.4794 77.2229 14.6344 76.8658C14.7893 76.5087 15.0301 76.1951 15.3352 75.953C15.6404 75.7109 16.0006 75.5476 16.3838 75.4778C16.767 75.4079 17.1614 75.4336 17.532 75.5525C17.8279 75.6469 18.1022 75.7987 18.3391 75.9993C18.576 76.1998 18.771 76.4451 18.9128 76.7211ZM32.3986 69.7876C32.5585 70.0984 32.6473 70.4409 32.6585 70.7904C32.6698 71.1399 32.6033 71.4876 32.4639 71.8085C32.3244 72.1294 32.1154 72.4155 31.852 72.6461C31.5886 72.8768 31.2773 73.0462 30.9406 73.1422C30.6041 73.2384 30.2506 73.259 29.9055 73.2025C29.5604 73.146 29.2322 73.0138 28.9445 72.8154C28.6569 72.6169 28.4169 72.3573 28.2418 72.055C28.0667 71.7527 27.9609 71.4154 27.9319 71.0672C27.8938 70.601 27.9951 70.1338 28.2228 69.7248C28.4505 69.3157 28.7945 68.9832 29.2113 68.7692C29.7698 68.4823 30.4192 68.4284 31.0168 68.6194C31.6144 68.8103 32.1114 69.2305 32.3986 69.7876ZM45.8837 62.8545C46.0437 63.1653 46.1326 63.5078 46.144 63.8573C46.1553 64.2068 46.0889 64.5546 45.9494 64.8756C45.8099 65.1965 45.6008 65.4826 45.3373 65.7133C45.0738 65.9439 44.7624 66.1132 44.4256 66.2091C44.0892 66.3052 43.7358 66.3257 43.3907 66.2691C43.0457 66.2124 42.7175 66.0802 42.43 65.8817C42.1424 65.6833 41.9025 65.4236 41.7274 65.1214C41.5524 64.8191 41.4467 64.4818 41.4177 64.1337C41.3859 63.746 41.4502 63.3563 41.6052 62.9992C41.7602 62.642 42.0009 62.3285 42.3061 62.0864C42.6113 61.8443 42.9714 61.681 43.3546 61.6112C43.7378 61.5413 44.1322 61.567 44.5029 61.6859C44.7988 61.7803 45.073 61.9321 45.31 62.1326C45.5469 62.3332 45.7419 62.5785 45.8837 62.8545ZM59.3725 55.9194C59.5326 56.2302 59.6215 56.5727 59.6328 56.9222C59.6442 57.2718 59.5777 57.6196 59.4382 57.9405C59.2987 58.2615 59.0897 58.5476 58.8262 58.7782C58.5627 59.0088 58.2513 59.1782 57.9145 59.274C57.5781 59.3703 57.2246 59.3909 56.8795 59.3343C56.5343 59.2778 56.2062 59.1455 55.9186 58.9471C55.6309 58.7486 55.391 58.4889 55.216 58.1865C55.0411 57.8842 54.9354 57.5468 54.9066 57.1986C54.8622 56.6535 55.0084 56.1095 55.3202 55.6595C55.632 55.2094 56.0902 54.881 56.6167 54.7302C57.1433 54.5794 57.7056 54.6155 58.208 54.8324C58.7103 55.0494 59.1223 55.4332 59.3725 55.9194ZM72.8576 48.9863C73.0176 49.2971 73.1065 49.6396 73.1179 49.9891C73.1292 50.3386 73.0628 50.6864 72.9233 51.0074C72.7838 51.3283 72.5747 51.6145 72.3112 51.8451C72.0477 52.0757 71.7363 52.245 71.3995 52.3409C71.0631 52.4372 70.7096 52.4577 70.3645 52.4012C70.0194 52.3447 69.6912 52.2124 69.4036 52.0139C69.116 51.8155 68.8761 51.5557 68.7011 51.2534C68.5261 50.9511 68.4204 50.6137 68.3917 50.2655C68.3598 49.8778 68.4242 49.4881 68.5791 49.131C68.7341 48.7738 68.9748 48.4603 69.28 48.2182C69.5852 47.9761 69.9453 47.8128 70.3285 47.743C70.7118 47.6731 71.1062 47.6988 71.4768 47.8177C71.7727 47.9121 72.0469 48.0639 72.2839 48.2644C72.5208 48.465 72.7158 48.7103 72.8576 48.9863ZM86.3434 42.0528C86.5034 42.3636 86.5923 42.7061 86.6037 43.0556C86.6151 43.4051 86.5486 43.7529 86.4091 44.0739C86.2696 44.3948 86.0605 44.6809 85.797 44.9116C85.5335 45.1422 85.2221 45.3115 84.8853 45.4074C84.5489 45.5035 84.1955 45.524 83.8504 45.4674C83.5054 45.4107 83.1773 45.2785 82.8897 45.08C82.6021 44.8816 82.3622 44.6219 82.1872 44.3197C82.0122 44.0174 81.9064 43.6801 81.8775 43.3319C81.8521 43.0224 81.8881 42.7109 81.9834 42.4151C82.0786 42.1193 82.2312 41.8451 82.4325 41.6081C82.6338 41.3711 82.8798 41.176 83.1565 41.0339C83.4331 40.8918 83.7351 40.8055 84.0449 40.78C84.5114 40.7413 84.9787 40.8416 85.3878 41.0681C85.7968 41.2947 86.1294 41.6373 86.3434 42.0528ZM99.8292 35.1193C100.043 35.5349 100.129 36.0049 100.075 36.4695C100.021 36.9341 99.8303 37.3726 99.527 37.7292C99.3002 37.9957 99.0173 38.2089 98.6985 38.3534C98.3796 38.4978 98.0328 38.5701 97.683 38.5648C97.3331 38.5596 96.9889 38.477 96.675 38.323C96.3611 38.169 96.0853 37.9475 95.8675 37.6742C95.6496 37.4009 95.4953 37.0824 95.4158 36.742C95.3362 36.4016 95.3334 36.0476 95.4076 35.7057C95.4817 35.3639 95.631 35.0426 95.8445 34.7652C96.058 34.4878 96.3305 34.2612 96.6422 34.1017C97.2007 33.8151 97.8498 33.7612 98.4473 33.952C99.0447 34.1428 99.5417 34.5625 99.8292 35.1193ZM113.314 28.1862C113.528 28.6018 113.614 29.0717 113.56 29.5364C113.506 30.0011 113.315 30.4395 113.012 30.796C112.709 31.1525 112.307 31.4113 111.857 31.54C111.407 31.6687 110.929 31.6614 110.484 31.519C110.038 31.3767 109.645 31.1056 109.354 30.7401C109.063 30.3746 108.887 29.931 108.848 29.4653C108.817 29.0779 108.882 28.6886 109.038 28.3319C109.193 27.9753 109.433 27.6621 109.738 27.4202C110.043 27.1783 110.403 27.015 110.786 26.9448C111.169 26.8745 111.563 26.8996 111.933 27.0176C112.229 27.112 112.504 27.2638 112.741 27.4643C112.978 27.6648 113.172 27.9101 113.314 28.1862ZM12.4302 64.1124C12.5904 64.4232 12.6795 64.7658 12.6909 65.1154C12.7024 65.465 12.636 65.8128 12.4965 66.1339C12.357 66.4549 12.148 66.7411 11.8844 66.9718C11.6209 67.2025 11.3094 67.3719 10.9726 67.4678C10.6361 67.5638 10.2826 67.5842 9.93751 67.5275C9.59241 67.4708 9.26428 67.3385 8.97668 67.14C8.68908 66.9415 8.44914 66.6817 8.2741 66.3794C8.09906 66.0771 7.99327 65.7398 7.96432 65.3916C7.93243 65.0039 7.99683 64.6142 8.15179 64.2571C8.30676 63.9 8.5475 63.5864 8.85267 63.3443C9.15784 63.1022 9.518 62.9389 9.90121 62.8691C10.2844 62.7992 10.6788 62.8249 11.0494 62.9438C11.6475 63.1352 12.1438 63.5553 12.4302 64.1124ZM25.916 57.1789C26.0761 57.4897 26.165 57.8323 26.1764 58.1818C26.1877 58.5314 26.1213 58.8792 25.9819 59.2002C25.8424 59.5212 25.6334 59.8073 25.37 60.0381C25.1065 60.2688 24.7952 60.4383 24.4584 60.5343C24.1219 60.6304 23.7683 60.6509 23.4232 60.5943C23.078 60.5377 22.7498 60.4054 22.4621 60.207C22.1744 60.0085 21.9344 59.7488 21.7593 59.4464C21.5842 59.1441 21.4783 58.8067 21.4494 58.4585C21.4112 57.9923 21.5123 57.525 21.7401 57.116C21.9678 56.7069 22.3119 56.3744 22.7287 56.1605C23.2873 55.8736 23.9366 55.8197 24.5342 56.0106C25.1319 56.2016 25.6288 56.6218 25.916 57.1789ZM39.4011 50.2458C39.6149 50.6614 39.7004 51.1311 39.6468 51.5957C39.5931 52.0602 39.4027 52.4986 39.0996 52.8553C38.873 53.122 38.5901 53.3353 38.2713 53.4799C37.9525 53.6245 37.6056 53.6969 37.2557 53.6917C36.9058 53.6866 36.5615 53.6041 36.2475 53.4502C35.9335 53.2963 35.6577 53.0747 35.4398 52.8015C35.222 52.528 35.0678 52.2094 34.9883 51.8689C34.9089 51.5284 34.9062 51.1744 34.9803 50.8325C35.0545 50.4905 35.2037 50.1692 35.4172 49.8917C35.6307 49.6142 35.9032 49.3874 36.2149 49.2278C36.7733 48.941 37.4224 48.8871 38.0198 49.078C38.6172 49.2688 39.114 49.6889 39.4011 50.2458ZM52.89 43.3107C53.1038 43.7264 53.1892 44.1963 53.1354 44.6609C53.0816 45.1255 52.891 45.5639 52.5877 45.9206C52.361 46.1871 52.0782 46.4003 51.7594 46.5448C51.4407 46.6893 51.0939 46.7615 50.7441 46.7564C50.3943 46.7512 50.0501 46.6687 49.7362 46.5148C49.4223 46.361 49.1465 46.1395 48.9286 45.8664C48.7111 45.5929 48.557 45.2744 48.4776 44.934C48.3983 44.5936 48.3955 44.2397 48.4696 43.8979C48.5437 43.5561 48.6927 43.2348 48.906 42.9573C49.1193 42.6798 49.3915 42.4529 49.703 42.2931C50.2614 42.006 50.9107 41.9519 51.5083 42.1427C52.1058 42.3336 52.6028 42.7536 52.89 43.3107ZM66.375 36.3776C66.5889 36.7932 66.6744 37.2629 66.6207 37.7275C66.567 38.192 66.3766 38.6304 66.0735 38.9871C65.8469 39.2538 65.564 39.4671 65.2452 39.6117C64.9264 39.7563 64.5796 39.8287 64.2296 39.8235C63.8797 39.8184 63.5354 39.7359 63.2215 39.582C62.9075 39.4281 62.6316 39.2065 62.4137 38.9333C62.1226 38.5675 61.947 38.1233 61.909 37.6573C61.871 37.1912 61.9725 36.7242 62.2005 36.3154C62.4092 35.9413 62.7155 35.6306 63.0867 35.4164C63.4579 35.2021 63.8802 35.0924 64.3086 35.0989C64.737 35.1053 65.1555 35.2277 65.5194 35.453C65.8834 35.6784 66.1788 35.9974 66.375 36.3776ZM79.8608 29.4441C80.0747 29.8598 80.1601 30.3297 80.1063 30.7943C80.0525 31.2589 79.8619 31.6973 79.5586 32.054C79.3319 32.3205 79.049 32.5337 78.7303 32.6782C78.4115 32.8227 78.0648 32.8949 77.715 32.8897C77.3652 32.8846 77.021 32.8021 76.7071 32.6482C76.3932 32.4943 76.1174 32.2729 75.8995 31.9998C75.6817 31.7263 75.5275 31.4077 75.4481 31.0672C75.3686 30.7267 75.3659 30.3727 75.44 30.0308C75.5142 29.6888 75.6634 29.3675 75.8769 29.09C76.0904 28.8125 76.3629 28.5857 76.6746 28.4261C77.233 28.1395 77.8821 28.0857 78.4794 28.2766C79.0767 28.4674 79.5736 28.8873 79.8608 29.4441ZM93.3466 22.5106C93.5606 22.9262 93.6461 23.3962 93.5923 23.8608C93.5385 24.3254 93.3478 24.7638 93.0444 25.1205C92.8177 25.387 92.5348 25.6001 92.2161 25.7446C91.8973 25.8892 91.5506 25.9614 91.2008 25.9562C90.851 25.9511 90.5068 25.8686 90.1929 25.7147C89.879 25.5608 89.6032 25.3394 89.3853 25.0663C89.1673 24.7929 89.0128 24.4745 88.9332 24.134C88.8536 23.7935 88.8507 23.4394 88.9248 23.0975C88.9989 22.7555 89.1481 22.4342 89.3617 22.1567C89.5753 21.8792 89.8478 21.6525 90.1597 21.493C90.7182 21.2063 91.3673 21.1525 91.9647 21.3433C92.5621 21.5341 93.0591 21.9538 93.3466 22.5106ZM106.832 15.5775C107.046 15.9931 107.131 16.463 107.077 16.9277C107.024 17.3924 106.833 17.8308 106.529 18.1873C106.303 18.454 106.02 18.6673 105.701 18.8119C105.382 18.9565 105.036 19.0288 104.686 19.0236C104.336 19.0184 103.992 18.9359 103.678 18.7819C103.364 18.628 103.088 18.4064 102.87 18.1332C102.579 17.7673 102.404 17.3232 102.366 16.8571C102.328 16.3911 102.429 15.924 102.657 15.5153C102.866 15.1412 103.172 14.8305 103.543 14.6162C103.915 14.402 104.337 14.2923 104.765 14.2987C105.194 14.3052 105.612 14.4276 105.976 14.6529C106.34 14.8782 106.635 15.1972 106.832 15.5775ZM5.90138 51.4137C6.06142 51.7245 6.15033 52.067 6.16169 52.4165C6.17305 52.766 6.10659 53.1138 5.96709 53.4348C5.82759 53.7557 5.61854 54.0418 5.35503 54.2724C5.09152 54.503 4.78013 54.6724 4.44333 54.7683C4.10691 54.8644 3.75348 54.8848 3.40843 54.8282C3.06338 54.7716 2.73527 54.6393 2.44769 54.4409C2.16011 54.2425 1.92019 53.9828 1.74517 53.6806C1.57015 53.3783 1.46438 53.041 1.43547 52.6928C1.40358 52.3051 1.46797 51.9155 1.62294 51.5583C1.77791 51.2012 2.01865 50.8877 2.32382 50.6455C2.62899 50.4034 2.98915 50.2402 3.37236 50.1703C3.75556 50.1005 4.14997 50.1262 4.52059 50.2451C4.81649 50.3395 5.09076 50.4913 5.3277 50.6918C5.56463 50.8923 5.75958 51.1376 5.90138 51.4137ZM19.3872 44.4802C19.5471 44.791 19.6359 45.1335 19.6471 45.4829C19.6584 45.8324 19.5919 46.1801 19.4524 46.501C19.313 46.822 19.104 47.108 18.8406 47.3387C18.5771 47.5693 18.2658 47.7388 17.9291 47.8348C17.5927 47.931 17.2392 47.9516 16.8941 47.895C16.549 47.8385 16.2208 47.7063 15.9331 47.5079C15.6455 47.3095 15.4055 47.0498 15.2304 46.7475C15.0553 46.4453 14.9495 46.1079 14.9205 45.7597C14.8951 45.4502 14.931 45.1386 15.0262 44.8427C15.1214 44.5469 15.274 44.2726 15.4753 44.0356C15.6766 43.7986 15.9226 43.6035 16.1994 43.4614C16.4761 43.3194 16.7781 43.2332 17.088 43.2078C17.5545 43.1689 18.0219 43.269 18.4312 43.4955C18.8404 43.722 19.1731 44.0646 19.3872 44.4802ZM32.8722 37.547C33.0323 37.8578 33.1212 38.2004 33.1326 38.5499C33.1439 38.8994 33.0774 39.2472 32.9379 39.5681C32.7984 39.8891 32.5894 40.1752 32.3259 40.4058C32.0624 40.6364 31.751 40.8058 31.4142 40.9017C31.0778 40.9977 30.7243 41.0182 30.3793 40.9616C30.0342 40.905 29.7061 40.7727 29.4186 40.5743C29.131 40.3758 28.891 40.1162 28.716 39.8139C28.541 39.5117 28.4352 39.1744 28.4063 38.8262C28.3744 38.4385 28.4388 38.0488 28.5938 37.6917C28.7488 37.3346 28.9895 37.021 29.2947 36.7789C29.5999 36.5368 29.96 36.3736 30.3432 36.3037C30.7264 36.2339 31.1208 36.2595 31.4914 36.3785C31.7873 36.4729 32.0616 36.6247 32.2986 36.8252C32.5355 37.0257 32.7304 37.271 32.8722 37.547ZM46.3611 30.612C46.5212 30.9228 46.6101 31.2653 46.6214 31.6148C46.6328 31.9643 46.5663 32.3121 46.4268 32.633C46.2873 32.954 46.0783 33.2401 45.8148 33.4707C45.5513 33.7013 45.2399 33.8707 44.9031 33.9666C44.5666 34.0627 44.2132 34.0831 43.8682 34.0265C43.5231 33.9699 43.195 33.8376 42.9074 33.6392C42.6198 33.4408 42.3799 33.1811 42.2049 32.8788C42.0299 32.5766 41.9241 32.2393 41.8952 31.8911C41.8508 31.346 41.9969 30.8021 42.3088 30.352C42.6206 29.9019 43.0788 29.5735 43.6053 29.4227C44.1319 29.2719 44.6942 29.3081 45.1965 29.525C45.6989 29.7419 46.1109 30.1258 46.3611 30.612ZM59.8462 23.6788C60.0062 23.9896 60.0951 24.3322 60.1065 24.6817C60.1178 25.0312 60.0514 25.379 59.9119 25.6999C59.7724 26.0209 59.5633 26.307 59.2998 26.5376C59.0363 26.7682 58.7249 26.9376 58.3881 27.0335C58.0517 27.1295 57.6983 27.15 57.3532 27.0934C57.0082 27.0368 56.6801 26.9045 56.3925 26.7061C56.1049 26.5077 55.865 26.248 55.69 25.9457C55.5149 25.6435 55.4092 25.3062 55.3802 24.958C55.3422 24.4918 55.4434 24.0247 55.6711 23.6156C55.8989 23.2065 56.2429 22.874 56.6596 22.6601C57.2181 22.3734 57.8673 22.3197 58.4648 22.5107C59.0622 22.7017 59.559 23.1218 59.8462 23.6788ZM73.332 16.7453C73.492 17.0561 73.5809 17.3987 73.5923 17.7482C73.6036 18.0977 73.5372 18.4455 73.3977 18.7664C73.2582 19.0874 73.0491 19.3735 72.7856 19.6041C72.5221 19.8347 72.2107 20.0041 71.8739 20.1C71.5375 20.196 71.1841 20.2165 70.839 20.1599C70.494 20.1033 70.1659 19.971 69.8783 19.7726C69.5907 19.5741 69.3508 19.3145 69.1758 19.0122C69.0007 18.71 68.895 18.3726 68.8661 18.0245C68.8279 17.5583 68.929 17.0911 69.1568 16.682C69.3845 16.2729 69.7286 15.9404 70.1454 15.7266C70.7039 15.4397 71.3532 15.3858 71.9507 15.5769C72.5482 15.7679 73.045 16.1882 73.332 16.7453ZM86.8178 9.81182C87.0317 10.2275 87.1172 10.6974 87.0634 11.162C87.0096 11.6267 86.8189 12.0651 86.5155 12.4217C86.2888 12.6883 86.0059 12.9014 85.687 13.0459C85.3682 13.1904 85.0214 13.2626 84.6716 13.2573C84.3217 13.2521 83.9775 13.1695 83.6636 13.0155C83.3497 12.8616 83.0739 12.64 82.8561 12.3668C82.638 12.0934 82.4836 11.775 82.404 11.4345C82.3243 11.094 82.3214 10.7399 82.3955 10.398C82.4697 10.056 82.6189 9.73464 82.8325 9.45715C83.046 9.17965 83.3186 8.95296 83.6304 8.79345C84.189 8.50677 84.8383 8.45298 85.4359 8.6439C86.0334 8.83482 86.5304 9.25485 86.8178 9.81182ZM100.303 2.87871C100.517 3.29433 100.602 3.76429 100.549 4.22895C100.495 4.69361 100.304 5.13203 100.001 5.48858C99.6974 5.84501 99.2955 6.10389 98.8455 6.23256C98.3956 6.36123 97.9177 6.35393 97.4723 6.21157C97.0269 6.06921 96.6339 5.79818 96.3428 5.43268C96.0517 5.06717 95.8757 4.62358 95.8369 4.15787C95.8059 3.77042 95.8709 3.38117 96.0261 3.02449C96.1813 2.66781 96.4221 2.35467 96.727 2.11274C97.0319 1.8708 97.3917 1.70752 97.7745 1.6373C98.1573 1.56708 98.5515 1.5921 98.922 1.71013C99.2179 1.80453 99.4922 1.95634 99.7292 2.15686C99.9661 2.35738 100.161 2.60268 100.303 2.87871Z",
                fill: "currentColor"
              })
            })]
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "col-lg-6",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_height_20 cs_height_lg_20"
            })]
          }), section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
              className: "mb-0",
              dangerouslySetInnerHTML: {
                __html: section_description
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_height_30 cs_height_lg_30"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", {
          className: "cs_list cs_style_1 cs_mp0",
          children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", {
              children: [(item.feature_title || item.feature_subtitle) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("i", {
                className: "cs_tick_icon cs_accent_color d-flex",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
                  width: 18,
                  height: 17,
                  viewBox: "0 0 18 17",
                  fill: "none",
                  xmlns: "http://www.w3.org/2000/svg",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
                    d: "M0 9.62275C0.0320847 8.83012 0.390363 8.2499 1.11227 7.93388C1.84487 7.61269 2.54004 7.73702 3.1443 8.25508C4.06406 9.0477 4.96777 9.85587 5.87684 10.6589C6.04796 10.8091 6.21908 10.9645 6.39554 11.1148C6.65757 11.3427 6.88751 11.3323 7.12279 11.0733C9.096 8.91819 11.0639 6.75789 13.0371 4.5976C14.3686 3.13668 15.7054 1.68094 17.037 0.220014C17.2027 0.0386945 17.3952 -0.0493752 17.6412 0.0283334C17.8498 0.0956808 18.0102 0.277001 17.9995 0.494585C17.9941 0.608557 17.946 0.732891 17.8819 0.831322C16.3685 3.19884 14.8552 5.56118 13.3419 7.92352C11.5986 10.6433 9.85534 13.3631 8.11207 16.0881C7.80727 16.5647 7.39551 16.8859 6.81264 16.974C6.15491 17.0776 5.60947 16.8704 5.19237 16.3782C3.69508 14.6116 2.20849 12.8399 0.716557 11.0681C0.433143 10.7469 0.133686 10.4257 0.0534744 9.98539C0.0267372 9.85587 0.0160423 9.73154 0 9.62275Z",
                    fill: "currentColor"
                  })
                })
              }), item.feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", {
                className: "cs_fs_24 cs_normal mb-0",
                dangerouslySetInnerHTML: {
                  __html: item.feature_title
                }
              }), item.feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
                dangerouslySetInnerHTML: {
                  __html: item.feature_subtitle
                }
              })]
            }, index);
          })
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/About/About5.jsx":
/*!***********************************************************!*\
  !*** ./resources/js/Frontend/Components/About/About5.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ About5)
/* harmony export */ });
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function About5(_ref) {
  var data = _ref.data;
  var image_url = data.image_url,
    section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    section_description = data.section_description,
    phone_number = data.phone_number,
    experience_title = data.experience_title,
    experience_year = data.experience_year,
    feature_list = data.feature_list,
    action_text = data.action_text,
    action_url = data.action_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "row align-items-center cs_gap_y_40",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "col-lg-5",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "position-relative",
          children: [image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
            src: image_url,
            alt: section_title
          }), (experience_year || experience_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "cs_experience_box cs_style_1 cs_accent_bg position-absolute",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h3", {
              className: "cs_white_color cs_fs_60 cs_bold mb-0",
              dangerouslySetInnerHTML: {
                __html: experience_year
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
              className: "cs_white_color mb-0 cs_fs_30 cs_normal",
              dangerouslySetInnerHTML: {
                __html: experience_title
              }
            })]
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "col-lg-6 offset-lg-1",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              className: "cs_height_26 cs_height_lg_20"
            })]
          }), section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
              className: "mb-0",
              dangerouslySetInnerHTML: {
                __html: section_description
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              className: "cs_height_30 cs_height_lg_30"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
          className: "cs_list cs_style_1 cs_type_1 cs_mp0",
          children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
              children: [(item.feature_title || item.feature_subtitle) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                className: "cs_tick_icon cs_accent_color d-flex",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("svg", {
                  width: 30,
                  height: 30,
                  viewBox: "0 0 30 30",
                  fill: "none",
                  xmlns: "http://www.w3.org/2000/svg",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("g", {
                    clipPath: "url(#clip_0)",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
                      d: "M30.0586 14.1797C30.0586 14.7656 30.0586 15.3516 30.0586 15.9375C30.041 16.0195 30.0176 16.1074 30.0117 16.1895C29.8652 18.2812 29.3145 20.2676 28.3008 22.1016C25.9688 26.3262 22.4238 28.9102 17.6719 29.8242C17.0977 29.9355 16.5176 29.9824 15.9375 30.0586C15.3516 30.0586 14.7656 30.0586 14.1797 30.0586C14.1035 30.041 14.0273 30.0176 13.9512 30.0117C11.8477 29.8711 9.85547 29.3145 8.01562 28.3008C3.79102 25.9629 1.20117 22.418 0.292969 17.6719C0.181641 17.0977 0.134766 16.5176 0.0585938 15.9375C0.0585938 15.3516 0.0585938 14.7656 0.0585938 14.1797C0.0761719 14.0977 0.0996094 14.0098 0.105469 13.9277C0.251953 11.8359 0.808594 9.84961 1.81641 8.01562C4.14844 3.79102 7.69336 1.20703 12.4453 0.292969C13.0195 0.181641 13.5996 0.134766 14.1797 0.0585938C14.7656 0.0585938 15.3516 0.0585938 15.9375 0.0585938C16.0137 0.0761719 16.0898 0.0996094 16.166 0.105469C18.2695 0.246094 20.2617 0.802734 22.1016 1.81641C26.3262 4.1543 28.916 7.69922 29.8242 12.4453C29.9297 13.0195 29.9824 13.5996 30.0586 14.1797ZM15.0586 27.7148C22.0371 27.7148 27.7031 22.0547 27.709 15.0703C27.7266 8.08594 22.043 2.40234 15.0586 2.40234C8.07422 2.40234 2.41406 8.0625 2.40234 15.0469C2.39062 22.0312 8.07422 27.7148 15.0586 27.7148Z",
                      fill: "currentColor"
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
                      d: "M13.0598 17.3789C13.1301 17.2676 13.177 17.1504 13.259 17.0684C15.4739 14.8477 17.6887 12.6387 19.9035 10.418C20.1672 10.1543 20.4602 9.95508 20.8469 9.95508C21.3157 9.96094 21.6731 10.1719 21.8899 10.5879C22.1067 11.0039 22.0715 11.4199 21.802 11.8008C21.7258 11.9121 21.6262 12.0117 21.5325 12.1055C19.0129 14.625 16.4934 17.1445 13.9739 19.6641C13.3118 20.3262 12.6789 20.3262 12.0227 19.6641C10.8508 18.4922 9.67308 17.3203 8.5012 16.1426C8.06175 15.7031 7.96214 15.1816 8.21409 14.707C8.59495 13.9805 9.51488 13.8574 10.1418 14.4727C11.0207 15.334 11.8821 16.2129 12.7493 17.0801C12.8313 17.1621 12.9075 17.2324 13.0598 17.3789Z",
                      fill: "currentColor"
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("defs", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("clipPath", {
                      id: "clip_0",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("rect", {
                        width: 30,
                        height: 30,
                        fill: "white"
                      })
                    })
                  })]
                })
              }), item.feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h3", {
                className: "cs_fs_24 cs_normal mb-0",
                dangerouslySetInnerHTML: {
                  __html: item.feature_title
                }
              }), item.feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
                dangerouslySetInnerHTML: {
                  __html: item.feature_subtitle
                }
              })]
            }, index);
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "cs_height_50 cs_height_lg_30"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "cs_btn_group cs_style_1",
          children: [(action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
            href: action_url,
            btnText: action_text,
            btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_primary_bg"
          }), phone_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "cs_hero_phone_number cs_primary_font cs_fs_24 cs_primary_color",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
              className: "cs_accent_bg cs_white_color cs_center",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                className: "cs_center",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_0__.Icon, {
                  icon: "fa6-solid:phone"
                })
              })
            }), phone_number]
          })]
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/About/About6.jsx":
/*!***********************************************************!*\
  !*** ./resources/js/Frontend/Components/About/About6.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ About6)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function About6(_ref) {
  var data = _ref.data;
  var image_url = data.image_url,
    section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    section_description = data.section_description,
    description_title = data.description_title;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
    className: "container",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: "cs_section_heading cs_style_1",
      children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
        className: "cs_section_subtitle cs_fs_18 cs_medium",
        dangerouslySetInnerHTML: {
          __html: section_subtitle
        }
      }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h1", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "cs_height_76 cs_height_lg_50"
        })]
      })]
    }), image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "cs_full_screen_right cs_radius_50_0_0_0 cs_about_thumb_1 cs_bg_filed",
        style: {
          backgroundImage: "url(".concat(image_url, ")")
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "cs_height_75 cs_height_lg_40"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: "row cs_gap_y_30",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "col-lg-4",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
          className: "cs_btn cs_style_1 cs_type_5 cs_primary_color cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: description_title
          }
        })
      }), section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "col-lg-8",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h4", {
          className: "cs_fs_30 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_description
          }
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Accordion.jsx":
/*!********************************************************!*\
  !*** ./resources/js/Frontend/Components/Accordion.jsx ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Accordion)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }


function AccordionItem(_ref) {
  var title = _ref.title,
    content = _ref.content,
    isOpen = _ref.isOpen,
    onClick = _ref.onClick;
  var accordionContentRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    contentHeight = _useState2[0],
    setContentHeight = _useState2[1];
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (accordionContentRef.current) {
      // Measure the content's height and set it dynamically
      setContentHeight(accordionContentRef.current.offsetHeight);
    }
  }, [isOpen]);
  var accordionClass = isOpen ? "cs_accordian active" : "cs_accordian";
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: accordionClass,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "cs_accordian_head",
        onClick: onClick,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_accordian_title cs_fs_24 cs_normal",
          children: title
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
          className: "cs_accordian_toggle cs_accent_color"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_accordian_body_wrap",
        style: {
          height: isOpen ? "".concat(contentHeight, "px") : "0"
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "cs_accordian_body",
          ref: accordionContentRef,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
            children: content
          })
        })
      })]
    })
  });
}
function Accordion(_ref2) {
  var accordionData = _ref2.accordionData,
    variant = _ref2.variant;
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(-1),
    _useState4 = _slicedToArray(_useState3, 2),
    openItemIndex = _useState4[0],
    setOpenItemIndex = _useState4[1]; // Initialize with -1 for no item open initially
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true),
    _useState6 = _slicedToArray(_useState5, 2),
    firstItemOpen = _useState6[0],
    setFirstItemOpen = _useState6[1]; // Set the first item to open initially

  var handleItemClick = function handleItemClick(index) {
    if (index === openItemIndex) {
      setOpenItemIndex(-1);
    } else {
      setOpenItemIndex(index);
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    // Open the first item when the component mounts
    if (firstItemOpen) {
      setOpenItemIndex(0);
      setFirstItemOpen(false);
    }
  }, [firstItemOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: variant,
      children: accordionData === null || accordionData === void 0 ? void 0 : accordionData.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(AccordionItem, {
          title: item.faq_question,
          content: item.faq_answer,
          isOpen: index === openItemIndex,
          onClick: function onClick() {
            return handleItemClick(index);
          }
        }, index);
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/AditionalFeature/AditionalFeature1.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/AditionalFeature/AditionalFeature1.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AditionalFeature1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function AditionalFeature1(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "col-xl-4 col-lg-5",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        }), (feature_list === null || feature_list === void 0 ? void 0 : feature_list.length) > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "cs_height_44 cs_height_lg_30"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "cs_slider_arrows cs_style1",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "cs_left_arrow cs_accent_bg rounded-circle cs_center cs_white_color",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
                width: 17,
                height: 12,
                viewBox: "0 0 17 12",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
                  d: "M0.469669 5.46967C0.176777 5.76256 0.176777 6.23744 0.469669 6.53033L5.24264 11.3033C5.53553 11.5962 6.01041 11.5962 6.3033 11.3033C6.59619 11.0104 6.59619 10.5355 6.3033 10.2426L2.06066 6L6.3033 1.75736C6.59619 1.46447 6.59619 0.989593 6.3033 0.696699C6.01041 0.403806 5.53553 0.403806 5.24264 0.696699L0.469669 5.46967ZM17 5.25L1 5.25V6.75L17 6.75V5.25Z",
                  fill: "currentColor"
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "cs_right_arrow cs_accent_bg rounded-circle cs_center cs_white_color",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
                width: 17,
                height: 12,
                viewBox: "0 0 17 12",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
                  d: "M16.5303 6.53033C16.8232 6.23744 16.8232 5.76256 16.5303 5.46967L11.7574 0.696698C11.4645 0.403805 10.9896 0.403805 10.6967 0.696698C10.4038 0.989592 10.4038 1.46447 10.6967 1.75736L14.9393 6L10.6967 10.2426C10.4038 10.5355 10.4038 11.0104 10.6967 11.3033C10.9896 11.5962 11.4645 11.5962 11.7574 11.3033L16.5303 6.53033ZM6.55671e-08 6.75L16 6.75L16 5.25L-6.55671e-08 5.25L6.55671e-08 6.75Z",
                  fill: "currentColor"
                })
              })
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "cs_height_85 cs_height_lg_50"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "col-xl-8 col-lg-7 cs_slider cs_style_2",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "cs_slider_2_in",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "cs_auto_per_view_1 cs_full_screen_right",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
              slidesPerView: "auto",
              spaceBetween: 24,
              pagination: false,
              speed: 800,
              loop: true,
              modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Navigation],
              navigation: {
                nextEl: ".cs_right_arrow",
                prevEl: ".cs_left_arrow",
                disabledClass: "swiper-button-disabled"
              },
              className: "mySwiper",
              children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
                  children: (item.feature_image_url || item.feature_title || item.feature_subtitle) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                    className: "cs_card cs_style_2 cs_gray_bg",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                      className: "cs_card_in",
                      children: [item.feature_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                        className: "cs_card_thumb",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
                          src: item.feature_image_url,
                          alt: item.feature_title
                        })
                      }), item.feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h2", {
                        className: "cs_card_title cs_normal cs_fs_30",
                        dangerouslySetInnerHTML: {
                          __html: item.feature_title
                        }
                      }), item.feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
                        className: "cs_card_subtitle mb-0",
                        dangerouslySetInnerHTML: {
                          __html: item.feature_subtitle
                        }
                      })]
                    })
                  })
                }, index);
              })
            })
          })
        })
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/AditionalFeature/AditionalFeature2.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/AditionalFeature/AditionalFeature2.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AditionalFeature2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function AditionalFeature2(_ref) {
  var data = _ref.data;
  var section_image_url = data.section_image_url,
    section_description = data.section_description,
    section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "row align-items-center cs_gap_y_40",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "col-lg-6",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
              className: "cs_height_26 cs_height_lg_20"
            })]
          }), section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
              className: "mb-0",
              dangerouslySetInnerHTML: {
                __html: section_description
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
              className: "cs_height_35 cs_height_lg_30"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "d-flex cs_gap_y_30 flex-wrap",
          children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), {
              children: (item.feature_image_url || item.feature_title || item.feature_subtitle) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                className: "cs_iconbox cs_style_3 w-100",
                children: [item.feature_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                  className: "cs_iconbox_icon",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                    src: item.feature_image_url,
                    alt: "Icon"
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                  className: "cs_iconbox_right",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h3", {
                    className: "cs_iconbox_title cs_normal cs_fs_24",
                    dangerouslySetInnerHTML: {
                      __html: item.feature_title
                    }
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
                    className: "cs_iconbox_subtitle mb-0",
                    dangerouslySetInnerHTML: {
                      __html: item.feature_subtitle
                    }
                  })]
                })]
              })
            }, index);
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "col-lg-6",
        children: section_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "cs_right_full_width cs_space_120",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
            src: section_image_url,
            alt: "Thumb"
          })
        })
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/AditionalFeature/AditionalFeature3.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/AditionalFeature/AditionalFeature3.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AditionalFeature3)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function AditionalFeature3(_ref) {
  var data = _ref.data;
  var feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: feature_list.map(function (item, index) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_scroll_slide cs_top_sticky_0",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "cs_planing_wrap cs_center",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
            className: "container",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
              className: "row align-items-center cs_gap_y_50",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                className: "col-lg-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("h2", {
                  className: "cs_planing_title cs_fs_53 cs_normal",
                  children: [item.feature_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
                    children: item.feature_number
                  }), item.feature_title]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("ul", {
                  className: "cs_planing_list cs_mp0",
                  children: item.inner_feature_list.map(function (innerItem, innerItemIndex) {
                    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("li", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                        className: "cs_iconbox cs_style_6",
                        children: [innerItem.inner_feature_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                          className: "cs_iconbox_icon cs_accent_bg cs_center",
                          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                            src: innerItem.inner_feature_icon_url,
                            alt: "Icon"
                          })
                        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                          className: "cs_iconbox_right",
                          children: [innerItem.inner_feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h3", {
                            className: "cs_iconbox_title cs_fs_30 cs_normal",
                            dangerouslySetInnerHTML: {
                              __html: innerItem.inner_feature_title
                            }
                          }), innerItem.inner_feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
                            className: "cs_iconbox_subtitle mb-0",
                            dangerouslySetInnerHTML: {
                              __html: innerItem.inner_feature_subtitle
                            }
                          })]
                        })]
                      })
                    }, innerItemIndex);
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                className: "col-lg-6 offset-lg-1",
                children: item.feature_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                  className: "cs_planing_thumb",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                    src: item.feature_image_url,
                    alt: item.feature_title
                  })
                })
              })]
            })
          })
        })
      }, index);
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/AditionalFeature/AditionalFeature4.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/AditionalFeature/AditionalFeature4.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AditionalFeature4)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function AditionalFeature4(_ref) {
  var data = _ref.data;
  var feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: feature_list.map(function (item, index) {
      var isEven = index % 2 === 1; // Check if index is even (0-based)

      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_scroll_slide cs_top_sticky_0",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "cs_planing_wrap cs_type_1 cs_center",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
            className: "container",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
              className: "row align-items-center cs_gap_y_50",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                className: "col-lg-5 ".concat(isEven ? "order-lg-2 offset-lg-1" : ""),
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("h2", {
                  className: "cs_planing_title cs_fs_53 cs_normal",
                  children: [item.feature_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
                    children: item.feature_number
                  }), item.feature_title]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("ul", {
                  className: "cs_planing_list cs_mp0",
                  children: item.inner_feature_list.map(function (innerItem, innerItemIndex) {
                    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("li", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                        className: "cs_iconbox cs_style_6",
                        children: [innerItem.inner_feature_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                          className: "cs_iconbox_icon cs_accent_bg cs_center",
                          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                            src: innerItem.inner_feature_icon_url,
                            alt: "Icon"
                          })
                        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                          className: "cs_iconbox_right",
                          children: [innerItem.inner_feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h3", {
                            className: "cs_iconbox_title cs_fs_30 cs_normal",
                            dangerouslySetInnerHTML: {
                              __html: innerItem.inner_feature_title
                            }
                          }), innerItem.inner_feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
                            className: "cs_iconbox_subtitle mb-0",
                            dangerouslySetInnerHTML: {
                              __html: innerItem.inner_feature_subtitle
                            }
                          })]
                        })]
                      })
                    }, innerItemIndex);
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                className: "col-lg-6 ".concat(isEven ? "order-lg-1" : "offset-lg-1"),
                children: item.feature_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                  className: "cs_planing_thumb",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                    src: item.feature_image_url,
                    alt: item.feature_title
                  })
                })
              })]
            })
          })
        })
      }, index);
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Banner/Banner1.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Banner/Banner1.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Banner1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }



function Banner1(_ref) {
  var data = _ref.data;
  var title = data.title,
    background_image_url = data.background_image_url,
    desktop_height = data.desktop_height,
    mobile_height = data.mobile_height;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("desktop"),
    _useState2 = _slicedToArray(_useState, 2),
    screenSize = _useState2[0],
    setScreenSize = _useState2[1];
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleResize = function handleResize() {
      if (window.innerWidth < 768) {
        setScreenSize("mobile");
      } else {
        setScreenSize("desktop");
      }
    };
    handleResize();

    // Add event listener for window resize
    window.addEventListener("resize", handleResize);

    // Cleanup the event listener on component unmount
    return function () {
      return window.removeEventListener("resize", handleResize);
    };
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "cs_banner cs_style_1 cs_bg_filed cs_primary_bg",
    style: {
      backgroundImage: "url(".concat(background_image_url, ")"),
      height: screenSize === "desktop" ? "".concat(desktop_height, "px") : "".concat(mobile_height, "px")
    },
    children: title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
        className: "mb-0 cs_white_color cs_fs_30 text-end cs_normal",
        dangerouslySetInnerHTML: {
          __html: title
        }
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Banner/Banner2.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Banner/Banner2.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Banner2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }



function Banner2(_ref) {
  var data = _ref.data;
  var title = data.title,
    background_image_url = data.background_image_url,
    desktop_height = data.desktop_height,
    mobile_height = data.mobile_height;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("desktop"),
    _useState2 = _slicedToArray(_useState, 2),
    screenSize = _useState2[0],
    setScreenSize = _useState2[1];
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleResize = function handleResize() {
      if (window.innerWidth < 768) {
        setScreenSize("mobile");
      } else {
        setScreenSize("desktop");
      }
    };
    handleResize();

    // Add event listener for window resize
    window.addEventListener("resize", handleResize);

    // Cleanup the event listener on component unmount
    return function () {
      return window.removeEventListener("resize", handleResize);
    };
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "cs_banner cs_style_1 cs_bg_filed cs_primary_bg",
    style: {
      backgroundImage: "url(".concat(background_image_url, ")"),
      height: screenSize === "desktop" ? "".concat(desktop_height, "px") : "".concat(mobile_height, "px")
    },
    children: title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
        className: "mb-0 cs_white_color cs_fs_50 text-end cs_normal",
        dangerouslySetInnerHTML: {
          __html: title
        }
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Banner/Banner3.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Banner/Banner3.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Banner3)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }



function Banner3(_ref) {
  var data = _ref.data;
  var title = data.title,
    background_image_url = data.background_image_url,
    desktop_height = data.desktop_height,
    mobile_height = data.mobile_height;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("desktop"),
    _useState2 = _slicedToArray(_useState, 2),
    screenSize = _useState2[0],
    setScreenSize = _useState2[1];
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleResize = function handleResize() {
      if (window.innerWidth < 768) {
        setScreenSize("mobile");
      } else {
        setScreenSize("desktop");
      }
    };
    handleResize();

    // Add event listener for window resize
    window.addEventListener("resize", handleResize);

    // Cleanup the event listener on component unmount
    return function () {
      return window.removeEventListener("resize", handleResize);
    };
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "cs_banner cs_style_3 cs_bg_filed text-center cs_center",
    style: {
      backgroundImage: "url(".concat(background_image_url, ")"),
      height: screenSize === "desktop" ? "".concat(desktop_height, "px") : "".concat(mobile_height, "px")
    },
    children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
        className: "mb-0 cs_white_color cs_fs_60 cs_bold",
        dangerouslySetInnerHTML: {
          __html: title
        }
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "cs_shape_1 cs_accent_color",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("svg", {
        width: 228,
        height: 475,
        viewBox: "0 0 228 475",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("rect", {
          x: "195.468",
          y: "187.383",
          width: 451,
          height: 42,
          transform: "rotate(140.444 195.468 187.383)",
          fill: "currentColor"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("rect", {
          x: "212.468",
          y: "109.383",
          width: 451,
          height: 42,
          transform: "rotate(140.444 212.468 109.383)",
          fill: "currentColor"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("rect", {
          x: "227.468",
          y: "32.3826",
          width: 451,
          height: 42,
          transform: "rotate(140.444 227.468 32.3826)",
          fill: "currentColor"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "cs_shape_2 cs_accent_color",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("svg", {
        width: 210,
        height: 475,
        viewBox: "0 0 210 475",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("rect", {
          x: 32,
          y: "287.213",
          width: 451,
          height: 42,
          transform: "rotate(-39.5563 32 287.213)",
          fill: "currentColor"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("rect", {
          x: 15,
          y: "365.213",
          width: 451,
          height: 42,
          transform: "rotate(-39.5563 15 365.213)",
          fill: "currentColor"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("rect", {
          y: "442.213",
          width: 451,
          height: 42,
          transform: "rotate(-39.5563 0 442.213)",
          fill: "currentColor"
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Banner/Banner4.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Banner/Banner4.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Banner4)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Banner4(_ref) {
  var data = _ref.data;
  var title = data.title,
    subtitle = data.subtitle,
    image_url = data.image_url,
    background_image_url = data.background_image_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "cs_section_heading cs_style_1",
        children: [image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "cs_shape_1",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
            src: image_url,
            alt: "Icon"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: subtitle
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: title
          }
        })]
      })
    }), background_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_height_90 cs_height_lg_70"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_about_thumb_1 cs_bg_filed",
        style: {
          backgroundImage: "url(".concat(background_image_url, ")")
        }
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Banner/Banner5.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Banner/Banner5.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Banner5)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Banner5(_ref) {
  var data = _ref.data;
  var title = data.title,
    subtitle = data.subtitle,
    background_image_url = data.background_image_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "cs_page_heading cs_style_1 cs_bg_filed cs_primary_bg",
    style: {
      backgroundImage: "url(".concat(background_image_url, ")")
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "cs_section_heading cs_style_1",
        children: [subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium cs_white_color",
          dangerouslySetInnerHTML: {
            __html: subtitle
          }
        }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h1", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0 cs_white_color",
          dangerouslySetInnerHTML: {
            __html: title
          }
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Banner/Banner6.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Banner/Banner6.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Banner6)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Banner6(_ref) {
  var data = _ref.data;
  var title = data.title,
    subtitle = data.subtitle,
    background_image_url = data.background_image_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "container",
      children: (subtitle || title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: subtitle
            }
          }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h1", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: title
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "cs_height_85 cs_height_lg_50"
        })]
      })
    }), background_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "cs_half_white",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
          src: background_image_url,
          alt: "Thumbnail",
          className: "cs_radius_50_50_0_0"
        })
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Blog/Blog1.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Blog/Blog1.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Blog1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! moment */ "moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);






function Blog1(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    pagination_style = data.pagination_style;
  var blogs = localStorage.getItem("blogs") ? JSON.parse(localStorage.getItem("blogs")) : [];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "container",
      children: (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "cs_section_heading cs_style_1 text-center",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_height_85 cs_height_lg_50"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "container-fluid",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
        slidesPerView: 1,
        spaceBetween: 24,
        pagination: {
          clickable: true
        },
        speed: 800,
        loop: true,
        modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination],
        className: "mySwiper".concat(pagination_style === "pagination_0" ? " cs_swiper_pagination_wrap_0" : "").concat(pagination_style === "pagination_1" ? " cs_swiper_pagination_wrap_1" : "").concat(pagination_style === "pagination_2" ? " cs_swiper_pagination_wrap_2" : "").concat(pagination_style === "pagination_3" ? " cs_swiper_pagination_wrap_3" : ""),
        breakpoints: {
          575: {
            slidesPerView: 2,
            spaceBetween: 20
          },
          991: {
            slidesPerView: 3
          },
          1400: {
            slidesPerView: 4
          }
        },
        children: blogs === null || blogs === void 0 ? void 0 : blogs.map(function (item, index) {
          var _item$content, _item$category, _item$content2;
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "cs_post cs_style_1",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                className: "cs_post_thumb",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
                  src: item === null || item === void 0 ? void 0 : item.thumbnail_image,
                  alt: item === null || item === void 0 || (_item$content = item.content) === null || _item$content === void 0 ? void 0 : _item$content.title
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                className: "cs_post_info",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "cs_post_meta",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
                    className: "cs_medium cs_fs_18 cs_primary_color",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("a", {
                      href: "blog-details.html",
                      children: item === null || item === void 0 || (_item$category = item.category) === null || _item$category === void 0 || (_item$category = _item$category.content) === null || _item$category === void 0 ? void 0 : _item$category.title
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
                    children: moment__WEBPACK_IMPORTED_MODULE_4___default()(item === null || item === void 0 ? void 0 : item.created_at).format("ll")
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
                  className: "cs_post_title cs_fs_30 cs_normal mb-0",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                    href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                    children: item === null || item === void 0 || (_item$content2 = item.content) === null || _item$content2 === void 0 ? void 0 : _item$content2.title
                  })
                })]
              })]
            })
          }, index);
        })
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Blog/Blog2.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Blog/Blog2.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Blog2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);






function Blog2(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    action_text = data.action_text,
    pagination_style = data.pagination_style,
    navigation_style = data.navigation_style;
  var blogs = localStorage.getItem("blogs") ? JSON.parse(localStorage.getItem("blogs")) : [];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "container",
      children: (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "cs_section_heading cs_style_1 text-center",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_height_85 cs_height_lg_50"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "position-relative",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
          slidesPerView: 1,
          spaceBetween: 24,
          pagination: {
            clickable: true
          },
          speed: 800,
          loop: true,
          modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Navigation],
          navigation: {
            nextEl: ".cs_right_arrow",
            prevEl: ".cs_left_arrow",
            disabledClass: "swiper-button-disabled"
          },
          className: "mySwiper".concat(pagination_style === "pagination_0" ? " cs_swiper_pagination_wrap_0" : "").concat(pagination_style === "pagination_1" ? " cs_swiper_pagination_wrap_1" : "").concat(pagination_style === "pagination_2" ? " cs_swiper_pagination_wrap_2" : "").concat(pagination_style === "pagination_3" ? " cs_swiper_pagination_wrap_3" : ""),
          breakpoints: {
            767: {
              slidesPerView: 2,
              spaceBetween: 20
            },
            991: {
              slidesPerView: 3
            }
          },
          children: blogs === null || blogs === void 0 ? void 0 : blogs.map(function (item, index) {
            var _item$content, _item$content2, _item$content3;
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                className: "cs_post cs_style_2",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                  href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                  className: "cs_post_thumb",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
                    src: item === null || item === void 0 ? void 0 : item.thumbnail_image,
                    alt: item === null || item === void 0 || (_item$content = item.content) === null || _item$content === void 0 ? void 0 : _item$content.title
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "cs_post_info",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
                    className: "cs_post_title cs_fs_30 cs_normal",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                      href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                      children: item === null || item === void 0 || (_item$content2 = item.content) === null || _item$content2 === void 0 ? void 0 : _item$content2.title
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
                    className: "cs_post_subtitle",
                    children: item === null || item === void 0 || (_item$content3 = item.content) === null || _item$content3 === void 0 ? void 0 : _item$content3.content.replace(/<[^>]*>/g, "").substring(0, 200)
                  }), action_text && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_4__["default"], {
                    href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                    btnText: action_text,
                    btnClass: "cs_btn cs_style_1 cs_type_4 cs_primary_color cs_fs_18 cs_medium"
                  })]
                })]
              })
            }, index);
          })
        })
      }), navigation_style === "navigation_0" && "", navigation_style === "navigation_1" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "cs_slider_arrows cs_style2 cs_mobile_hide",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_left_arrow cs_accent_color",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("svg", {
            width: 52,
            height: 24,
            viewBox: "0 0 52 24",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("path", {
              d: "M0.939339 10.9393C0.353554 11.5251 0.353554 12.4749 0.939339 13.0607L10.4853 22.6066C11.0711 23.1924 12.0208 23.1924 12.6066 22.6066C13.1924 22.0208 13.1924 21.0711 12.6066 20.4853L4.12132 12L12.6066 3.51472C13.1924 2.92893 13.1924 1.97919 12.6066 1.3934C12.0208 0.807611 11.0711 0.807611 10.4853 1.3934L0.939339 10.9393ZM52 10.5L2 10.5V13.5L52 13.5V10.5Z",
              fill: "currentColor"
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_right_arrow cs_accent_color",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("svg", {
            width: 52,
            height: 24,
            viewBox: "0 0 52 24",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("path", {
              d: "M51.0607 13.0607C51.6464 12.4749 51.6464 11.5251 51.0607 10.9393L41.5147 1.3934C40.9289 0.807611 39.9792 0.807611 39.3934 1.3934C38.8076 1.97919 38.8076 2.92893 39.3934 3.51472L47.8787 12L39.3934 20.4853C38.8076 21.0711 38.8076 22.0208 39.3934 22.6066C39.9792 23.1924 40.9289 23.1924 41.5147 22.6066L51.0607 13.0607ZM0 13.5H50V10.5H0V13.5Z",
              fill: "currentColor"
            })
          })
        })]
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Blog/Blog3.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Blog/Blog3.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Blog3)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! moment */ "moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);






function Blog3(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    pagination_style = data.pagination_style;
  var blogs = localStorage.getItem("blogs") ? JSON.parse(localStorage.getItem("blogs")) : [];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "cs_section_heading cs_style_3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_section_heading_left",
          children: (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
            children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
              className: "cs_section_subtitle cs_fs_18 cs_medium",
              dangerouslySetInnerHTML: {
                __html: section_subtitle
              }
            }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_section_heading_right",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "cs_slider_arrows cs_style1",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "cs_left_arrow cs_accent_bg rounded-circle cs_center cs_white_color",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("svg", {
                width: 17,
                height: 12,
                viewBox: "0 0 17 12",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("path", {
                  d: "M0.469669 5.46967C0.176777 5.76256 0.176777 6.23744 0.469669 6.53033L5.24264 11.3033C5.53553 11.5962 6.01041 11.5962 6.3033 11.3033C6.59619 11.0104 6.59619 10.5355 6.3033 10.2426L2.06066 6L6.3033 1.75736C6.59619 1.46447 6.59619 0.989593 6.3033 0.696699C6.01041 0.403806 5.53553 0.403806 5.24264 0.696699L0.469669 5.46967ZM17 5.25L1 5.25V6.75L17 6.75V5.25Z",
                  fill: "currentColor"
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "cs_right_arrow cs_accent_bg rounded-circle cs_center cs_white_color",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("svg", {
                width: 17,
                height: 12,
                viewBox: "0 0 17 12",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("path", {
                  d: "M16.5303 6.53033C16.8232 6.23744 16.8232 5.76256 16.5303 5.46967L11.7574 0.696698C11.4645 0.403805 10.9896 0.403805 10.6967 0.696698C10.4038 0.989592 10.4038 1.46447 10.6967 1.75736L14.9393 6L10.6967 10.2426C10.4038 10.5355 10.4038 11.0104 10.6967 11.3033C10.9896 11.5962 11.4645 11.5962 11.7574 11.3033L16.5303 6.53033ZM6.55671e-08 6.75L16 6.75L16 5.25L-6.55671e-08 5.25L6.55671e-08 6.75Z",
                  fill: "currentColor"
                })
              })
            })]
          })
        })]
      }), (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "position-relative",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_auto_per_view_1 cs_full_screen_right",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
            slidesPerView: "auto",
            spaceBetween: 24,
            pagination: {
              clickable: true
            },
            speed: 800,
            loop: true,
            modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Navigation],
            navigation: {
              nextEl: ".cs_right_arrow",
              prevEl: ".cs_left_arrow",
              disabledClass: "swiper-button-disabled"
            },
            className: "mySwiper".concat(pagination_style === "pagination_0" ? " cs_swiper_pagination_wrap_0" : "").concat(pagination_style === "pagination_1" ? " cs_swiper_pagination_wrap_1" : "").concat(pagination_style === "pagination_2" ? " cs_swiper_pagination_wrap_2" : "").concat(pagination_style === "pagination_3" ? " cs_swiper_pagination_wrap_3" : ""),
            children: blogs === null || blogs === void 0 ? void 0 : blogs.map(function (item, index) {
              var _item$content, _item$category, _item$content2;
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "cs_post cs_style_1",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                    href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                    className: "cs_post_thumb",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
                      src: item === null || item === void 0 ? void 0 : item.thumbnail_image,
                      alt: item === null || item === void 0 || (_item$content = item.content) === null || _item$content === void 0 ? void 0 : _item$content.title
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                    className: "cs_post_info",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                      className: "cs_post_meta",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
                        className: "cs_medium cs_fs_18 cs_primary_color",
                        children: item === null || item === void 0 || (_item$category = item.category) === null || _item$category === void 0 || (_item$category = _item$category.content) === null || _item$category === void 0 ? void 0 : _item$category.title
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
                        children: moment__WEBPACK_IMPORTED_MODULE_4___default()(item === null || item === void 0 ? void 0 : item.created_at).format("ll")
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
                      className: "cs_post_title cs_fs_30 cs_normal mb-0",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                        children: item === null || item === void 0 || (_item$content2 = item.content) === null || _item$content2 === void 0 ? void 0 : _item$content2.title
                      })
                    })]
                  })]
                })
              }, index);
            })
          })
        })
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Blog/Blog4.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Blog/Blog4.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Blog4)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);






function Blog4(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    action_text = data.action_text,
    pagination_style = data.pagination_style;
  var blogs = localStorage.getItem("blogs") ? JSON.parse(localStorage.getItem("blogs")) : [];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        })
      }), (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "position-relative",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_auto_per_view_1 cs_full_screen_right",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
            slidesPerView: "auto",
            spaceBetween: 24,
            pagination: {
              clickable: true
            },
            speed: 800,
            loop: true,
            modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Navigation],
            navigation: {
              nextEl: ".cs_right_arrow",
              prevEl: ".cs_left_arrow",
              disabledClass: "swiper-button-disabled"
            },
            className: "mySwiper".concat(pagination_style === "pagination_0" ? " cs_swiper_pagination_wrap_0" : "").concat(pagination_style === "pagination_1" ? " cs_swiper_pagination_wrap_1" : "").concat(pagination_style === "pagination_2" ? " cs_swiper_pagination_wrap_2" : "").concat(pagination_style === "pagination_3" ? " cs_swiper_pagination_wrap_3" : ""),
            children: blogs === null || blogs === void 0 ? void 0 : blogs.map(function (item, index) {
              var _item$content, _item$content2, _item$content3;
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "cs_post cs_style_2",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                    href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                    className: "cs_post_thumb",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
                      src: item === null || item === void 0 ? void 0 : item.thumbnail_image,
                      alt: item === null || item === void 0 || (_item$content = item.content) === null || _item$content === void 0 ? void 0 : _item$content.title
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                    className: "cs_post_info",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
                      className: "cs_post_title cs_fs_30 cs_normal",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                        children: item === null || item === void 0 || (_item$content2 = item.content) === null || _item$content2 === void 0 ? void 0 : _item$content2.title
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
                      className: "cs_post_subtitle",
                      children: item === null || item === void 0 || (_item$content3 = item.content) === null || _item$content3 === void 0 ? void 0 : _item$content3.content.replace(/<[^>]*>/g, "").substring(0, 200)
                    }), action_text && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_4__["default"], {
                      href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                      btnText: action_text,
                      btnClass: "cs_btn cs_style_1 cs_type_4 cs_primary_color cs_fs_18 cs_medium"
                    })]
                  })]
                })
              }, index);
            })
          })
        })
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Blog/Blog5.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Blog/Blog5.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Blog5)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);






function Blog5(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    action_text = data.action_text,
    pagination_style = data.pagination_style;
  var blogs = localStorage.getItem("blogs") ? JSON.parse(localStorage.getItem("blogs")) : [];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "container",
      children: (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "cs_section_heading cs_style_1 text-center",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_height_85 cs_height_lg_50"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "container-fluid",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
        slidesPerView: 1,
        spaceBetween: 24,
        pagination: {
          clickable: true
        },
        speed: 800,
        loop: true,
        modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Navigation],
        navigation: {
          nextEl: ".cs_right_arrow",
          prevEl: ".cs_left_arrow",
          disabledClass: "swiper-button-disabled"
        },
        className: "mySwiper".concat(pagination_style === "pagination_0" ? " cs_swiper_pagination_wrap_0" : "").concat(pagination_style === "pagination_1" ? " cs_swiper_pagination_wrap_1" : "").concat(pagination_style === "pagination_2" ? " cs_swiper_pagination_wrap_2" : "").concat(pagination_style === "pagination_3" ? " cs_swiper_pagination_wrap_3" : ""),
        breakpoints: {
          767: {
            slidesPerView: 2,
            spaceBetween: 20
          },
          991: {
            slidesPerView: 3
          },
          1400: {
            slidesPerView: 4
          }
        },
        children: blogs === null || blogs === void 0 ? void 0 : blogs.map(function (item, index) {
          var _item$content, _item$content2, _item$content3;
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "cs_post cs_style_2",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                className: "cs_post_thumb",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
                  src: item === null || item === void 0 ? void 0 : item.thumbnail_image,
                  alt: item === null || item === void 0 || (_item$content = item.content) === null || _item$content === void 0 ? void 0 : _item$content.title
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                className: "cs_post_info",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
                  className: "cs_post_title cs_fs_30 cs_normal",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_3__["default"], {
                    href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                    children: item === null || item === void 0 || (_item$content2 = item.content) === null || _item$content2 === void 0 ? void 0 : _item$content2.title
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
                  className: "cs_post_subtitle",
                  children: item === null || item === void 0 || (_item$content3 = item.content) === null || _item$content3 === void 0 ? void 0 : _item$content3.content.replace(/<[^>]*>/g, "").substring(0, 200)
                }), action_text && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_4__["default"], {
                  href: route("blog.show", item === null || item === void 0 ? void 0 : item.slug),
                  btnText: action_text,
                  btnClass: "cs_btn cs_style_1 cs_type_4 cs_primary_color cs_fs_18 cs_medium"
                })]
              })]
            })
          }, index);
        })
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Button.jsx":
/*!*****************************************************!*\
  !*** ./resources/js/Frontend/Components/Button.jsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Button)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Button(_ref) {
  var _ref$href = _ref.href,
    href = _ref$href === void 0 ? "/" : _ref$href,
    btnText = _ref.btnText,
    btnClass = _ref.btnClass;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_1__["default"], {
    href: href,
    className: btnClass,
    children: [btnText, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
          width: 11,
          height: 11,
          viewBox: "0 0 11 11",
          fill: "none",
          xmlns: "http://www.w3.org/2000/svg",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
            d: "M1 10L10 1M10 1L1 1M10 1L10 10",
            stroke: "currentColor",
            strokeWidth: "1.5",
            strokeLinecap: "round",
            strokeLinejoin: "round"
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
          width: 11,
          height: 11,
          viewBox: "0 0 11 11",
          fill: "none",
          xmlns: "http://www.w3.org/2000/svg",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
            d: "M1 10L10 1M10 1L1 1M10 1L10 10",
            stroke: "currentColor",
            strokeWidth: "1.5",
            strokeLinecap: "round",
            strokeLinejoin: "round"
          })
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CaseStudy/CaseStudy1.jsx":
/*!*******************************************************************!*\
  !*** ./resources/js/Frontend/Components/CaseStudy/CaseStudy1.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CaseStudy1)
/* harmony export */ });
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var _VideoModal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../VideoModal */ "./resources/js/Frontend/Components/VideoModal/index.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





function CaseStudy1(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    casestudy_list = data.casestudy_list,
    section_btn_text = data.section_btn_text,
    section_btn_url = data.section_btn_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "container",
      children: [(section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "cs_height_85 cs_height_lg_50"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "cs_grid_style_1",
        children: casestudy_list === null || casestudy_list === void 0 ? void 0 : casestudy_list.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
            className: "cs_grid_item".concat([1, 2, 5, 6, 9, 10, 13, 14].includes(index) ? " cs_double" : ""),
            children: [item.link_type === "normal_link" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
              className: "cs_case_study cs_style_1",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__["default"], {
                href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
                className: "cs_case_study_thumb cs_bg_filed",
                style: {
                  backgroundImage: "url(".concat(item === null || item === void 0 ? void 0 : item.casestudy_image_url, ")")
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                className: "cs_case_study_info cs_white_color",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                  className: "cs_case_study_info_in",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h2", {
                    className: "cs_case_study_title cs_fs_30 cs_normal cs_white_color",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__["default"], {
                      href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
                      children: item === null || item === void 0 ? void 0 : item.casestudy_title
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__["default"], {
                    href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
                    btnText: item === null || item === void 0 ? void 0 : item.casestudy_btn_text,
                    btnClass: "cs_btn cs_style_1 cs_type_1"
                  })]
                })
              })]
            }), item.link_type === "youtube_link" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_VideoModal__WEBPACK_IMPORTED_MODULE_3__["default"], {
              videoSrc: item.youtube_video_url,
              imageUrl: item.casestudy_image_url
            })]
          }, index);
        })
      }), (section_btn_url || section_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "text-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "cs_height_100 cs_height_lg_50"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__["default"], {
          href: section_btn_url,
          btnText: section_btn_text,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm"
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CaseStudy/CaseStudy2.jsx":
/*!*******************************************************************!*\
  !*** ./resources/js/Frontend/Components/CaseStudy/CaseStudy2.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CaseStudy2)
/* harmony export */ });
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var _VideoModal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../VideoModal */ "./resources/js/Frontend/Components/VideoModal/index.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





function CaseStudy2(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    casestudy_list = data.casestudy_list,
    section_btn_text = data.section_btn_text,
    section_btn_url = data.section_btn_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "container",
      children: (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "cs_section_heading cs_style_1 text-center",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "cs_height_85 cs_height_lg_50"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_grid_style_2",
      children: casestudy_list === null || casestudy_list === void 0 ? void 0 : casestudy_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "cs_grid_item".concat([0, 6, 8, 12].includes(index) ? " cs_double_double" : "").concat([3, 7, 11, 15].includes(index) ? " cs_double" : ""),
          children: [item.link_type === "normal_link" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
            className: "cs_case_study cs_style_1",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__["default"], {
              href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
              className: "cs_case_study_thumb cs_bg_filed",
              style: {
                backgroundImage: "url(".concat(item === null || item === void 0 ? void 0 : item.casestudy_image_url, ")")
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "cs_case_study_info cs_white_color",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                className: "cs_case_study_info_in",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h2", {
                  className: "cs_case_study_title cs_fs_30 cs_normal cs_white_color",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__["default"], {
                    href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
                    children: item === null || item === void 0 ? void 0 : item.casestudy_title
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__["default"], {
                  href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
                  btnText: item === null || item === void 0 ? void 0 : item.casestudy_btn_text,
                  btnClass: "cs_btn cs_style_1 cs_type_1"
                })]
              })
            })]
          }), item.link_type === "youtube_link" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_VideoModal__WEBPACK_IMPORTED_MODULE_3__["default"], {
            videoSrc: item.youtube_video_url,
            imageUrl: item.casestudy_image_url
          })]
        }, index);
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "container",
      children: (section_btn_url || section_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "text-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "cs_height_100 cs_height_lg_50"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__["default"], {
          href: section_btn_url,
          btnText: section_btn_text,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm"
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CaseStudy/CaseStudy3.jsx":
/*!*******************************************************************!*\
  !*** ./resources/js/Frontend/Components/CaseStudy/CaseStudy3.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CaseStudy3)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _VideoModal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../VideoModal */ "./resources/js/Frontend/Components/VideoModal/index.jsx");
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);






function CaseStudy3(_ref) {
  var data = _ref.data;
  var marquee_text = data.marquee_text,
    section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    casestudy_list = data.casestudy_list,
    section_btn_text = data.section_btn_text,
    section_btn_url = data.section_btn_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [marquee_text && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "cs_moving_section_wrap",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "cs_moving_section_in cs_primary_font cs_primary_color cs_fs_120 cs_text_shadow_style",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: "cs_moving_section cs_moving_duration_40",
            dangerouslySetInnerHTML: {
              __html: marquee_text
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: "cs_moving_section cs_moving_duration_40",
            dangerouslySetInnerHTML: {
              __html: marquee_text
            }
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "container-fluid pr-0",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: " cs_grid_style_3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "cs_grid_item",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "cs_section_heading cs_style_1",
            children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
              className: "cs_section_subtitle cs_fs_18 cs_medium",
              dangerouslySetInnerHTML: {
                __html: section_subtitle
              }
            }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            }), (section_btn_url || section_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                className: "cs_height_45 cs_height_lg_30"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
                href: section_btn_url,
                btnText: section_btn_text,
                btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color"
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: "cs_height_85 cs_height_lg_50"
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_grid_item",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_2__.Swiper, {
            slidesPerView: 1,
            spaceBetween: 24,
            pagination: false,
            className: "mySwiper",
            breakpoints: {
              575: {
                slidesPerView: 2
              },
              1600: {
                slidesPerView: 3
              }
            },
            children: casestudy_list === null || casestudy_list === void 0 ? void 0 : casestudy_list.map(function (item, index) {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(swiper_react__WEBPACK_IMPORTED_MODULE_2__.SwiperSlide, {
                children: [item.link_type === "normal_link" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "cs_case_study cs_style_1",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_4__["default"], {
                    href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
                    className: "cs_case_study_thumb cs_bg_filed",
                    style: {
                      backgroundImage: "url(".concat(item === null || item === void 0 ? void 0 : item.casestudy_image_url, ")")
                    }
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                    className: "cs_case_study_info cs_white_color",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                      className: "cs_case_study_info_in",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
                        className: "cs_case_study_title cs_fs_30 cs_normal cs_white_color",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_4__["default"], {
                          href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
                          children: item === null || item === void 0 ? void 0 : item.casestudy_title
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
                        href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
                        btnText: item === null || item === void 0 ? void 0 : item.casestudy_btn_text,
                        btnClass: "cs_btn cs_style_1 cs_type_1"
                      })]
                    })
                  })]
                }), item.link_type === "youtube_link" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_VideoModal__WEBPACK_IMPORTED_MODULE_3__["default"], {
                  videoSrc: item.youtube_video_url,
                  imageUrl: item.casestudy_image_url
                })]
              }, index);
            })
          })
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CaseStudy/CaseStudy4.jsx":
/*!*******************************************************************!*\
  !*** ./resources/js/Frontend/Components/CaseStudy/CaseStudy4.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CaseStudy4)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function CaseStudy4(_ref) {
  var data = _ref.data;
  var casestudy_list = data.casestudy_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "position-relative",
    id: "all_casestudy",
    children: casestudy_list === null || casestudy_list === void 0 ? void 0 : casestudy_list.map(function (item, index) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_top_sticky_0",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "cs_hero cs_style_10 position-relative cs_center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "container",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
              className: "cs_section_heading cs_style_1",
              children: [item.casestudy_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
                className: "cs_section_subtitle cs_fs_18 cs_medium cs_ternary_color",
                dangerouslySetInnerHTML: {
                  __html: item.casestudy_subtitle
                }
              }), item.casestudy_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
                className: "cs_section_title cs_fs_60 cs_bold cs_white_color",
                dangerouslySetInnerHTML: {
                  __html: item.casestudy_title
                }
              }), ((item === null || item === void 0 ? void 0 : item.casestudy_btn_text) || (item === null || item === void 0 ? void 0 : item.casestudy_btn_url)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
                href: item === null || item === void 0 ? void 0 : item.casestudy_btn_url,
                btnText: item === null || item === void 0 ? void 0 : item.casestudy_btn_text,
                btnClass: "cs_btn cs_style_1 cs_type_4 cs_white_color cs_fs_18 cs_medium"
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_hero_thumb cs_bg_filed",
            style: {
              backgroundImage: "url(".concat(item.casestudy_image_url, ")")
            }
          })]
        })
      }, index);
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CaseStudyDetails/CaseStudyDetails1.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/CaseStudyDetails/CaseStudyDetails1.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CaseStudyDetails1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function CaseStudyDetails1(_ref) {
  var data = _ref.data;
  var title = data.title,
    category = data.category,
    banner_bg_url = data.banner_bg_url,
    image_url = data.image_url,
    text_editor_content = data.text_editor_content;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [(category || title || banner_bg_url) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_page_heading cs_style_1 cs_bg_filed cs_primary_bg",
        style: {
          backgroundImage: "url(".concat(banner_bg_url, ")")
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
            className: "cs_section_heading cs_style_1",
            children: [category && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
              className: "cs_section_subtitle cs_fs_18 cs_medium cs_white_color",
              dangerouslySetInnerHTML: {
                __html: category
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h1", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0 cs_white_color",
              dangerouslySetInnerHTML: {
                __html: title
              }
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_height_100 cs_height_lg_60"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "row position-relative cs_gap_y_50",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "col-lg-5",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
            className: "cs_top_sticky_100",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
              className: "cs_case_study_details_thumb cs_radius_50_0_0_0",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                src: image_url,
                alt: "Casestudy"
              })
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "col-lg-7",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
            className: "cs_casestudy_details",
            dangerouslySetInnerHTML: {
              __html: text_editor_content
            }
          })
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CaseStudyDetails/CaseStudyDetails2.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/CaseStudyDetails/CaseStudyDetails2.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CaseStudyDetails2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_youtube_background__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-youtube-background */ "react-youtube-background");
/* harmony import */ var react_youtube_background__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_youtube_background__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





function CaseStudyDetails2(_ref) {
  var data = _ref.data;
  var image_url = data.image_url,
    avatar_name = data.avatar_name,
    category = data.category,
    post_date = data.post_date,
    text_editor_content = data.text_editor_content,
    banner_type = data.banner_type,
    gallery_list = data.gallery_list,
    youtube_id = data.youtube_id,
    title = data.title;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "container",
    children: [banner_type === "static" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
      children: image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
        src: image_url,
        alt: "Casestudy",
        className: "cs_radius_50_0_0_0",
        style: {
          marginBottom: "30px"
        }
      })
    }), banner_type === "slider" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_radius_50_0_0_0 overflow-hidden cs_case_study_slider",
      style: {
        marginBottom: "30px"
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
        navigation: true,
        modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Navigation],
        className: "mySwiper",
        loop: true,
        speed: 800,
        children: gallery_list === null || gallery_list === void 0 ? void 0 : gallery_list.map(function (galleryItem, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
              src: galleryItem.gallery_image_url,
              alt: "Casestudy"
            })
          }, index);
        })
      })
    }), banner_type === "video" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_case_study_video cs_radius_50_0_0_0",
      style: {
        marginBottom: "30px"
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)((react_youtube_background__WEBPACK_IMPORTED_MODULE_3___default()), {
        videoId: youtube_id,
        className: "cs_video_bg"
      })
    }), (category || post_date || avatar_name) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_post cs_style_1",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        "class": "cs_post_info",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          "class": "cs_post_meta",
          children: [category && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
            "class": "cs_medium cs_fs_18 cs_primary_color",
            children: category
          }), post_date && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
            children: post_date
          }), avatar_name && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
            children: avatar_name
          })]
        })
      })
    }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h1", {
      "class": "cs_post_title cs_fs_60 cs_normal",
      style: {
        marginBottom: "30px"
      },
      dangerouslySetInnerHTML: {
        __html: title
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_casestudy_details",
      style: {
        paddingLeft: "0"
      },
      dangerouslySetInnerHTML: {
        __html: text_editor_content
      }
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Category/Category1.jsx":
/*!*****************************************************************!*\
  !*** ./resources/js/Frontend/Components/Category/Category1.jsx ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Category1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function Category1(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    category_list = data.category_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "container",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "cs_section_heading cs_style_1",
      children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
        className: "cs_section_subtitle cs_fs_18 cs_medium",
        dangerouslySetInnerHTML: {
          __html: section_subtitle
        }
      }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h2", {
        className: "cs_section_title cs_fs_53 cs_normal mb-0",
        dangerouslySetInnerHTML: {
          __html: section_title
        }
      })]
    }), (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "cs_height_85 cs_height_lg_50"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "cs_category_1_wrap",
      children: category_list === null || category_list === void 0 ? void 0 : category_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "cs_category_item",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "cs_category_1",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
              src: item.category_image_url,
              alt: "",
              className: "cs_category_thumb"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "cs_category_info",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h3", {
                className: "cs_category_title cs_fs_30 cs_white_color cs_normal",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
                  href: item.category_btn_url,
                  children: item.category_title
                })
              }), (item.category_btn_url || item.category_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
                href: item.category_btn_url,
                btnText: item.category_btn_text,
                btnClass: "cs_btn cs_style_1 cs_type_1 cs_white_color"
              })]
            })]
          })
        }, index);
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/ContactWithFormBuilder/ContactWithFormBuilder1.jsx":
/*!*********************************************************************************************!*\
  !*** ./resources/js/Frontend/Components/ContactWithFormBuilder/ContactWithFormBuilder1.jsx ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContactWithFormBuilder1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-google-recaptcha */ "react-google-recaptcha");
/* harmony import */ var react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }





function ContactWithFormBuilder1(_ref) {
  var _sections_data$contac, _sections_data$forms;
  var sections_data = _ref.sections_data;
  var captchaSiteKey = localStorage.getItem("google_captcha_site_key") ? JSON.parse(localStorage.getItem("google_captcha_site_key")) : [];
  var is_active_google_captcha = localStorage.getItem("is_active_google_captcha") ? JSON.parse(localStorage.getItem("is_active_google_captcha")) : [];
  var flash = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.flash;
  var formRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var _useForm = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.useForm)({}),
    data = _useForm.data,
    setData = _useForm.setData,
    errors = _useForm.errors,
    post = _useForm.post,
    wasSuccessful = _useForm.wasSuccessful,
    reset = _useForm.reset,
    processing = _useForm.processing;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    captchaVerified = _useState2[0],
    setCaptchaVerified = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
    _useState4 = _slicedToArray(_useState3, 2),
    captchaError = _useState4[0],
    setCaptchaError = _useState4[1];
  var handleCaptchaChange = function handleCaptchaChange(value) {
    if (is_active_google_captcha === "1") {
      if (value) {
        setData("captchaToken", value);
        setCaptchaVerified(true);
        setCaptchaError(null);
      } else {
        setCaptchaVerified(false);
      }
    }
  };
  var handleSetData = function handleSetData(e, label, placeholder) {
    var fieldType = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "text";
    var fieldName;
    if (label) {
      fieldName = label.toLowerCase().replace(/\s+/g, "_");
    } else if (placeholder) {
      fieldName = placeholder.toLowerCase().replace(/\s+/g, "_");
    } else {
      fieldName = "field_".concat(Object.keys(data).length + 1);
    }

    // Special handling for checkboxes
    if (fieldType === "checkbox") {
      var checkboxValue = e.target.value;
      var isChecked = e.target.checked;
      if (!data[fieldName]) {
        setData(fieldName, []);
      }
      if (isChecked) {
        setData(fieldName, [].concat(_toConsumableArray(Array.isArray(data[fieldName]) ? data[fieldName] : []), [checkboxValue]));
      } else {
        setData(fieldName, Array.isArray(data[fieldName]) ? data[fieldName].filter(function (val) {
          return val !== checkboxValue;
        }) : []);
      }
    } else {
      setData(fieldName, e.target.value);
    }
  };
  var handleSubmit = function handleSubmit(e) {
    e.preventDefault();
    if (!captchaVerified && is_active_google_captcha === "1") {
      setCaptchaError(translate("Please complete the captcha verification"));
      return;
    }
    post(route("form.submit"), {
      preserveScroll: true,
      onSuccess: function onSuccess() {
        reset();
        formRef.current.reset();
      }
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    setData(function (prevData) {
      return _objectSpread(_objectSpread({}, prevData), {}, {
        response_from: sections_data === null || sections_data === void 0 ? void 0 : sections_data.response_form,
        form_name: sections_data === null || sections_data === void 0 ? void 0 : sections_data.form_name
      });
    });
  }, [sections_data]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "row cs_gap_y_40",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "col-xl-5 col-lg-6",
          children: [(sections_data.section_subtitle || sections_data.section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "cs_section_heading cs_style_1",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
                className: "cs_section_subtitle cs_fs_18 cs_medium",
                dangerouslySetInnerHTML: {
                  __html: sections_data.section_subtitle
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h2", {
                className: "cs_section_title cs_fs_53 cs_normal mb-0",
                dangerouslySetInnerHTML: {
                  __html: sections_data.section_title
                }
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "cs_height_57 cs_height_lg_40"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("ul", {
            className: "cs_mp0 cs_contact_info",
            children: (_sections_data$contac = sections_data.contact_list) === null || _sections_data$contac === void 0 ? void 0 : _sections_data$contac.map(function (item, index) {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("li", {
                children: [item.contact_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
                  dangerouslySetInnerHTML: {
                    __html: item.contact_title
                  }
                }), item.contact_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h3", {
                  className: "cs_fs_24 cs_normal",
                  dangerouslySetInnerHTML: {
                    __html: item.contact_description
                  }
                }), item.contact_info && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
                  dangerouslySetInnerHTML: {
                    __html: item.contact_info
                  }
                })]
              }, index);
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "col-lg-6 offset-xl-1",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("form", {
            ref: formRef,
            className: "row",
            onSubmit: handleSubmit,
            children: [sections_data === null || sections_data === void 0 || (_sections_data$forms = sections_data.forms) === null || _sections_data$forms === void 0 ? void 0 : _sections_data$forms.map(function (form, index) {
              var _form$column, _form$column2, _form$radio_options, _form$column3, _form$checkbox_option, _form$column4, _form$select_options, _form$column5;
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), {
                children: form.fieldType === "multilineText" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column = form.column) !== null && _form$column !== void 0 ? _form$column : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("textarea", {
                      cols: "30",
                      rows: "7",
                      className: "cs_form_field",
                      defaultValue: form.default_value,
                      required: form.isRequired,
                      onChange: function onChange(e) {
                        return handleSetData(e, form.label, form.placeholder);
                      },
                      placeholder: "".concat(form.placeholder ? form.placeholder : "").concat(form.label ? "" : form.isRequired ? " *" : "")
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_22 cs_height_lg_22"
                    })]
                  })
                }) : form.fieldType === "radio" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column2 = form.column) !== null && _form$column2 !== void 0 ? _form$column2 : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_radio_group",
                      children: form === null || form === void 0 || (_form$radio_options = form.radio_options) === null || _form$radio_options === void 0 ? void 0 : _form$radio_options.map(function (option, optionIndex) {
                        var _form$label;
                        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                          className: "cs_radio_wrapper",
                          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
                            type: "radio",
                            id: "radio-".concat(index, "-").concat(optionIndex),
                            name: ((_form$label = form.label) === null || _form$label === void 0 ? void 0 : _form$label.toLowerCase().replace(/\s+/g, "_")) || "radio_group_".concat(index),
                            value: option,
                            required: form.isRequired,
                            defaultChecked: form.default_value === option,
                            onChange: function onChange(e) {
                              return handleSetData(e, form.label, form.placeholder);
                            }
                          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("label", {
                            style: {
                              marginLeft: "8px"
                            },
                            htmlFor: "radio-".concat(index, "-").concat(optionIndex),
                            children: option
                          })]
                        }, "radio-".concat(index, "-").concat(optionIndex));
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_22 cs_height_lg_22"
                    })]
                  })
                }) : form.fieldType === "checkbox" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column3 = form.column) !== null && _form$column3 !== void 0 ? _form$column3 : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_checkbox_group",
                      children: form === null || form === void 0 || (_form$checkbox_option = form.checkbox_options) === null || _form$checkbox_option === void 0 ? void 0 : _form$checkbox_option.map(function (option, optionIndex) {
                        var _form$label2;
                        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                          className: "cs_checkbox_wrapper",
                          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
                            type: "checkbox",
                            id: "checkbox-".concat(index, "-").concat(optionIndex),
                            name: ((_form$label2 = form.label) === null || _form$label2 === void 0 ? void 0 : _form$label2.toLowerCase().replace(/\s+/g, "_")) || "checkbox_group_".concat(index),
                            value: option,
                            required: form.isRequired && optionIndex === 0,
                            defaultChecked: form.default_value === option,
                            onChange: function onChange(e) {
                              return handleSetData(e, form.label, form.placeholder, "checkbox");
                            }
                          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("label", {
                            style: {
                              marginLeft: "8px"
                            },
                            htmlFor: "checkbox-".concat(index, "-").concat(optionIndex),
                            children: option
                          })]
                        }, "checkbox-".concat(index, "-").concat(optionIndex));
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_22 cs_height_lg_22"
                    })]
                  })
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: form.fieldType === "select" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column4 = form.column) !== null && _form$column4 !== void 0 ? _form$column4 : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      htmlFor: "",
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("select", {
                      className: "cs_form_field",
                      required: form.isRequired,
                      onChange: function onChange(e) {
                        return handleSetData(e, form.label, form.placeholder);
                      },
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("option", {
                        value: "",
                        children: "Select an option"
                      }), form === null || form === void 0 || (_form$select_options = form.select_options) === null || _form$select_options === void 0 ? void 0 : _form$select_options.map(function (option, index) {
                        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("option", {
                          value: option,
                          children: option
                        }, "options-".concat(index));
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_22 cs_height_lg_22"
                    })]
                  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column5 = form.column) !== null && _form$column5 !== void 0 ? _form$column5 : "6"),
                    children: [form.fieldType !== "hidden" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                      children: form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                        children: [form.label, " ", form.isRequired && "*"]
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
                      type: form.fieldType,
                      defaultValue: form.default_value,
                      className: "cs_form_field",
                      required: form.isRequired,
                      onChange: function onChange(e) {
                        return handleSetData(e, form.label, form.placeholder);
                      },
                      placeholder: "".concat(form.placeholder ? form.placeholder : "").concat(form.label ? "" : form.isRequired ? " *" : "")
                    }), form.fieldType !== "hidden" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_22 cs_height_lg_22"
                    })]
                  })
                })
              }, index);
            }), is_active_google_captcha === "1" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "cs_mb_15",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)((react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2___default()), {
                sitekey: captchaSiteKey,
                onChange: handleCaptchaChange
              }), captchaError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "text-danger mb-3",
                children: captchaError
              })]
            }), (sections_data === null || sections_data === void 0 ? void 0 : sections_data.submit_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "col-lg-12",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "cs_height_5 cs_height_lg_5"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("button", {
                disabled: !captchaVerified && processing,
                className: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm",
                children: [sections_data === null || sections_data === void 0 ? void 0 : sections_data.submit_btn_text, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
                      width: 11,
                      height: 11,
                      viewBox: "0 0 11 11",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
                        d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                        stroke: "currentColor",
                        strokeWidth: "1.5",
                        strokeLinecap: "round",
                        strokeLinejoin: "round"
                      })
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
                      width: 11,
                      height: 11,
                      viewBox: "0 0 11 11",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
                        d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                        stroke: "currentColor",
                        strokeWidth: "1.5",
                        strokeLinecap: "round",
                        strokeLinejoin: "round"
                      })
                    })
                  })]
                })]
              })]
            }), wasSuccessful && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "text-success mt-2",
              children: flash.success
            })]
          })
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/ContactWithFormBuilder/ContactWithFormBuilder2.jsx":
/*!*********************************************************************************************!*\
  !*** ./resources/js/Frontend/Components/ContactWithFormBuilder/ContactWithFormBuilder2.jsx ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContactWithFormBuilder2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-google-recaptcha */ "react-google-recaptcha");
/* harmony import */ var react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }





function ContactWithFormBuilder2(_ref) {
  var _sections_data$contac, _sections_data$forms;
  var sections_data = _ref.sections_data;
  var captchaSiteKey = localStorage.getItem("google_captcha_site_key") ? JSON.parse(localStorage.getItem("google_captcha_site_key")) : [];
  var is_active_google_captcha = localStorage.getItem("is_active_google_captcha") ? JSON.parse(localStorage.getItem("is_active_google_captcha")) : [];
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    captchaVerified = _useState2[0],
    setCaptchaVerified = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
    _useState4 = _slicedToArray(_useState3, 2),
    captchaError = _useState4[0],
    setCaptchaError = _useState4[1];
  var flash = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.flash;
  var formRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var _useForm = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.useForm)({}),
    data = _useForm.data,
    setData = _useForm.setData,
    post = _useForm.post,
    wasSuccessful = _useForm.wasSuccessful,
    reset = _useForm.reset,
    processing = _useForm.processing;
  var handleSetData = function handleSetData(e, label, placeholder) {
    var fieldName;
    if (label) {
      fieldName = label.toLowerCase().replace(/\s+/g, "_");
    } else if (placeholder) {
      fieldName = placeholder.toLowerCase().replace(/\s+/g, "_");
    } else {
      fieldName = "field_".concat(Object.keys(data).length + 1);
    }
    setData(fieldName, e.target.value);
  };
  var handleCaptchaChange = function handleCaptchaChange(value) {
    if (is_active_google_captcha === "1") {
      if (value) {
        setData("captchaToken", value);
        setCaptchaVerified(true);
        setCaptchaError(null);
      } else {
        setCaptchaVerified(false);
      }
    }
  };
  var handleSubmit = function handleSubmit(e) {
    e.preventDefault();
    if (!captchaVerified && is_active_google_captcha === "1") {
      setCaptchaError(translate("Please complete the captcha verification"));
      return;
    }
    post(route("form.submit"), {
      preserveScroll: true,
      onSuccess: function onSuccess() {
        reset();
        formRef.current.reset();
      }
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    setData(function (prevData) {
      return _objectSpread(_objectSpread({}, prevData), {}, {
        response_from: sections_data === null || sections_data === void 0 ? void 0 : sections_data.response_form,
        form_name: sections_data === null || sections_data === void 0 ? void 0 : sections_data.form_name
      });
    });
  }, [sections_data]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "row cs_gap_y_40",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "col-lg-5",
          children: [sections_data.google_map_iframe && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "cs_google_map_2",
              dangerouslySetInnerHTML: {
                __html: sections_data.google_map_iframe
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "cs_height_45 cs_height_lg_30"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("ul", {
            className: "cs_mp0 cs_contact_info",
            children: (_sections_data$contac = sections_data.contact_list) === null || _sections_data$contac === void 0 ? void 0 : _sections_data$contac.map(function (item, index) {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("li", {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h3", {
                  className: "cs_fs_24 cs_normal",
                  dangerouslySetInnerHTML: {
                    __html: item.contact_title
                  }
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
                  dangerouslySetInnerHTML: {
                    __html: item.contact_info
                  }
                })]
              }, index);
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "col-lg-6 offset-lg-1",
          children: [(sections_data.section_subtitle || sections_data.section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "cs_section_heading cs_style_1",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
                className: "cs_section_subtitle cs_fs_18 cs_medium",
                dangerouslySetInnerHTML: {
                  __html: sections_data.section_subtitle
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h2", {
                className: "cs_section_title cs_fs_53 cs_normal mb-0",
                dangerouslySetInnerHTML: {
                  __html: sections_data.section_title
                }
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "cs_height_50 cs_height_lg_40"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("form", {
            ref: formRef,
            className: "row",
            onSubmit: handleSubmit,
            children: [sections_data === null || sections_data === void 0 || (_sections_data$forms = sections_data.forms) === null || _sections_data$forms === void 0 ? void 0 : _sections_data$forms.map(function (form, index) {
              var _form$column, _form$column2, _form$radio_options, _form$column3, _form$checkbox_option, _form$column4, _form$select_options, _form$column5;
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), {
                children: form.fieldType === "multilineText" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column = form.column) !== null && _form$column !== void 0 ? _form$column : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      children: [form.label, " ", form.label && form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("textarea", {
                      cols: "30",
                      rows: "7",
                      className: "cs_form_field_2",
                      defaultValue: form.default_value,
                      required: form.isRequired,
                      onChange: function onChange(e) {
                        return handleSetData(e, form.label, form.placeholder);
                      },
                      placeholder: "".concat(form.placeholder ? form.placeholder : "").concat(form.label ? "" : form.isRequired ? " *" : "")
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_35 cs_height_lg_22"
                    })]
                  })
                }) : form.fieldType === "radio" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column2 = form.column) !== null && _form$column2 !== void 0 ? _form$column2 : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_radio_group",
                      children: form === null || form === void 0 || (_form$radio_options = form.radio_options) === null || _form$radio_options === void 0 ? void 0 : _form$radio_options.map(function (option, optionIndex) {
                        var _form$label;
                        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                          className: "cs_radio_wrapper",
                          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
                            type: "radio",
                            id: "radio-".concat(index, "-").concat(optionIndex),
                            name: ((_form$label = form.label) === null || _form$label === void 0 ? void 0 : _form$label.toLowerCase().replace(/\s+/g, "_")) || "radio_group_".concat(index),
                            value: option,
                            required: form.isRequired,
                            defaultChecked: form.default_value === option,
                            onChange: function onChange(e) {
                              return handleSetData(e, form.label, form.placeholder);
                            }
                          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("label", {
                            style: {
                              marginLeft: "8px"
                            },
                            htmlFor: "radio-".concat(index, "-").concat(optionIndex),
                            children: option
                          })]
                        }, "radio-".concat(index, "-").concat(optionIndex));
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_22 cs_height_lg_22"
                    })]
                  })
                }) : form.fieldType === "checkbox" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column3 = form.column) !== null && _form$column3 !== void 0 ? _form$column3 : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_checkbox_group",
                      children: form === null || form === void 0 || (_form$checkbox_option = form.checkbox_options) === null || _form$checkbox_option === void 0 ? void 0 : _form$checkbox_option.map(function (option, optionIndex) {
                        var _form$label2;
                        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                          className: "cs_checkbox_wrapper",
                          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
                            type: "checkbox",
                            id: "checkbox-".concat(index, "-").concat(optionIndex),
                            name: ((_form$label2 = form.label) === null || _form$label2 === void 0 ? void 0 : _form$label2.toLowerCase().replace(/\s+/g, "_")) || "checkbox_group_".concat(index),
                            value: option,
                            required: form.isRequired,
                            defaultChecked: form.default_value === option,
                            onChange: function onChange(e) {
                              return handleSetData(e, form.label, form.placeholder);
                            }
                          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("label", {
                            style: {
                              marginLeft: "8px"
                            },
                            htmlFor: "checkbox-".concat(index, "-").concat(optionIndex),
                            children: option
                          })]
                        }, "checkbox-".concat(index, "-").concat(optionIndex));
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_22 cs_height_lg_22"
                    })]
                  })
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: form.fieldType === "select" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column4 = form.column) !== null && _form$column4 !== void 0 ? _form$column4 : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      htmlFor: "",
                      children: [form.label, " ", form.label && form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("select", {
                      className: "cs_form_field_2",
                      required: form.isRequired,
                      onChange: function onChange(e) {
                        return handleSetData(e, form.label, form.placeholder);
                      },
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("option", {
                        value: "",
                        children: "Select an option"
                      }), form === null || form === void 0 || (_form$select_options = form.select_options) === null || _form$select_options === void 0 ? void 0 : _form$select_options.map(function (option, index) {
                        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("option", {
                          value: option,
                          children: option
                        }, "options-".concat(index));
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_35 cs_height_lg_22"
                    })]
                  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column5 = form.column) !== null && _form$column5 !== void 0 ? _form$column5 : "6"),
                    children: [form.fieldType !== "hidden" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                      children: form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                        children: [form.label, " ", form.label && form.isRequired && "*"]
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
                      type: form.fieldType,
                      defaultValue: form.default_value,
                      className: "cs_form_field_2",
                      required: form.isRequired,
                      onChange: function onChange(e) {
                        return handleSetData(e, form.label, form.placeholder);
                      },
                      placeholder: "".concat(form.placeholder ? form.placeholder : "").concat(form.label ? "" : form.isRequired ? " *" : "")
                    }), form.fieldType !== "hidden" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_35 cs_height_lg_22"
                    })]
                  })
                })
              }, index);
            }), is_active_google_captcha === "1" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "cs_mb_15",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)((react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2___default()), {
                sitekey: captchaSiteKey,
                onChange: handleCaptchaChange
              }), captchaError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "text-danger mb-3",
                children: captchaError
              })]
            }), (sections_data === null || sections_data === void 0 ? void 0 : sections_data.submit_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "col-lg-12",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "cs_height_5 cs_height_lg_5"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("button", {
                disabled: !captchaVerified && processing,
                className: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm",
                children: [sections_data === null || sections_data === void 0 ? void 0 : sections_data.submit_btn_text, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
                      width: 11,
                      height: 11,
                      viewBox: "0 0 11 11",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
                        d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                        stroke: "currentColor",
                        strokeWidth: "1.5",
                        strokeLinecap: "round",
                        strokeLinejoin: "round"
                      })
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
                      width: 11,
                      height: 11,
                      viewBox: "0 0 11 11",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
                        d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                        stroke: "currentColor",
                        strokeWidth: "1.5",
                        strokeLinecap: "round",
                        strokeLinejoin: "round"
                      })
                    })
                  })]
                })]
              })]
            }), wasSuccessful && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "text-success mt-2",
              children: flash.success
            })]
          })]
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/ContactWithFormBuilder/ContactWithFormBuilder3.jsx":
/*!*********************************************************************************************!*\
  !*** ./resources/js/Frontend/Components/ContactWithFormBuilder/ContactWithFormBuilder3.jsx ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContactWithFormBuilder3)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Widget/SocialWidget */ "./resources/js/Frontend/Components/Widget/SocialWidget.jsx");
/* harmony import */ var react_google_recaptcha__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-google-recaptcha */ "react-google-recaptcha");
/* harmony import */ var react_google_recaptcha__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_google_recaptcha__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }






function ContactWithFormBuilder3(_ref) {
  var _sections_data$contac, _sections_data$forms;
  var sections_data = _ref.sections_data;
  var captchaSiteKey = localStorage.getItem("google_captcha_site_key") ? JSON.parse(localStorage.getItem("google_captcha_site_key")) : [];
  var is_active_google_captcha = localStorage.getItem("is_active_google_captcha") ? JSON.parse(localStorage.getItem("is_active_google_captcha")) : [];
  var flash = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.flash;
  var formRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var _useForm = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.useForm)({}),
    data = _useForm.data,
    setData = _useForm.setData,
    errors = _useForm.errors,
    post = _useForm.post,
    wasSuccessful = _useForm.wasSuccessful,
    reset = _useForm.reset,
    processing = _useForm.processing;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    captchaVerified = _useState2[0],
    setCaptchaVerified = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
    _useState4 = _slicedToArray(_useState3, 2),
    captchaError = _useState4[0],
    setCaptchaError = _useState4[1];
  var handleCaptchaChange = function handleCaptchaChange(value) {
    if (is_active_google_captcha === "1") {
      if (value) {
        setData("captchaToken", value);
        setCaptchaVerified(true);
        setCaptchaError(null);
      } else {
        setCaptchaVerified(false);
      }
    }
  };
  var handleSetData = function handleSetData(e, label, placeholder) {
    var fieldName;
    if (label) {
      fieldName = label.toLowerCase().replace(/\s+/g, "_");
    } else if (placeholder) {
      fieldName = placeholder.toLowerCase().replace(/\s+/g, "_");
    } else {
      fieldName = "field_".concat(Object.keys(data).length + 1);
    }
    setData(fieldName, e.target.value);
  };
  var handleSubmit = function handleSubmit(e) {
    e.preventDefault();
    if (!captchaVerified && is_active_google_captcha === "1") {
      setCaptchaError(translate("Please complete the captcha verification"));
      return;
    }
    post(route("form.submit"), {
      preserveScroll: true,
      onSuccess: function onSuccess() {
        reset();
        formRef.current.reset();
      }
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    setData(function (prevData) {
      return _objectSpread(_objectSpread({}, prevData), {}, {
        response_from: sections_data === null || sections_data === void 0 ? void 0 : sections_data.response_form,
        form_name: sections_data === null || sections_data === void 0 ? void 0 : sections_data.form_name
      });
    });
  }, [sections_data]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "row cs_gap_y_60",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "col-lg-5",
          children: [(sections_data.section_subtitle || sections_data.section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
            children: [sections_data.section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
                className: "cs_section_subtitle mb-0",
                dangerouslySetInnerHTML: {
                  __html: sections_data.section_subtitle
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                className: "cs_height_15 cs_height_lg_15"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h2", {
              className: "cs_section_title cs_fs_30 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: sections_data.section_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "cs_height_45 cs_height_lg_40"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("ul", {
            className: "cs_mp0 cs_contact_info",
            children: [(_sections_data$contac = sections_data.contact_list) === null || _sections_data$contac === void 0 ? void 0 : _sections_data$contac.map(function (item, index) {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("li", {
                children: [item.contact_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
                  dangerouslySetInnerHTML: {
                    __html: item.contact_title
                  }
                }), item.contact_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h3", {
                  className: "cs_fs_24 cs_normal",
                  dangerouslySetInnerHTML: {
                    __html: item.contact_description
                  }
                }), item.contact_info && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
                  dangerouslySetInnerHTML: {
                    __html: item.contact_info
                  }
                })]
              }, index);
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "cs_height_45 cs_height_lg_40"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("li", {
              children: sections_data.social_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h3", {
                  className: "cs_fs_24 cs_normal",
                  children: sections_data.social_title
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_2__["default"], {})]
              })
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "col-xl-6 offset-xl-1 col-lg-7",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
            className: "cs_contact_form_wrap cs_gray_bg_2",
            children: [sections_data.section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h3", {
                className: "cs_fs_30 cs_normal text-center mb-0",
                dangerouslySetInnerHTML: {
                  __html: sections_data.section_description
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                className: "cs_height_40 cs_height_lg_30"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("form", {
              ref: formRef,
              className: "row",
              onSubmit: handleSubmit,
              children: [sections_data === null || sections_data === void 0 || (_sections_data$forms = sections_data.forms) === null || _sections_data$forms === void 0 ? void 0 : _sections_data$forms.map(function (form, index) {
                var _form$column, _form$column2, _form$radio_options, _form$column3, _form$checkbox_option, _form$column4, _form$select_options, _form$column5;
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), {
                  children: form.fieldType === "multilineText" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                      className: "col-lg-".concat((_form$column = form.column) !== null && _form$column !== void 0 ? _form$column : "6"),
                      children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("label", {
                        className: "cs_primary_color cs_fs_18 cs_medium",
                        children: [form.label, " ", form.isRequired && "*"]
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("textarea", {
                        cols: "30",
                        rows: "5",
                        className: "cs_form_field_3",
                        defaultValue: form.default_value,
                        required: form.isRequired,
                        onChange: function onChange(e) {
                          return handleSetData(e, form.label, form.placeholder);
                        },
                        placeholder: "".concat(form.placeholder ? form.placeholder : "").concat(form.label ? "" : form.isRequired ? " *" : "")
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                        className: "cs_height_40 cs_height_lg_20"
                      })]
                    })
                  }) : form.fieldType === "radio" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                      className: "col-lg-".concat((_form$column2 = form.column) !== null && _form$column2 !== void 0 ? _form$column2 : "6"),
                      children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("label", {
                        children: [form.label, " ", form.isRequired && "*"]
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                        className: "cs_radio_group",
                        children: form === null || form === void 0 || (_form$radio_options = form.radio_options) === null || _form$radio_options === void 0 ? void 0 : _form$radio_options.map(function (option, optionIndex) {
                          var _form$label;
                          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                            className: "cs_radio_wrapper",
                            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("input", {
                              type: "radio",
                              id: "radio-".concat(index, "-").concat(optionIndex),
                              name: ((_form$label = form.label) === null || _form$label === void 0 ? void 0 : _form$label.toLowerCase().replace(/\s+/g, "_")) || "radio_group_".concat(index),
                              value: option,
                              required: form.isRequired,
                              defaultChecked: form.default_value === option,
                              onChange: function onChange(e) {
                                return handleSetData(e, form.label, form.placeholder);
                              }
                            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("label", {
                              style: {
                                marginLeft: "8px"
                              },
                              htmlFor: "radio-".concat(index, "-").concat(optionIndex),
                              children: option
                            })]
                          }, "radio-".concat(index, "-").concat(optionIndex));
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                        className: "cs_height_22 cs_height_lg_22"
                      })]
                    })
                  }) : form.fieldType === "checkbox" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                      className: "col-lg-".concat((_form$column3 = form.column) !== null && _form$column3 !== void 0 ? _form$column3 : "6"),
                      children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("label", {
                        children: [form.label, " ", form.isRequired && "*"]
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                        className: "cs_checkbox_group",
                        children: form === null || form === void 0 || (_form$checkbox_option = form.checkbox_options) === null || _form$checkbox_option === void 0 ? void 0 : _form$checkbox_option.map(function (option, optionIndex) {
                          var _form$label2;
                          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                            className: "cs_checkbox_wrapper",
                            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("input", {
                              type: "checkbox",
                              id: "checkbox-".concat(index, "-").concat(optionIndex),
                              name: ((_form$label2 = form.label) === null || _form$label2 === void 0 ? void 0 : _form$label2.toLowerCase().replace(/\s+/g, "_")) || "checkbox_group_".concat(index),
                              value: option,
                              required: form.isRequired,
                              defaultChecked: form.default_value === option,
                              onChange: function onChange(e) {
                                return handleSetData(e, form.label, form.placeholder);
                              }
                            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("label", {
                              style: {
                                marginLeft: "8px"
                              },
                              htmlFor: "checkbox-".concat(index, "-").concat(optionIndex),
                              children: option
                            })]
                          }, "checkbox-".concat(index, "-").concat(optionIndex));
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                        className: "cs_height_22 cs_height_lg_22"
                      })]
                    })
                  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                    children: form.fieldType === "select" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                      className: "col-lg-".concat((_form$column4 = form.column) !== null && _form$column4 !== void 0 ? _form$column4 : "6"),
                      children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("label", {
                        className: "cs_primary_color cs_fs_18 cs_medium",
                        children: [form.label, " ", form.isRequired && "*"]
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("select", {
                        className: "cs_form_field_3",
                        required: form.isRequired,
                        onChange: function onChange(e) {
                          return handleSetData(e, form.label, form.placeholder);
                        },
                        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("option", {
                          value: "",
                          children: "Select an option"
                        }), form === null || form === void 0 || (_form$select_options = form.select_options) === null || _form$select_options === void 0 ? void 0 : _form$select_options.map(function (option, index) {
                          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("option", {
                            value: option,
                            children: option
                          }, "options-".concat(index));
                        })]
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                        className: "cs_height_40 cs_height_lg_20"
                      })]
                    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                      className: "col-lg-".concat((_form$column5 = form.column) !== null && _form$column5 !== void 0 ? _form$column5 : "6"),
                      children: [form.fieldType !== "hidden" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                        children: form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("label", {
                          className: "cs_primary_color cs_fs_18 cs_medium",
                          children: [form.label, " ", form.isRequired && "*"]
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("input", {
                        type: form.fieldType,
                        defaultValue: form.default_value,
                        className: "cs_form_field_3",
                        required: form.isRequired,
                        onChange: function onChange(e) {
                          return handleSetData(e, form.label, form.placeholder);
                        },
                        placeholder: "".concat(form.placeholder ? form.placeholder : "").concat(form.label ? "" : form.isRequired ? " *" : "")
                      }), form.fieldType !== "hidden" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                        className: "cs_height_40 cs_height_lg_20"
                      })]
                    })
                  })
                }, index);
              }), is_active_google_captcha === "1" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                className: "cs_mb_15",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)((react_google_recaptcha__WEBPACK_IMPORTED_MODULE_3___default()), {
                  sitekey: captchaSiteKey,
                  onChange: handleCaptchaChange
                }), captchaError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                  className: "text-danger mb-3",
                  children: captchaError
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                className: "cs_height_10 cs_height_lg_10"
              }), (sections_data === null || sections_data === void 0 ? void 0 : sections_data.submit_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                className: "col-lg-12",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                  className: "cs_height_5 cs_height_lg_5"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("button", {
                  disabled: !captchaVerified && processing,
                  className: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm",
                  children: [sections_data === null || sections_data === void 0 ? void 0 : sections_data.submit_btn_text, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("span", {
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("i", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("svg", {
                        width: 11,
                        height: 11,
                        viewBox: "0 0 11 11",
                        fill: "none",
                        xmlns: "http://www.w3.org/2000/svg",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
                          d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                          stroke: "currentColor",
                          strokeWidth: "1.5",
                          strokeLinecap: "round",
                          strokeLinejoin: "round"
                        })
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("i", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("svg", {
                        width: 11,
                        height: 11,
                        viewBox: "0 0 11 11",
                        fill: "none",
                        xmlns: "http://www.w3.org/2000/svg",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
                          d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                          stroke: "currentColor",
                          strokeWidth: "1.5",
                          strokeLinecap: "round",
                          strokeLinejoin: "round"
                        })
                      })
                    })]
                  })]
                })]
              }), wasSuccessful && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
                className: "text-success mt-2",
                children: flash.success
              })]
            })]
          })
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/ContactWithFormBuilder/ContactWithFormBuilder4.jsx":
/*!*********************************************************************************************!*\
  !*** ./resources/js/Frontend/Components/ContactWithFormBuilder/ContactWithFormBuilder4.jsx ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContactWithFormBuilder4)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-google-recaptcha */ "react-google-recaptcha");
/* harmony import */ var react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }





function ContactWithFormBuilder4(_ref) {
  var _sections_data$forms;
  var sections_data = _ref.sections_data;
  var captchaSiteKey = localStorage.getItem("google_captcha_site_key") ? JSON.parse(localStorage.getItem("google_captcha_site_key")) : [];
  var is_active_google_captcha = localStorage.getItem("is_active_google_captcha") ? JSON.parse(localStorage.getItem("is_active_google_captcha")) : [];
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    captchaVerified = _useState2[0],
    setCaptchaVerified = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
    _useState4 = _slicedToArray(_useState3, 2),
    captchaError = _useState4[0],
    setCaptchaError = _useState4[1];
  var flash = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.flash;
  var formRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var _useForm = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.useForm)({}),
    data = _useForm.data,
    setData = _useForm.setData,
    errors = _useForm.errors,
    post = _useForm.post,
    wasSuccessful = _useForm.wasSuccessful,
    reset = _useForm.reset,
    processing = _useForm.processing;
  var handleSetData = function handleSetData(e, label, placeholder) {
    var fieldName;
    if (label) {
      fieldName = label.toLowerCase().replace(/\s+/g, "_");
    } else if (placeholder) {
      fieldName = placeholder.toLowerCase().replace(/\s+/g, "_");
    } else {
      fieldName = "field_".concat(Object.keys(data).length + 1);
    }
    setData(fieldName, e.target.value);
  };
  var handleCaptchaChange = function handleCaptchaChange(value) {
    if (is_active_google_captcha === "1") {
      if (value) {
        setData("captchaToken", value);
        setCaptchaVerified(true);
        setCaptchaError(null);
      } else {
        setCaptchaVerified(false);
      }
    }
  };
  var handleSubmit = function handleSubmit(e) {
    e.preventDefault();
    if (!captchaVerified && is_active_google_captcha === "1") {
      setCaptchaError(translate("Please complete the captcha verification"));
      return;
    }
    post(route("form.submit"), {
      preserveScroll: true,
      onSuccess: function onSuccess() {
        reset();
        formRef.current.reset();
      }
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    setData(function (prevData) {
      return _objectSpread(_objectSpread({}, prevData), {}, {
        response_from: sections_data === null || sections_data === void 0 ? void 0 : sections_data.response_form,
        form_name: sections_data === null || sections_data === void 0 ? void 0 : sections_data.form_name
      });
    });
  }, [sections_data]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "row align-items-center cs_reverse_lg cs_gap_y_40",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "col-lg-6",
          children: [(sections_data.section_subtitle || sections_data.section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "cs_section_heading cs_style_1",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
                className: "cs_section_subtitle cs_fs_18 cs_medium",
                dangerouslySetInnerHTML: {
                  __html: sections_data.section_subtitle
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h2", {
                className: "cs_section_title cs_fs_53 cs_normal mb-0",
                dangerouslySetInnerHTML: {
                  __html: sections_data.section_title
                }
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "cs_height_85 cs_height_lg_50"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("form", {
            ref: formRef,
            className: "row cs_insurance_form cs_gap_y_35",
            onSubmit: handleSubmit,
            children: [sections_data === null || sections_data === void 0 || (_sections_data$forms = sections_data.forms) === null || _sections_data$forms === void 0 ? void 0 : _sections_data$forms.map(function (form, index) {
              var _form$column, _form$column2, _form$radio_options, _form$column3, _form$checkbox_option, _form$column4, _form$select_options, _form$column5;
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: form.fieldType === "multilineText" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-sm-".concat((_form$column = form.column) !== null && _form$column !== void 0 ? _form$column : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("textarea", {
                      cols: "30",
                      rows: "7",
                      className: "cs_insurance_input",
                      defaultValue: form.default_value,
                      required: form.isRequired,
                      onChange: function onChange(e) {
                        return handleSetData(e, form.label, form.placeholder);
                      },
                      placeholder: "".concat(form.placeholder ? form.placeholder : "").concat(form.label ? "" : form.isRequired ? " *" : "")
                    })]
                  }, "multiline-".concat(index))
                }) : form.fieldType === "radio" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column2 = form.column) !== null && _form$column2 !== void 0 ? _form$column2 : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_radio_group",
                      children: form === null || form === void 0 || (_form$radio_options = form.radio_options) === null || _form$radio_options === void 0 ? void 0 : _form$radio_options.map(function (option, optionIndex) {
                        var _form$label;
                        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                          className: "cs_radio_wrapper",
                          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
                            type: "radio",
                            id: "radio-".concat(index, "-").concat(optionIndex),
                            name: ((_form$label = form.label) === null || _form$label === void 0 ? void 0 : _form$label.toLowerCase().replace(/\s+/g, "_")) || "radio_group_".concat(index),
                            value: option,
                            required: form.isRequired,
                            defaultChecked: form.default_value === option,
                            onChange: function onChange(e) {
                              return handleSetData(e, form.label, form.placeholder);
                            }
                          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("label", {
                            style: {
                              marginLeft: "8px"
                            },
                            htmlFor: "radio-".concat(index, "-").concat(optionIndex),
                            children: option
                          })]
                        }, "radio-".concat(index, "-").concat(optionIndex));
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_22 cs_height_lg_22"
                    })]
                  })
                }) : form.fieldType === "checkbox" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-lg-".concat((_form$column3 = form.column) !== null && _form$column3 !== void 0 ? _form$column3 : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_checkbox_group",
                      children: form === null || form === void 0 || (_form$checkbox_option = form.checkbox_options) === null || _form$checkbox_option === void 0 ? void 0 : _form$checkbox_option.map(function (option, optionIndex) {
                        var _form$label2;
                        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                          className: "cs_checkbox_wrapper",
                          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
                            type: "checkbox",
                            id: "checkbox-".concat(index, "-").concat(optionIndex),
                            name: ((_form$label2 = form.label) === null || _form$label2 === void 0 ? void 0 : _form$label2.toLowerCase().replace(/\s+/g, "_")) || "checkbox_group_".concat(index),
                            value: option,
                            required: form.isRequired,
                            defaultChecked: form.default_value === option,
                            onChange: function onChange(e) {
                              return handleSetData(e, form.label, form.placeholder);
                            }
                          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("label", {
                            style: {
                              marginLeft: "8px"
                            },
                            htmlFor: "checkbox-".concat(index, "-").concat(optionIndex),
                            children: option
                          })]
                        }, "checkbox-".concat(index, "-").concat(optionIndex));
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                      className: "cs_height_22 cs_height_lg_22"
                    })]
                  })
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: form.fieldType === "select" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-sm-".concat((_form$column4 = form.column) !== null && _form$column4 !== void 0 ? _form$column4 : "6"),
                    children: [form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                      htmlFor: "",
                      children: [form.label, " ", form.isRequired && "*"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("select", {
                      className: "cs_insurance_input",
                      required: form.isRequired,
                      onChange: function onChange(e) {
                        return handleSetData(e, form.label, form.placeholder);
                      },
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("option", {
                        value: "",
                        children: "Select an option"
                      }), form === null || form === void 0 || (_form$select_options = form.select_options) === null || _form$select_options === void 0 ? void 0 : _form$select_options.map(function (option, optIndex) {
                        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("option", {
                          value: option,
                          children: option
                        }, "options-".concat(index, "-").concat(optIndex));
                      })]
                    })]
                  }, "select-".concat(index)) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                    className: "col-sm-".concat((_form$column5 = form.column) !== null && _form$column5 !== void 0 ? _form$column5 : "6"),
                    children: [form.fieldType !== "hidden" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                      children: form.label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
                        children: [form.label, " ", form.isRequired && "*"]
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
                      type: form.fieldType,
                      defaultValue: form.default_value,
                      className: "cs_insurance_input",
                      required: form.isRequired,
                      onChange: function onChange(e) {
                        return handleSetData(e, form.label, form.placeholder);
                      },
                      placeholder: "".concat(form.placeholder ? form.placeholder : "").concat(form.label ? "" : form.isRequired ? " *" : "")
                    })]
                  }, "input-".concat(index))
                })
              });
            }), is_active_google_captcha === "1" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)((react_google_recaptcha__WEBPACK_IMPORTED_MODULE_2___default()), {
                sitekey: captchaSiteKey,
                onChange: handleCaptchaChange
              }), captchaError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "text-danger mb-3",
                children: captchaError
              })]
            }), (sections_data === null || sections_data === void 0 ? void 0 : sections_data.submit_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "col-lg-12",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "cs_height_5 cs_height_lg_5"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("button", {
                disabled: !captchaVerified && processing,
                className: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm",
                children: [sections_data === null || sections_data === void 0 ? void 0 : sections_data.submit_btn_text, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
                      width: 11,
                      height: 11,
                      viewBox: "0 0 11 11",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
                        d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                        stroke: "currentColor",
                        strokeWidth: "1.5",
                        strokeLinecap: "round",
                        strokeLinejoin: "round"
                      })
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
                      width: 11,
                      height: 11,
                      viewBox: "0 0 11 11",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
                        d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                        stroke: "currentColor",
                        strokeWidth: "1.5",
                        strokeLinecap: "round",
                        strokeLinejoin: "round"
                      })
                    })
                  })]
                })]
              })]
            }), wasSuccessful && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "text-success mt-2",
              children: flash.success
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "col-xl-5 offset-xl-1 col-lg-6",
          children: sections_data.image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
            src: sections_data.image_url,
            alt: "Thumbnail",
            className: "cs_radius_100_0_0_0"
          })
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Cookie/CookiePolicy.jsx":
/*!******************************************************************!*\
  !*** ./resources/js/Frontend/Components/Cookie/CookiePolicy.jsx ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _CookiePolicy_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CookiePolicy.css */ "./resources/js/Frontend/Components/Cookie/CookiePolicy.css");
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var js_cookie__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! js-cookie */ "js-cookie");
/* harmony import */ var js_cookie__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(js_cookie__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }






var CookiePolicy = function CookiePolicy() {
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    visible = _useState2[0],
    setVisible = _useState2[1];
  var handleAcceptCookie = function handleAcceptCookie() {
    js_cookie__WEBPACK_IMPORTED_MODULE_3___default().set("accept_cookie", true, {
      expires: 365
    });
    window.location.reload();
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var consent = js_cookie__WEBPACK_IMPORTED_MODULE_3___default().get("accept_cookie");
    if (!consent) {
      setVisible(true);
    }
  }, []);
  return visible ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: "cookie-consent",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "cookie-card",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "cookie-content",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "cookie-icon",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("svg", {
            xmlns: "http://www.w3.org/2000/svg",
            width: "24",
            height: "24",
            viewBox: "0 0 24 24",
            fill: "none",
            stroke: "currentColor",
            strokeWidth: "2",
            strokeLinecap: "round",
            strokeLinejoin: "round",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
              d: "M12 2a10 10 0 1 0 10 10 4 4 0 0 1-5-5 4 4 0 0 1-5-5"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
              d: "M8.5 8.5v.01"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
              d: "M16 15.5v.01"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
              d: "M12 12v.01"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
              d: "M11 17v.01"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
              d: "M7 14v.01"
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
          className: "cookie-message",
          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_2__["default"])("We use cookies to enhance your browsing experience, personalize content, and analyze our traffic. By clicking 'Accept all', you consent to our use of cookies.")
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "cookie-actions",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("button", {
          className: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm",
          onClick: handleAcceptCookie,
          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_2__["default"])("Accept all")
        })
      })]
    })
  }) : null;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CookiePolicy);

/***/ }),

/***/ "./resources/js/Frontend/Components/CoreValue/CoreValue.jsx":
/*!******************************************************************!*\
  !*** ./resources/js/Frontend/Components/CoreValue/CoreValue.jsx ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CoreValue)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function CoreValue(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    section_description = data.section_description,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
    className: "container",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: "cs_section_heading cs_style_2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "cs_section_heading_left",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0 cs_normal",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "cs_section_heading_right",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
          className: "cs_section_heading_text mb-0 cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_description
          }
        })
      })]
    }), (section_subtitle || section_description || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "cs_height_85 cs_height_lg_50"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "row cs_gap_y_40",
      children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "col-lg-4",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: "cs_iconbox cs_style_1",
            children: [item.feature_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_iconbox_icon rounded-circle cs_gray_bg",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
                src: item.feature_icon_url,
                alt: item.feature_title
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", {
              className: "cs_iconbox_title cs_fs_30 cs_normal",
              dangerouslySetInnerHTML: {
                __html: item.feature_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
              className: "cs_iconbox_subtitle mb-0",
              dangerouslySetInnerHTML: {
                __html: item.feature_subtitle
              }
            })]
          })
        }, index);
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CoreValue/CoreValue2.jsx":
/*!*******************************************************************!*\
  !*** ./resources/js/Frontend/Components/CoreValue/CoreValue2.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CoreValue2)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function CoreValue2(_ref) {
  var data = _ref.data;
  var feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "row cs_gap_y_30",
      children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "col-lg-4",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: "cs_card cs_style_3",
            children: [item.feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
              className: "cs_card_title cs_fs_18 cs_medium position-relative",
              dangerouslySetInnerHTML: {
                __html: item.feature_title
              }
            }), item.feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_card_description cs_primary_font cs_fs_24 cs_primary_color",
              dangerouslySetInnerHTML: {
                __html: item.feature_subtitle
              }
            })]
          })
        }, index);
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CoreValue/CoreValue3.jsx":
/*!*******************************************************************!*\
  !*** ./resources/js/Frontend/Components/CoreValue/CoreValue3.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CoreValue3)
/* harmony export */ });
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function CoreValue3(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    section_description = data.section_description,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "container",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "cs_section_heading cs_style_2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "cs_section_heading_left",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0 cs_normal",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_section_heading_right",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
          className: "cs_section_heading_text mb-0 cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_description
          }
        })
      })]
    }), (section_subtitle || section_description || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "cs_height_85 cs_height_lg_50"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "row cs_gap_y_40",
      children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "col-lg-4",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
            className: "cs_iconbox cs_style_1 cs_type_1",
            children: [item.feature_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
              className: "cs_iconbox_icon rounded-circle cs_gray_bg",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                src: item.feature_icon_url,
                alt: item.feature_title
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
              className: "cs_iconbox_title cs_fs_30 cs_normal",
              dangerouslySetInnerHTML: {
                __html: item.feature_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
              className: "cs_iconbox_subtitle mb-0",
              dangerouslySetInnerHTML: {
                __html: item.feature_subtitle
              }
            }), (item.feature_btn_url || item.feature_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_0__["default"], {
              href: item.feature_btn_url,
              btnText: item.feature_btn_text,
              btnClass: "cs_btn cs_style_1 cs_type_4 cs_primary_color"
            })]
          })
        }, index);
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CoreValue/CoreValue4.jsx":
/*!*******************************************************************!*\
  !*** ./resources/js/Frontend/Components/CoreValue/CoreValue4.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CoreValue4)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function CoreValue4(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    image_url = data.image_url,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: "row align-items-center cs_gap_y_40 cs_service_details_features",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "col-xl-6",
        children: image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "cs_pr_70",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
            src: image_url,
            alt: "Thumbnail",
            className: "w-100"
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "col-xl-6",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_height_22 cs_height_lg_22"
            })]
          }), section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
            className: "mb-0",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "cs_height_55 cs_height_lg_40"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "row cs_gap_y_45",
          children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "col-sm-6",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "cs_iconbox cs_style_2",
                children: [item.feature_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
                  className: "cs_iconbox_icon",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
                    src: item.feature_icon_url,
                    alt: "Icon"
                  })
                }), item.feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", {
                  className: "cs_iconbox_title cs_fs_24 cs_normal",
                  dangerouslySetInnerHTML: {
                    __html: item.feature_title
                  }
                }), item.feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
                  className: "cs_iconbox_subtitle mb-0",
                  dangerouslySetInnerHTML: {
                    __html: item.feature_subtitle
                  }
                })]
              })
            }, index);
          })
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CoreValue/CoreValue5.jsx":
/*!*******************************************************************!*\
  !*** ./resources/js/Frontend/Components/CoreValue/CoreValue5.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CoreValue5)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function CoreValue5(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
    className: "container",
    children: [(section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "row cs_gap_y_35",
      children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "col-xl-3 col-md-6",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: "cs_iconbox cs_style_7",
            children: [item.feature_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_iconbox_icon",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
                src: item.feature_icon_url,
                alt: "Icon"
              })
            }), item.feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", {
              className: "cs_iconbox_title cs_fs_24 cs_normal",
              dangerouslySetInnerHTML: {
                __html: item.feature_title
              }
            }), item.feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
              className: "cs_iconbox_subtitle mb-0",
              dangerouslySetInnerHTML: {
                __html: item.feature_subtitle
              }
            })]
          })
        }, index);
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Cta/Cta.jsx":
/*!******************************************************!*\
  !*** ./resources/js/Frontend/Components/Cta/Cta.jsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cta)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Cta(_ref) {
  var data = _ref.data;
  var background_image_url = data.background_image_url,
    title = data.title,
    sub_title = data.sub_title,
    action_text = data.action_text,
    action_url = data.action_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "cs_team cs_style_1 cs_bg_filed",
    style: {
      backgroundImage: "url(".concat(background_image_url, ")")
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_1",
        children: [sub_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium cs_ternary_color",
          dangerouslySetInnerHTML: {
            __html: sub_title
          }
        }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0 cs_white_color",
          dangerouslySetInnerHTML: {
            __html: title
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "cs_height_35 cs_height_lg_25"
        }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
          href: action_url,
          btnText: action_text,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_color cs_white_bg"
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Cta/Cta2.jsx":
/*!*******************************************************!*\
  !*** ./resources/js/Frontend/Components/Cta/Cta2.jsx ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cta2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Cta2(_ref) {
  var data = _ref.data;
  var image_url = data.image_url,
    title = data.title,
    sub_title = data.sub_title,
    action_text = data.action_text,
    action_url = data.action_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "cs_cta cs_style_1 text-center position-relative",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_cta_shape_1 cs_accent_color position-absolute",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("svg", {
        width: 219,
        height: 475,
        viewBox: "0 0 219 475",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("rect", {
          x: "186.468",
          y: "187.382",
          width: 451,
          height: 42,
          transform: "rotate(140.444 186.468 187.382)",
          fill: "currentColor"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("rect", {
          x: "203.468",
          y: "109.382",
          width: 451,
          height: 42,
          transform: "rotate(140.444 203.468 109.382)",
          fill: "currentColor"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("rect", {
          x: "218.468",
          y: "32.3823",
          width: 451,
          height: 42,
          transform: "rotate(140.444 218.468 32.3823)",
          fill: "currentColor"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_cta_shape_2 cs_accent_color position-absolute",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("svg", {
        width: 219,
        height: 475,
        viewBox: "0 0 219 475",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("rect", {
          x: 32,
          y: "287.213",
          width: 451,
          height: 42,
          transform: "rotate(-39.5563 32 287.213)",
          fill: "currentColor"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("rect", {
          x: 15,
          y: "365.213",
          width: 451,
          height: 42,
          transform: "rotate(-39.5563 15 365.213)",
          fill: "currentColor"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("rect", {
          y: "442.213",
          width: 451,
          height: 42,
          transform: "rotate(-39.5563 0 442.213)",
          fill: "currentColor"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_cta_shape_1"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "container",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
        className: "cs_cta_title cs_fs_120 cs_bold",
        dangerouslySetInnerHTML: {
          __html: title
        }
      }), sub_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
        className: "cs_cta_subtitle",
        dangerouslySetInnerHTML: {
          __html: sub_title
        }
      }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
        href: action_url,
        btnText: action_text,
        btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm"
      }), image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_cta_thumb",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
          src: image_url,
          alt: "Thumb"
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Cta/Cta3.jsx":
/*!*******************************************************!*\
  !*** ./resources/js/Frontend/Components/Cta/Cta3.jsx ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cta3)
/* harmony export */ });
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Cta3(_ref) {
  var data = _ref.data;
  var image_url = data.image_url,
    background_image_url = data.background_image_url,
    title = data.title,
    action_text = data.action_text,
    action_url = data.action_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "cs_cta cs_style_3 position-relative cs_bg_filed",
      style: {
        backgroundImage: "url(".concat(background_image_url, ")")
      },
      children: [image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_cta_icon",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
          src: image_url,
          alt: title
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "cs_cta_in position-relative",
        children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_cta_title cs_fs_30 cs_normal cs_white_color",
          dangerouslySetInnerHTML: {
            __html: title
          }
        }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_0__["default"], {
          href: action_url,
          btnText: action_text,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm"
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Cta/Cta4.jsx":
/*!*******************************************************!*\
  !*** ./resources/js/Frontend/Components/Cta/Cta4.jsx ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cta4)
/* harmony export */ });
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Cta4(_ref) {
  var data = _ref.data;
  var title = data.title,
    action_text = data.action_text,
    action_url = data.action_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "cs_cta cs_style_4 text-center",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
        className: "cs_cta_title cs_white_color cs_fs_120",
        dangerouslySetInnerHTML: {
          __html: title
        }
      }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_0__["default"], {
        href: action_url,
        btnText: action_text,
        btnClass: "cs_btn cs_style_1 cs_type_4 cs_fs_18"
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/CustomHTML/CustomHTML.jsx":
/*!********************************************************************!*\
  !*** ./resources/js/Frontend/Components/CustomHTML/CustomHTML.jsx ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CustomHTML)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function CustomHTML(_ref) {
  var data = _ref.data;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "cs_custom_html_section",
    dangerouslySetInnerHTML: {
      __html: data.html_code
    }
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/EventSchedule/EventSchedule1.jsx":
/*!***************************************************************************!*\
  !*** ./resources/js/Frontend/Components/EventSchedule/EventSchedule1.jsx ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EventSchedule1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function EventSchedule1(_ref) {
  var _data$event_list;
  var data = _ref.data;
  // const [section_title, section_subtitle, event_list] = data || [];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "container",
      children: ((data === null || data === void 0 ? void 0 : data.section_title) || (data === null || data === void 0 ? void 0 : data.section_title)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "cs_section_heading cs_style_1 text-center",
          children: [(data === null || data === void 0 ? void 0 : data.section_subtitle) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: data === null || data === void 0 ? void 0 : data.section_subtitle
            }
          }), (data === null || data === void 0 ? void 0 : data.section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: data === null || data === void 0 ? void 0 : data.section_title
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "cs_height_85 cs_height_lg_50"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
        className: "cs_image_box_1_list cs_type_1 cs_mp0",
        children: data === null || data === void 0 || (_data$event_list = data.event_list) === null || _data$event_list === void 0 ? void 0 : _data$event_list.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
              className: "cs_image_box cs_style_1",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
                className: "cs_image_box_number cs_primary_font cs_fs_53",
                children: item.event_serial_number
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
                className: "cs_image_box_img overflow-hidden",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
                  src: item.event_image_url,
                  alt: item.event_image_url
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                className: "cs_image_box_info position-relative",
                children: [item.event_time && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                  className: "cs_image_box_time cs_fs_18 cs_medium cs_ternary_color",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                    className: "cs_accent_color",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
                      width: 20,
                      height: 20,
                      viewBox: "0 0 20 20",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
                        d: "M9.99 0C4.47 0 0 4.48 0 10C0 15.52 4.47 20 9.99 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 9.99 0ZM10 18C5.58 18 2 14.42 2 10C2 5.58 5.58 2 10 2C14.42 2 18 5.58 18 10C18 14.42 14.42 18 10 18ZM9.78 5H9.72C9.32 5 9 5.32 9 5.72V10.44C9 10.79 9.18 11.12 9.49 11.3L13.64 13.79C13.98 13.99 14.42 13.89 14.62 13.55C14.83 13.21 14.72 12.76 14.37 12.56L10.5 10.26V5.72C10.5 5.32 10.18 5 9.78 5Z",
                        fill: "currentColor"
                      })
                    })
                  }), item.event_time]
                }), item.event_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
                  className: "cs_image_box_title cs_fs_30 cs_normal",
                  dangerouslySetInnerHTML: {
                    __html: item.event_title
                  }
                }), item.event_details && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
                  className: "cs_image_box_subtitle mb-0 cs_ternary_color",
                  dangerouslySetInnerHTML: {
                    __html: item.event_details
                  }
                }), (item.event_action_url || item.event_action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
                  href: item.event_action_url,
                  btnText: item.event_action_text,
                  btnClass: "cs_btn cs_style_1 cs_type_4 cs_fs_18 cs_medium"
                })]
              })]
            })
          }, index);
        })
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Faq/Faq1.jsx":
/*!*******************************************************!*\
  !*** ./resources/js/Frontend/Components/Faq/Faq1.jsx ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Faq1)
/* harmony export */ });
/* harmony import */ var _Accordion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Accordion */ "./resources/js/Frontend/Components/Accordion.jsx");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Faq1(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    image_url = data.image_url,
    action_text = data.action_text,
    action_url = data.action_url,
    faq_list = data.faq_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "col-lg-5",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_height_40 cs_height_lg_40"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
            href: action_url,
            btnText: action_text,
            btnClass: "cs_btn cs_style_1 cs_type_4 cs_primary_color cs_shining_btn"
          })]
        }), image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_height_75 cs_height_lg_30"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_mobile_hide cs_ternary_color",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
              src: image_url,
              alt: "Shape"
            })
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "col-lg-6 offset-lg-1",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Accordion__WEBPACK_IMPORTED_MODULE_0__["default"], {
          accordionData: faq_list,
          variant: "cs_accordians cs_style_1"
        })
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Faq/Faq2.jsx":
/*!*******************************************************!*\
  !*** ./resources/js/Frontend/Components/Faq/Faq2.jsx ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Faq2)
/* harmony export */ });
/* harmony import */ var _Accordion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Accordion */ "./resources/js/Frontend/Components/Accordion.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Faq2(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_title_2 = data.section_title_2,
    faq_list = data.faq_list,
    faq_list_2 = data.faq_list_2;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "row cs_gap_y_100",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "col-xl-6",
        children: [section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_faq_heading cs_fs_30 cs_normal cs_white_color cs_accent_bg",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Accordion__WEBPACK_IMPORTED_MODULE_0__["default"], {
          accordionData: faq_list,
          variant: "cs_accordians cs_style_1"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "col-xl-6",
        children: [section_title_2 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_faq_heading cs_fs_30 cs_normal cs_white_color cs_accent_bg",
          dangerouslySetInnerHTML: {
            __html: section_title_2
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Accordion__WEBPACK_IMPORTED_MODULE_0__["default"], {
          accordionData: faq_list_2,
          variant: "cs_accordians cs_style_1"
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Footer/Footer2.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Footer/Footer2.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Widget/SocialWidget */ "./resources/js/Frontend/Components/Widget/SocialWidget.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Cookie_CookiePolicy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Cookie/CookiePolicy */ "./resources/js/Frontend/Components/Cookie/CookiePolicy.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





function Footer2() {
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useSelector)(function (state) {
    return state.customize;
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("footer", {
    className: "cs_fullscreen_footer",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "container-fluid cs_padding_120_120",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "cs_fullscreen_footer_in",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "cs_fullscreen_footer_left",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
            className: "cs_copyright",
            dangerouslySetInnerHTML: {
              __html: customize.footer.copyright_text
            }
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "cs_fullscreen_footer_right",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_1__["default"], {})
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Footer/index.jsx":
/*!***********************************************************!*\
  !*** ./resources/js/Frontend/Components/Footer/index.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _Widget_ContactInfoWidget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Widget/ContactInfoWidget */ "./resources/js/Frontend/Components/Widget/ContactInfoWidget.jsx");
/* harmony import */ var _Widget_MenuWidget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Widget/MenuWidget */ "./resources/js/Frontend/Components/Widget/MenuWidget.jsx");
/* harmony import */ var _Widget_Newsletter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Widget/Newsletter */ "./resources/js/Frontend/Components/Widget/Newsletter.jsx");
/* harmony import */ var _Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Widget/SocialWidget */ "./resources/js/Frontend/Components/Widget/SocialWidget.jsx");
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Widget_MenuItem__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Widget/MenuItem */ "./resources/js/Frontend/Components/Widget/MenuItem.jsx");
/* harmony import */ var _Cookie_CookiePolicy__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Cookie/CookiePolicy */ "./resources/js/Frontend/Components/Cookie/CookiePolicy.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);












function Footer() {
  var _customize$footer, _customize$footer2, _customize$footer3, _customize$footer4, _customize$footer5;
  var lang = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_3__.usePage)().props.lang;
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_1__.useSelector)(function (state) {
    return state.customize;
  });
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_1__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector.currentLang;
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var servicesMenu = localStorage.getItem("services_menu") ? JSON.parse(localStorage.getItem("services_menu")) : [];
  var services_menu = servicesMenu ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_8__["default"])(servicesMenu[currentLanguage]) : [];
  var FooterMenu = localStorage.getItem("footer_menu") ? JSON.parse(localStorage.getItem("footer_menu")) : [];
  var footer_menu = FooterMenu ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_8__["default"])(FooterMenu[currentLanguage]) : [];
  var resourcesMenu = localStorage.getItem("resources_menu") ? JSON.parse(localStorage.getItem("resources_menu")) : [];
  var resources_menu = resourcesMenu ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_8__["default"])(resourcesMenu[currentLanguage]) : [];
  var usefulLinks = localStorage.getItem("useful_links") ? JSON.parse(localStorage.getItem("useful_links")) : [];
  var useful_links = usefulLinks ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_8__["default"])(usefulLinks[currentLanguage]) : [];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("footer", {
    className: "cs_footer cs_primary_bg cs_ternary_color",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: "cs_footer_main",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "container",
        children: [Boolean(Number(customize === null || customize === void 0 || (_customize$footer = customize.footer) === null || _customize$footer === void 0 ? void 0 : _customize$footer.footer_is_show_newslatter)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Widget_Newsletter__WEBPACK_IMPORTED_MODULE_6__["default"], {
          placeholder: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_2__["default"])("Email address"),
          title: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_2__["default"])("Subscribe to our newsletter"),
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_color cs_white_bg",
          titleClass: "cs_newsletter_title cs_fs_53 cs_normal mb-0 cs_white_color"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "cs_footer_grid_4",
          children: [(customize === null || customize === void 0 || (_customize$footer2 = customize.footer) === null || _customize$footer2 === void 0 ? void 0 : _customize$footer2.footer_is_show_contact_logo_section) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
            className: "cs_footer_grid_item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_footer_item",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_text_widget",
                children: [customize.general.site_favicon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                  src: customize.general.site_logo_light,
                  alt: "Logo"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Widget_ContactInfoWidget__WEBPACK_IMPORTED_MODULE_4__["default"], {})]
              })
            })
          }), (customize === null || customize === void 0 || (_customize$footer3 = customize.footer) === null || _customize$footer3 === void 0 ? void 0 : _customize$footer3.footer_is_show_useful_links_section) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
            className: "cs_footer_grid_item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_footer_item",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Widget_MenuWidget__WEBPACK_IMPORTED_MODULE_5__["default"], {
                menus: useful_links,
                title: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_2__["default"])("Useful Links")
              })
            })
          }), (customize === null || customize === void 0 || (_customize$footer4 = customize.footer) === null || _customize$footer4 === void 0 ? void 0 : _customize$footer4.footer_is_show_service_section) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
            className: "cs_footer_grid_item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_footer_item",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Widget_MenuWidget__WEBPACK_IMPORTED_MODULE_5__["default"], {
                menus: services_menu,
                title: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_2__["default"])("Service")
              })
            })
          }), (customize === null || customize === void 0 || (_customize$footer5 = customize.footer) === null || _customize$footer5 === void 0 ? void 0 : _customize$footer5.footer_is_show_resources_section) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
            className: "cs_footer_grid_item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_footer_item",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Widget_MenuWidget__WEBPACK_IMPORTED_MODULE_5__["default"], {
                menus: resources_menu,
                title: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_2__["default"])("Resources")
              })
            })
          })]
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: "cs_bottom_footer_wrap",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "cs_bottom_footer",
          children: [customize.footer.footer_is_show_social_media == "1" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
            className: "cs_bottom_footer_left",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_7__["default"], {})
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
            className: "cs_copyright",
            dangerouslySetInnerHTML: {
              __html: customize.footer.copyright_text
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
            className: "cs_bottom_footer_right",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
              className: "cs_footer_links cs_mp0",
              children: footer_menu.map(function (menu, index) {
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Widget_MenuItem__WEBPACK_IMPORTED_MODULE_9__["default"], {
                  menu: menu
                }, index);
              })
            })
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Cookie_CookiePolicy__WEBPACK_IMPORTED_MODULE_10__["default"], {})]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/FunFact/FunFact1.jsx":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/FunFact/FunFact1.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FunFact1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function FunFact1(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    funfact_list = data.funfact_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "container",
    children: [section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "cs_counter_1_wrap",
      children: funfact_list === null || funfact_list === void 0 ? void 0 : funfact_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
          className: "cs_counter cs_style_1 position-relative text-center",
          children: [item.funfact_value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
            className: "cs_fs_60 cs_primary_font cs_bold cs_primary_color d-flex justify-content-center",
            children: item.funfact_value
          }), item.funfact_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
            className: "cs_fs_18 cs_medium mb-0",
            dangerouslySetInnerHTML: {
              __html: item.funfact_title
            }
          })]
        }, index);
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/DropDown.js":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/DropDown.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DropDown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }


function DropDown(_ref) {
  var children = _ref.children;
  // Mobile Toggle
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    mobileToggle = _useState2[0],
    setMobileToggle = _useState2[1];
  var handelMobileToggle = function handelMobileToggle() {
    setMobileToggle(!mobileToggle);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
      className: "cs_munu_dropdown_toggle".concat(mobileToggle ? " active" : ""),
      onClick: handelMobileToggle,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {})
    }), children]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/GlobalSearch.jsx":
/*!******************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/GlobalSearch.jsx ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GlobalSearch)
/* harmony export */ });
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }




function GlobalSearch() {
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(""),
    _useState2 = _slicedToArray(_useState, 2),
    searchQuery = _useState2[0],
    setSearchQuery = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    toggle = _useState4[0],
    setToggle = _useState4[1];
  var searchFormRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
  var searchToggleRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);

  // Handle click outside
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (searchFormRef.current && searchToggleRef.current && !searchFormRef.current.contains(event.target) && !searchToggleRef.current.contains(event.target)) {
        setToggle(false);
      }
    };

    // Add event listener when component mounts
    document.addEventListener("mousedown", handleClickOutside);

    // Clean up event listener when component unmounts
    return function () {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, []);

  // Handle search submission
  var getResults = function getResults(query) {
    _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.get(route("search.name"), {
      search: query
    }, {
      preserveState: true
    });
  };
  var handleSubmit = function handleSubmit(event) {
    event.preventDefault();
    getResults(searchQuery);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      ref: searchToggleRef,
      className: "cs_search_mobile_toggle",
      onClick: function onClick() {
        return setToggle(!toggle);
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
        width: 20,
        height: 20,
        viewBox: "0 0 20 20",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
          d: "M18.9996 19L12.9997 13M14.9996 8C14.9996 11.866 11.8656 15 7.99963 15C4.13364 15 0.999634 11.866 0.999634 8C0.999634 4.13401 4.13364 1 7.99963 1C11.8656 1 14.9996 4.13401 14.9996 8Z",
          stroke: "currentColor",
          strokeWidth: 2,
          strokeLinecap: "round",
          strokeLinejoin: "round"
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("form", {
      ref: searchFormRef,
      onSubmit: handleSubmit,
      className: "cs_header_search_form".concat(toggle ? " active" : ""),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
        type: "text",
        placeholder: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_0__["default"])("Search"),
        className: "cs_header_search_field",
        value: searchQuery,
        onChange: function onChange(e) {
          return setSearchQuery(e.target.value);
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("button", {
        type: "submit",
        className: "cs_header_submit_btn",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
          width: 20,
          height: 20,
          viewBox: "0 0 20 20",
          fill: "none",
          xmlns: "http://www.w3.org/2000/svg",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
            d: "M18.9996 19L12.9997 13M14.9996 8C14.9996 11.866 11.8656 15 7.99963 15C4.13364 15 0.999634 11.866 0.999634 8C0.999634 4.13401 4.13364 1 7.99963 1C11.8656 1 14.9996 4.13401 14.9996 8Z",
            stroke: "currentColor",
            strokeWidth: 2,
            strokeLinecap: "round",
            strokeLinejoin: "round"
          })
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/Header10.jsx":
/*!**************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/Header10.jsx ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header10)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }












function Header10() {
  var _customize$general, _customize$general2, _auth$user, _auth$user2, _auth$user3;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var currentLangPageInfo = pageInfo[currentLang];
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState6 = _slicedToArray(_useState5, 2),
    isSticky = _useState6[0],
    setIsSticky = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    profileDropdownOpen = _useState8[0],
    setProfileDropdownOpen = _useState8[1];
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    showAlert("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Logout"), "!"), function () {
      _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("header", {
      className: "cs_site_header cs_style_1 cs_color_1 cs_sticky_header".concat(isSticky ? " cs_sticky_active" : ""),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "container-fluid",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_left",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_light,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "cs_main_header_right",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_nav",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("nav", {
                  className: "cs_nav_list_wrap".concat(mobileToggle ? " cs_active" : ""),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
                    className: "cs_nav_list",
                    children: menus.map(function (menuItem) {
                      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        setMobileToggle: setMobileToggle,
                        item: menuItem
                      }, menuItem.id);
                    })
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                  className: "cs_menu_toggle".concat(mobileToggle ? " cs_toggle_active" : ""),
                  onClick: function onClick() {
                    return setMobileToggle(!mobileToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_toolbox",
                children: [auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_9__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_8___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Login")
                  })
                }), (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                    children: cartItemCount
                  })]
                }), Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_6__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_7__["default"], {
                  href: currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.header_action_button_url,
                  btnText: currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.header_action_button_text,
                  btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color"
                })]
              })]
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/Header2.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/Header2.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _GlobalSearch__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./GlobalSearch */ "./resources/js/Frontend/Components/Header/GlobalSearch.jsx");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }












function Header2() {
  var _customize$general, _customize$general2, _auth$user, _auth$user2, _auth$user3;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var currentLangPageInfo = pageInfo[currentLang];
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState6 = _slicedToArray(_useState5, 2),
    isSticky = _useState6[0],
    setIsSticky = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    profileDropdownOpen = _useState8[0],
    setProfileDropdownOpen = _useState8[1];
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    showAlert("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Logout"), "!"), function () {
      _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("header", {
      className: "cs_site_header cs_style_1 cs_color_1 cs_sticky_header".concat(isSticky ? " cs_sticky_active" : ""),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "cs_main_header_left",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_light,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_nav",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("nav", {
                  className: "cs_nav_list_wrap".concat(mobileToggle ? " cs_active" : ""),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
                    className: "cs_nav_list",
                    children: menus.map(function (menuItem) {
                      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        setMobileToggle: setMobileToggle,
                        item: menuItem
                      }, menuItem.id);
                    })
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                  className: "cs_menu_toggle".concat(mobileToggle ? " cs_toggle_active" : ""),
                  onClick: function onClick() {
                    return setMobileToggle(!mobileToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_toolbox",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_GlobalSearch__WEBPACK_IMPORTED_MODULE_7__["default"], {}), auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_10__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_9___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Login")
                  })
                }), (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                    children: cartItemCount
                  })]
                }), Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("button", {
                  className: "cs_hamburger_btn cs_hamburger_info_btn ",
                  onClick: function onClick() {
                    return setSideHeaderToggle(!sideHeaderToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                    className: "cs_hamburger_btn_in",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})]
                  })
                })]
              })
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_6__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/Header3.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/Header3.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header3)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }












function Header3() {
  var _auth$user, _auth$user2, _auth$user3, _customize$general, _customize$general2, _customize$general3, _customize$general4, _customize$contact, _customize$contact2, _customize$contact3, _customize$contact4, _customize$contact5, _customize$contact6;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var currentLangPageInfo = pageInfo[currentLang];
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState6 = _slicedToArray(_useState5, 2),
    hamburgerToggle = _useState6[0],
    setHamburgerToggle = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState8 = _slicedToArray(_useState7, 2),
    isSticky = _useState8[0],
    setIsSticky = _useState8[1];
  var _useState9 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState10 = _slicedToArray(_useState9, 2),
    profileDropdownOpen = _useState10[0],
    setProfileDropdownOpen = _useState10[1];
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    showAlert("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Logout"), "!"), function () {
      _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("header", {
      className: "cs_site_header cs_style_2 cs_color_1 cs_sticky_header".concat(isSticky ? " cs_sticky_active" : ""),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_left",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_toolbox",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("button", {
                  className: "cs_hamburger_btn cs_hamburger_menu_btn",
                  onClick: function onClick() {
                    return setHamburgerToggle(!hamburgerToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                    className: "cs_hamburger_btn_in",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})]
                  })
                }), Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_7__["default"], {}), auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_8__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_9___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Login")
                  })
                }), (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                    children: cartItemCount
                  })]
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_center",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_light,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_6__["default"], {
                href: currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.header_action_button_url,
                btnText: currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.header_action_button_text,
                btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color"
              })
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: "cs_hamburger_overlay".concat(hamburgerToggle ? " active" : ""),
      onClick: function onClick() {
        return setHamburgerToggle(!hamburgerToggle);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "cs_hamburger_header cs_ternary_color cs_start_left".concat(hamburgerToggle ? " active" : ""),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("button", {
        className: "cs_close_hamburger",
        onClick: function onClick() {
          return setHamburgerToggle(!hamburgerToggle);
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("svg", {
          width: "25",
          height: "23",
          viewBox: "0 0 25 23",
          fill: "none",
          xmlns: "http://www.w3.org/2000/svg",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
            d: "M24.4427 9.15216L20.5229 2.38133C19.6875 0.938623 18.1333 0.041748 16.4656 0.041748H8.60622C6.93955 0.041748 5.38538 0.937581 4.54893 2.38133L0.630176 9.15216C-0.209408 10.6011 -0.209408 12.4001 0.630176 13.849L4.54997 20.6199C5.38643 22.0626 6.94059 22.9595 8.60726 22.9595H16.4666C18.1343 22.9595 19.6885 22.0636 20.5239 20.6199L24.4437 13.849C25.2833 12.4001 25.2823 10.6011 24.4427 9.15216ZM23.5416 13.3272L19.6218 20.098C18.9729 21.2199 17.7635 21.9178 16.4666 21.9178H8.60726C7.31143 21.9178 6.10205 21.2209 5.45205 20.098L1.53226 13.3272C0.880176 12.2001 0.880176 10.8011 1.53226 9.67404L5.45205 2.90321C6.10205 1.78133 7.31143 1.08341 8.60726 1.08341H16.4666C17.7635 1.08341 18.9729 1.78029 19.6218 2.90321L23.5416 9.67404C24.1937 10.8011 24.1937 12.2001 23.5416 13.3272ZM16.5146 8.223L13.2375 11.5001L16.5146 14.7772C16.7177 14.9803 16.7177 15.3105 16.5146 15.5136C16.4125 15.6157 16.2791 15.6657 16.1458 15.6657C16.0125 15.6657 15.8791 15.6147 15.7771 15.5136L12.5 12.2365L9.22288 15.5136C9.1208 15.6157 8.98747 15.6657 8.85413 15.6657C8.7208 15.6657 8.58747 15.6147 8.48538 15.5136C8.28226 15.3105 8.28226 14.9803 8.48538 14.7772L11.7625 11.5001L8.48538 8.223C8.28226 8.01987 8.28226 7.68966 8.48538 7.48654C8.68851 7.28341 9.01872 7.28341 9.22184 7.48654L12.4989 10.7636L15.776 7.48654C15.9791 7.28341 16.3093 7.28341 16.5125 7.48654C16.7156 7.68966 16.7156 8.01987 16.5125 8.223H16.5146Z",
            fill: "white"
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_hamburger_brand",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
          className: "cs_site_branding",
          to: "/",
          href: "/",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
            src: customize === null || customize === void 0 || (_customize$general3 = customize.general) === null || _customize$general3 === void 0 ? void 0 : _customize$general3.site_logo_light,
            alt: customize === null || customize === void 0 || (_customize$general4 = customize.general) === null || _customize$general4 === void 0 ? void 0 : _customize$general4.site_name
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("nav", {
        className: "cs_hamburger_menu cs_white_color",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
          className: "cs_nav_list cs_primary_font cs_light",
          children: menus.map(function (menuItem) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
              setMobileToggle: setMobileToggle,
              item: menuItem
            }, menuItem.id);
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "cs_hamburger_footer",
        children: [(customize === null || customize === void 0 || (_customize$contact = customize.contact) === null || _customize$contact === void 0 ? void 0 : _customize$contact.contact_phone_number) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("h3", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
            href: "tel:".concat(customize === null || customize === void 0 || (_customize$contact2 = customize.contact) === null || _customize$contact2 === void 0 ? void 0 : _customize$contact2.contact_phone_number),
            children: customize === null || customize === void 0 || (_customize$contact3 = customize.contact) === null || _customize$contact3 === void 0 ? void 0 : _customize$contact3.contact_phone_number
          })
        }), (customize === null || customize === void 0 || (_customize$contact4 = customize.contact) === null || _customize$contact4 === void 0 ? void 0 : _customize$contact4.contact_email) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
          className: "mb-0",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
            href: "mailto:".concat(customize === null || customize === void 0 || (_customize$contact5 = customize.contact) === null || _customize$contact5 === void 0 ? void 0 : _customize$contact5.contact_email),
            children: customize === null || customize === void 0 || (_customize$contact6 = customize.contact) === null || _customize$contact6 === void 0 ? void 0 : _customize$contact6.contact_email
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/Header4.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/Header4.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header4)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _GlobalSearch__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./GlobalSearch */ "./resources/js/Frontend/Components/Header/GlobalSearch.jsx");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }












function Header4() {
  var _customize$contact, _customize$contact2, _customize$contact3, _customize$contact4, _customize$contact5, _customize$contact6, _customize$contact7, _customize$contact8, _customize$social_lin, _customize$general, _customize$general2, _auth$user, _auth$user2, _auth$user3;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var currentLangPageInfo = pageInfo[currentLang];
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState6 = _slicedToArray(_useState5, 2),
    isSticky = _useState6[0],
    setIsSticky = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    profileDropdownOpen = _useState8[0],
    setProfileDropdownOpen = _useState8[1];
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    showAlert("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Logout"), "!"), function () {
      router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("header", {
      className: "cs_site_header cs_style_1 cs_color_1 cs_primary_bg cs_sticky_header cs_size_md".concat(isSticky ? " cs_sticky_active" : ""),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_top_header cs_accent_bg",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "cs_top_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_top_header_left",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                className: "cs_header_contact_list cs_mp0",
                children: [(customize === null || customize === void 0 || (_customize$contact = customize.contact) === null || _customize$contact === void 0 ? void 0 : _customize$contact.contact_email) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("li", {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_9__.Icon, {
                      icon: "lucide:mail",
                      width: "18",
                      height: "18"
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                    href: "mailto:".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])(customize === null || customize === void 0 || (_customize$contact2 = customize.contact) === null || _customize$contact2 === void 0 ? void 0 : _customize$contact2.contact_email)),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])(customize === null || customize === void 0 || (_customize$contact3 = customize.contact) === null || _customize$contact3 === void 0 ? void 0 : _customize$contact3.contact_email)
                  })]
                }), (customize === null || customize === void 0 || (_customize$contact4 = customize.contact) === null || _customize$contact4 === void 0 ? void 0 : _customize$contact4.contact_phone_number) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("li", {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("svg", {
                      width: 16,
                      height: 16,
                      viewBox: "0 0 16 16",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                        d: "M8 6.65367C6.162 6.65367 4.66667 8.15108 4.66667 9.99164C4.66667 11.8322 6.162 13.3296 8 13.3296C9.838 13.3296 11.3333 11.8322 11.3333 9.99164C11.3333 8.15108 9.838 6.65367 8 6.65367ZM8 11.9944C6.89733 11.9944 6 11.0958 6 9.99164C6 8.88744 6.89733 7.98886 8 7.98886C9.10267 7.98886 10 8.88744 10 9.99164C10 11.0958 9.10267 11.9944 8 11.9944ZM13.764 7.29456C15.0173 7.16037 16 6.10758 16 4.81845C16 3.8738 15.624 2.97589 14.938 2.28893C11.89 -0.763311 4.10867 -0.762644 1.062 2.28893C0.376 2.97589 0 3.8738 0 4.81778C0 6.10758 0.983333 7.16037 2.236 7.29456L0.862667 9.87348C0.298 10.9336 0 12.1286 0 13.3296C0 14.8023 1.196 16 2.66667 16H13.3333C14.804 16 16 14.8023 16 13.3296C16 12.1286 15.702 10.9336 15.1373 9.87348L13.764 7.29456ZM1.33333 4.81712C1.33333 4.22963 1.57067 3.66685 2.00467 3.23291C4.58267 0.652658 11.4187 0.652658 13.9953 3.23291C14.4287 3.66685 14.6673 4.22963 14.6667 4.81778C14.6667 5.46201 14.1433 5.98607 13.5 5.98607H13.044L12.526 5.12154C12.2493 4.6589 11.85 4.29773 11.3733 4.07809C10.62 3.73027 9.42333 3.31636 8 3.31636C6.57667 3.31636 5.38 3.73094 4.62733 4.07809C4.14933 4.29839 3.75067 4.6589 3.474 5.12154L2.956 5.98607H2.5C1.85667 5.98607 1.33333 5.46201 1.33333 4.81712ZM13.3333 14.6648H2.66667C1.93133 14.6648 1.33333 14.066 1.33333 13.3296C1.33333 12.3469 1.57733 11.3689 2.04 10.5024L3.91867 6.97478L4.61733 5.80783C4.756 5.57684 4.952 5.39792 5.186 5.29044C5.81733 4.9987 6.81867 4.65088 8.00067 4.65088C9.18267 4.65088 10.1833 4.9987 10.816 5.29044C11.0493 5.39792 11.2453 5.57684 11.384 5.80783L12.0827 6.97478L13.9613 10.5024C14.4233 11.3696 14.668 12.3476 14.668 13.3296C14.668 14.066 14.07 14.6648 13.3347 14.6648H13.3333Z",
                        fill: "currentColor"
                      })
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                    href: "tel:".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])(customize === null || customize === void 0 || (_customize$contact5 = customize.contact) === null || _customize$contact5 === void 0 ? void 0 : _customize$contact5.contact_phone_number)),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])(customize === null || customize === void 0 || (_customize$contact6 = customize.contact) === null || _customize$contact6 === void 0 ? void 0 : _customize$contact6.contact_phone_number)
                  })]
                }), (customize === null || customize === void 0 || (_customize$contact7 = customize.contact) === null || _customize$contact7 === void 0 ? void 0 : _customize$contact7.contact_address) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("li", {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_9__.Icon, {
                      icon: "lucide:map-pin",
                      width: "18",
                      height: "18"
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                    className: "mb-0",
                    dangerouslySetInnerHTML: {
                      __html: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])(customize === null || customize === void 0 || (_customize$contact8 = customize.contact) === null || _customize$contact8 === void 0 ? void 0 : _customize$contact8.contact_address)
                    }
                  })]
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_top_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                className: "cs_header_social",
                children: customize === null || customize === void 0 || (_customize$social_lin = customize.social_links) === null || _customize$social_lin === void 0 || (_customize$social_lin = _customize$social_lin.social_list) === null || _customize$social_lin === void 0 ? void 0 : _customize$social_lin.map(function (item, index) {
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                    href: item === null || item === void 0 ? void 0 : item.social_url,
                    target: "_blank",
                    children: item === null || item === void 0 ? void 0 : item.social_title
                  }, index);
                })
              })
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_left",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_light,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_center",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_nav",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("nav", {
                  className: "cs_nav_list_wrap".concat(mobileToggle ? " cs_active" : ""),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
                    className: "cs_nav_list",
                    children: menus.map(function (menuItem) {
                      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        setMobileToggle: setMobileToggle,
                        item: menuItem
                      }, menuItem.id);
                    })
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                  className: "cs_menu_toggle".concat(mobileToggle ? " cs_toggle_active" : ""),
                  onClick: function onClick() {
                    return setMobileToggle(!mobileToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_toolbox",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_GlobalSearch__WEBPACK_IMPORTED_MODULE_7__["default"], {}), auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_9__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_10___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Login")
                  })
                }), (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                    children: cartItemCount
                  })]
                }), Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("button", {
                  className: "cs_hamburger_btn cs_hamburger_info_btn ",
                  onClick: function onClick() {
                    return setSideHeaderToggle(!sideHeaderToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                    className: "cs_hamburger_btn_in",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})]
                  })
                })]
              })
            })]
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_6__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/Header5.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/Header5.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header5)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _GlobalSearch__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./GlobalSearch */ "./resources/js/Frontend/Components/Header/GlobalSearch.jsx");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }












function Header5() {
  var _customize$general, _customize$general2, _customize$contact, _customize$contact2, _customize$contact3, _customize$contact4, _customize$contact5, _customize$contact6, _auth$user, _auth$user2, _auth$user3;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var currentLangPageInfo = pageInfo[currentLang];
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState6 = _slicedToArray(_useState5, 2),
    isSticky = _useState6[0],
    setIsSticky = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    profileDropdownOpen = _useState8[0],
    setProfileDropdownOpen = _useState8[1];
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    showAlert("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Logout"), "!"), function () {
      _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("header", {
      className: "cs_site_header cs_style_1 cs_primary_color cs_with_border cs_sticky_header cs_size_md".concat(isSticky ? " cs_sticky_active" : ""),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "container-fluid",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "cs_main_header_left",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_dark,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_nav",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("nav", {
                  className: "cs_nav_list_wrap".concat(mobileToggle ? " cs_active" : ""),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
                    className: "cs_nav_list",
                    children: menus.map(function (menuItem) {
                      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        setMobileToggle: setMobileToggle,
                        item: menuItem
                      }, menuItem.id);
                    })
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                  className: "cs_menu_toggle".concat(mobileToggle ? " cs_toggle_active" : ""),
                  onClick: function onClick() {
                    return setMobileToggle(!mobileToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_toolbox cs_has_main_nav",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                  className: "cs_header_contact_list cs_mp0",
                  children: [(customize === null || customize === void 0 || (_customize$contact = customize.contact) === null || _customize$contact === void 0 ? void 0 : _customize$contact.contact_email) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("li", {
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("i", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_9__.Icon, {
                        icon: "lucide:mail",
                        width: "18",
                        height: "18"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                      href: "mailto:".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])(customize === null || customize === void 0 || (_customize$contact2 = customize.contact) === null || _customize$contact2 === void 0 ? void 0 : _customize$contact2.contact_email)),
                      children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])(customize === null || customize === void 0 || (_customize$contact3 = customize.contact) === null || _customize$contact3 === void 0 ? void 0 : _customize$contact3.contact_email)
                    })]
                  }), (customize === null || customize === void 0 || (_customize$contact4 = customize.contact) === null || _customize$contact4 === void 0 ? void 0 : _customize$contact4.contact_phone_number) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("li", {
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("i", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("svg", {
                        width: 16,
                        height: 16,
                        viewBox: "0 0 16 16",
                        fill: "none",
                        xmlns: "http://www.w3.org/2000/svg",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                          d: "M8 6.65367C6.162 6.65367 4.66667 8.15108 4.66667 9.99164C4.66667 11.8322 6.162 13.3296 8 13.3296C9.838 13.3296 11.3333 11.8322 11.3333 9.99164C11.3333 8.15108 9.838 6.65367 8 6.65367ZM8 11.9944C6.89733 11.9944 6 11.0958 6 9.99164C6 8.88744 6.89733 7.98886 8 7.98886C9.10267 7.98886 10 8.88744 10 9.99164C10 11.0958 9.10267 11.9944 8 11.9944ZM13.764 7.29456C15.0173 7.16037 16 6.10758 16 4.81845C16 3.8738 15.624 2.97589 14.938 2.28893C11.89 -0.763311 4.10867 -0.762644 1.062 2.28893C0.376 2.97589 0 3.8738 0 4.81778C0 6.10758 0.983333 7.16037 2.236 7.29456L0.862667 9.87348C0.298 10.9336 0 12.1286 0 13.3296C0 14.8023 1.196 16 2.66667 16H13.3333C14.804 16 16 14.8023 16 13.3296C16 12.1286 15.702 10.9336 15.1373 9.87348L13.764 7.29456ZM1.33333 4.81712C1.33333 4.22963 1.57067 3.66685 2.00467 3.23291C4.58267 0.652658 11.4187 0.652658 13.9953 3.23291C14.4287 3.66685 14.6673 4.22963 14.6667 4.81778C14.6667 5.46201 14.1433 5.98607 13.5 5.98607H13.044L12.526 5.12154C12.2493 4.6589 11.85 4.29773 11.3733 4.07809C10.62 3.73027 9.42333 3.31636 8 3.31636C6.57667 3.31636 5.38 3.73094 4.62733 4.07809C4.14933 4.29839 3.75067 4.6589 3.474 5.12154L2.956 5.98607H2.5C1.85667 5.98607 1.33333 5.46201 1.33333 4.81712ZM13.3333 14.6648H2.66667C1.93133 14.6648 1.33333 14.066 1.33333 13.3296C1.33333 12.3469 1.57733 11.3689 2.04 10.5024L3.91867 6.97478L4.61733 5.80783C4.756 5.57684 4.952 5.39792 5.186 5.29044C5.81733 4.9987 6.81867 4.65088 8.00067 4.65088C9.18267 4.65088 10.1833 4.9987 10.816 5.29044C11.0493 5.39792 11.2453 5.57684 11.384 5.80783L12.0827 6.97478L13.9613 10.5024C14.4233 11.3696 14.668 12.3476 14.668 13.3296C14.668 14.066 14.07 14.6648 13.3347 14.6648H13.3333Z",
                          fill: "currentColor"
                        })
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                      href: "tel:".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])(customize === null || customize === void 0 || (_customize$contact5 = customize.contact) === null || _customize$contact5 === void 0 ? void 0 : _customize$contact5.contact_phone_number)),
                      children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])(customize === null || customize === void 0 || (_customize$contact6 = customize.contact) === null || _customize$contact6 === void 0 ? void 0 : _customize$contact6.contact_phone_number)
                    })]
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_GlobalSearch__WEBPACK_IMPORTED_MODULE_7__["default"], {}), auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_9__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_10___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_5__["default"])("Login")
                  })
                }), (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                    children: cartItemCount
                  })]
                }), Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("button", {
                  className: "cs_hamburger_btn cs_hamburger_info_btn ",
                  onClick: function onClick() {
                    return setSideHeaderToggle(!sideHeaderToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                    className: "cs_hamburger_btn_in",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})]
                  })
                })]
              })
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_6__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/Header6.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/Header6.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header6)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _GlobalSearch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./GlobalSearch */ "./resources/js/Frontend/Components/Header/GlobalSearch.jsx");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }












function Header6() {
  var _customize$general, _customize$general2, _auth$user, _auth$user2, _auth$user3;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var currentLangPageInfo = pageInfo[currentLang];
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState6 = _slicedToArray(_useState5, 2),
    isSticky = _useState6[0],
    setIsSticky = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    profileDropdownOpen = _useState8[0],
    setProfileDropdownOpen = _useState8[1];
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    showAlert("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Logout"), "!"), function () {
      _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("header", {
      className: "cs_site_header cs_style_1 cs_color_1 cs_primary_bg cs_sticky_header cs_size_md".concat(isSticky ? " cs_sticky_active" : ""),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_left",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_light,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_center",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_nav",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("nav", {
                  className: "cs_nav_list_wrap".concat(mobileToggle ? " cs_active" : ""),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
                    className: "cs_nav_list",
                    children: menus.map(function (menuItem) {
                      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        setMobileToggle: setMobileToggle,
                        item: menuItem
                      }, menuItem.id);
                    })
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                  className: "cs_menu_toggle".concat(mobileToggle ? " cs_toggle_active" : ""),
                  onClick: function onClick() {
                    return setMobileToggle(!mobileToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_toolbox",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_GlobalSearch__WEBPACK_IMPORTED_MODULE_6__["default"], {}), auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_10__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_8___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Login")
                  })
                }), (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                    children: cartItemCount
                  })]
                }), Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_7__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("button", {
                  className: "cs_hamburger_btn cs_hamburger_info_btn ",
                  onClick: function onClick() {
                    return setSideHeaderToggle(!sideHeaderToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                    className: "cs_hamburger_btn_in",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})]
                  })
                })]
              })
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/Header7.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/Header7.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header7)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _GlobalSearch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./GlobalSearch */ "./resources/js/Frontend/Components/Header/GlobalSearch.jsx");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }












function Header7() {
  var _customize$general, _customize$general2, _auth$user, _auth$user2, _auth$user3;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var currentLangPageInfo = pageInfo[currentLang];
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState6 = _slicedToArray(_useState5, 2),
    isSticky = _useState6[0],
    setIsSticky = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    profileDropdownOpen = _useState8[0],
    setProfileDropdownOpen = _useState8[1];
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    showAlert("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Logout"), "!"), function () {
      _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("header", {
      className: "cs_site_header cs_style_1 cs_primary_color cs_sticky_header cs_white_bg".concat(isSticky ? " cs_sticky_active" : ""),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_left",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_dark,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_center",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_nav",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("nav", {
                  className: "cs_nav_list_wrap".concat(mobileToggle ? " cs_active" : ""),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
                    className: "cs_nav_list",
                    children: menus.map(function (menuItem) {
                      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        setMobileToggle: setMobileToggle,
                        item: menuItem
                      }, menuItem.id);
                    })
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                  className: "cs_menu_toggle".concat(mobileToggle ? " cs_toggle_active" : ""),
                  onClick: function onClick() {
                    return setMobileToggle(!mobileToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_toolbox",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_GlobalSearch__WEBPACK_IMPORTED_MODULE_6__["default"], {}), auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_10__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_8___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Login")
                  })
                }), (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                    children: cartItemCount
                  })]
                }), Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_7__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("button", {
                  className: "cs_hamburger_btn cs_hamburger_info_btn ",
                  onClick: function onClick() {
                    return setSideHeaderToggle(!sideHeaderToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                    className: "cs_hamburger_btn_in",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})]
                  })
                })]
              })
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/Header8.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/Header8.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header8)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }












function Header8() {
  var _customize$general, _customize$general2, _auth$user, _auth$user2, _auth$user3;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var currentLangPageInfo = pageInfo[currentLang];
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState6 = _slicedToArray(_useState5, 2),
    isSticky = _useState6[0],
    setIsSticky = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    profileDropdownOpen = _useState8[0],
    setProfileDropdownOpen = _useState8[1];
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    showAlert("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Logout"), "!"), function () {
      _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("header", {
      className: "cs_site_header cs_style_1 cs_primary_color cs_sticky_header cs_white_bg".concat(isSticky ? " cs_sticky_active" : ""),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "container-fluid",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "cs_main_header_left",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_dark,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_nav",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("nav", {
                  className: "cs_nav_list_wrap".concat(mobileToggle ? " cs_active" : ""),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
                    className: "cs_nav_list",
                    children: menus.map(function (menuItem) {
                      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        setMobileToggle: setMobileToggle,
                        item: menuItem
                      }, menuItem.id);
                    })
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                  className: "cs_menu_toggle".concat(mobileToggle ? " cs_toggle_active" : ""),
                  onClick: function onClick() {
                    return setMobileToggle(!mobileToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {})
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cs_main_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "cs_toolbox",
                children: [Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_6__["default"], {}), auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_9__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_8___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Login")
                  })
                }), (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
                    children: cartItemCount
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_7__["default"], {
                  href: currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.header_action_button_url,
                  btnText: currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.header_action_button_text,
                  btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color"
                })]
              })
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/Header9.jsx":
/*!*************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/Header9.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header9)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }











function Header9() {
  var _customize$general, _customize$general2, _auth$user, _auth$user2, _auth$user3, _customize$general3, _customize$general4, _customize$contact, _customize$contact2, _customize$contact3, _customize$contact4, _customize$contact5, _customize$contact6;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var currentLangPageInfo = pageInfo[currentLang];
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState6 = _slicedToArray(_useState5, 2),
    hamburgerToggle = _useState6[0],
    setHamburgerToggle = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState8 = _slicedToArray(_useState7, 2),
    isSticky = _useState8[0],
    setIsSticky = _useState8[1];
  var _useState9 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState10 = _slicedToArray(_useState9, 2),
    profileDropdownOpen = _useState10[0],
    setProfileDropdownOpen = _useState10[1];
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    showAlert("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Logout"), "!"), function () {
      _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("header", {
      className: "cs_site_header cs_style_2 cs_color_1 cs_sticky_header".concat(isSticky ? " cs_sticky_active" : ""),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
          className: "container-fluid",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
              className: "cs_main_header_left",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_light,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
              className: "cs_main_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
                className: "cs_toolbox",
                children: [auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_7__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_8___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_9__["default"])("Login")
                  })
                }), (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {
                    children: cartItemCount
                  })]
                }), Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_6__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("button", {
                  className: "cs_hamburger_btn cs_hamburger_menu_btn",
                  onClick: function onClick() {
                    return setHamburgerToggle(!hamburgerToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("span", {
                    className: "cs_hamburger_btn_in",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {})]
                  })
                })]
              })
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: "cs_hamburger_overlay".concat(hamburgerToggle ? " active" : ""),
      onClick: function onClick() {
        return setHamburgerToggle(!hamburgerToggle);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
      className: "cs_hamburger_header cs_ternary_color cs_start_right".concat(hamburgerToggle ? " active" : ""),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("button", {
        className: "cs_close_hamburger",
        onClick: function onClick() {
          return setHamburgerToggle(!hamburgerToggle);
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("svg", {
          width: "25",
          height: "23",
          viewBox: "0 0 25 23",
          fill: "none",
          xmlns: "http://www.w3.org/2000/svg",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("path", {
            d: "M24.4427 9.15216L20.5229 2.38133C19.6875 0.938623 18.1333 0.041748 16.4656 0.041748H8.60622C6.93955 0.041748 5.38538 0.937581 4.54893 2.38133L0.630176 9.15216C-0.209408 10.6011 -0.209408 12.4001 0.630176 13.849L4.54997 20.6199C5.38643 22.0626 6.94059 22.9595 8.60726 22.9595H16.4666C18.1343 22.9595 19.6885 22.0636 20.5239 20.6199L24.4437 13.849C25.2833 12.4001 25.2823 10.6011 24.4427 9.15216ZM23.5416 13.3272L19.6218 20.098C18.9729 21.2199 17.7635 21.9178 16.4666 21.9178H8.60726C7.31143 21.9178 6.10205 21.2209 5.45205 20.098L1.53226 13.3272C0.880176 12.2001 0.880176 10.8011 1.53226 9.67404L5.45205 2.90321C6.10205 1.78133 7.31143 1.08341 8.60726 1.08341H16.4666C17.7635 1.08341 18.9729 1.78029 19.6218 2.90321L23.5416 9.67404C24.1937 10.8011 24.1937 12.2001 23.5416 13.3272ZM16.5146 8.223L13.2375 11.5001L16.5146 14.7772C16.7177 14.9803 16.7177 15.3105 16.5146 15.5136C16.4125 15.6157 16.2791 15.6657 16.1458 15.6657C16.0125 15.6657 15.8791 15.6147 15.7771 15.5136L12.5 12.2365L9.22288 15.5136C9.1208 15.6157 8.98747 15.6657 8.85413 15.6657C8.7208 15.6657 8.58747 15.6147 8.48538 15.5136C8.28226 15.3105 8.28226 14.9803 8.48538 14.7772L11.7625 11.5001L8.48538 8.223C8.28226 8.01987 8.28226 7.68966 8.48538 7.48654C8.68851 7.28341 9.01872 7.28341 9.22184 7.48654L12.4989 10.7636L15.776 7.48654C15.9791 7.28341 16.3093 7.28341 16.5125 7.48654C16.7156 7.68966 16.7156 8.01987 16.5125 8.223H16.5146Z",
            fill: "white"
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
        className: "cs_hamburger_brand",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
          className: "cs_site_branding",
          to: "/",
          href: "/",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("img", {
            src: customize === null || customize === void 0 || (_customize$general3 = customize.general) === null || _customize$general3 === void 0 ? void 0 : _customize$general3.site_logo_light,
            alt: customize === null || customize === void 0 || (_customize$general4 = customize.general) === null || _customize$general4 === void 0 ? void 0 : _customize$general4.site_name
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("nav", {
        className: "cs_hamburger_menu cs_white_color",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("ul", {
          className: "cs_nav_list cs_primary_font cs_light",
          children: menus.map(function (menuItem) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
              setMobileToggle: setMobileToggle,
              item: menuItem
            }, menuItem.id);
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
        className: "cs_hamburger_footer",
        children: [(customize === null || customize === void 0 || (_customize$contact = customize.contact) === null || _customize$contact === void 0 ? void 0 : _customize$contact.contact_phone_number) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("h3", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("a", {
            href: "tel:".concat(customize === null || customize === void 0 || (_customize$contact2 = customize.contact) === null || _customize$contact2 === void 0 ? void 0 : _customize$contact2.contact_phone_number),
            children: customize === null || customize === void 0 || (_customize$contact3 = customize.contact) === null || _customize$contact3 === void 0 ? void 0 : _customize$contact3.contact_phone_number
          })
        }), (customize === null || customize === void 0 || (_customize$contact4 = customize.contact) === null || _customize$contact4 === void 0 ? void 0 : _customize$contact4.contact_email) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("p", {
          className: "mb-0",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("a", {
            href: "mailto:".concat(customize === null || customize === void 0 || (_customize$contact5 = customize.contact) === null || _customize$contact5 === void 0 ? void 0 : _customize$contact5.contact_email),
            children: customize === null || customize === void 0 || (_customize$contact6 = customize.contact) === null || _customize$contact6 === void 0 ? void 0 : _customize$contact6.contact_email
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/LanguageDropdown.js":
/*!*********************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/LanguageDropdown.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LanguageDropdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }






function LanguageDropdown() {
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector.currentLang;
  var lang = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_3__.usePage)().props.lang;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    dropdownOpen = _useState2[0],
    setDropdownOpen = _useState2[1];
  var dropdownRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var handleToggle = function handleToggle() {
    return setDropdownOpen(!dropdownOpen);
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (dropdownRef.current && !dropdownRef.current.contains(event.target)) {
        setDropdownOpen(false);
      }
    };
    document.addEventListener("mousedown", handleClickOutside);
    return function () {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "cs_dropdown_wrap",
    ref: dropdownRef,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("button", {
      className: "cs_dropdown_toggle_btn".concat(dropdownOpen ? " active" : ""),
      onClick: handleToggle,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "iconoir:language",
        width: "24",
        height: "24"
      })
    }), dropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("ul", {
      className: "cs_dropdown_list active cs_mp0",
      children: Object.entries(lang.languages).map(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          code = _ref2[0],
          lang = _ref2[1];
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("li", {
          className: code === currentLang ? "active" : "",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("a", {
            href: route("change.lang", code),
            children: lang.name
          })
        }, code);
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/SideHeader.js":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/SideHeader.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SideHeader)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Widget/SocialWidget */ "./resources/js/Frontend/Components/Widget/SocialWidget.jsx");
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _Widget_Newsletter__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Widget/Newsletter */ "./resources/js/Frontend/Components/Widget/Newsletter.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);







function SideHeader(_ref) {
  var _customize$general, _customize$sidebar, _customize$contact, _customize$contact2, _customize$contact3, _customize$contact4, _customize$contact5, _customize$contact6, _customize$contact7, _customize$contact8, _customize$sidebar2;
  var sideHeaderToggle = _ref.sideHeaderToggle,
    setSideHeaderToggle = _ref.setSideHeaderToggle,
    customize = _ref.customize;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "cs_side_header".concat(sideHeaderToggle ? " active" : ""),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("button", {
      className: "cs_close",
      onClick: function onClick() {
        return setSideHeaderToggle(!sideHeaderToggle);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "cs_side_header_overlay",
      onClick: function onClick() {
        return setSideHeaderToggle(!sideHeaderToggle);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "cs_side_header_in",
      children: [Boolean(Number(customize.sidebar.is_show_logo)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
        className: "cs_site_branding",
        to: "/",
        href: "/",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("img", {
          src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_dark,
          alt: "Logo"
        })
      }), Boolean(Number(customize === null || customize === void 0 || (_customize$sidebar = customize.sidebar) === null || _customize$sidebar === void 0 ? void 0 : _customize$sidebar.is_show_contact_info)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "cs_side_header_box",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h2", {
            className: "cs_side_header_heading",
            children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_3__["default"])("Do you have a project in your mind? Keep connect us.")
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "cs_side_header_box",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
            className: "cs_side_header_title cs_primary_color",
            children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_3__["default"])("Contact Us")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("ul", {
            className: "cs_side_header_contact_info cs_mp0",
            children: [(customize === null || customize === void 0 || (_customize$contact = customize.contact) === null || _customize$contact === void 0 ? void 0 : _customize$contact.contact_phone_number) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("li", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("i", {
                className: "cs_center",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_4__.Icon, {
                  icon: "lucide:phone",
                  width: "20",
                  height: "20"
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                  href: "tel:".concat(customize === null || customize === void 0 || (_customize$contact2 = customize.contact) === null || _customize$contact2 === void 0 ? void 0 : _customize$contact2.contact_phone_number),
                  children: customize === null || customize === void 0 || (_customize$contact3 = customize.contact) === null || _customize$contact3 === void 0 ? void 0 : _customize$contact3.contact_phone_number
                })
              })]
            }), (customize === null || customize === void 0 || (_customize$contact4 = customize.contact) === null || _customize$contact4 === void 0 ? void 0 : _customize$contact4.contact_email) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("li", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("i", {
                className: "cs_center",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_4__.Icon, {
                  icon: "lucide:mail",
                  width: "20",
                  height: "20"
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                  href: "mailto:".concat(customize === null || customize === void 0 || (_customize$contact5 = customize.contact) === null || _customize$contact5 === void 0 ? void 0 : _customize$contact5.contact_email),
                  children: customize === null || customize === void 0 || (_customize$contact6 = customize.contact) === null || _customize$contact6 === void 0 ? void 0 : _customize$contact6.contact_email
                })
              })]
            }), (customize === null || customize === void 0 || (_customize$contact7 = customize.contact) === null || _customize$contact7 === void 0 ? void 0 : _customize$contact7.contact_address) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("li", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("i", {
                className: "cs_center",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_4__.Icon, {
                  icon: "lucide:map-pin",
                  width: "20",
                  height: "20"
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                dangerouslySetInnerHTML: {
                  __html: customize === null || customize === void 0 || (_customize$contact8 = customize.contact) === null || _customize$contact8 === void 0 ? void 0 : _customize$contact8.contact_address
                }
              })]
            })]
          })]
        })]
      }), Boolean(Number(customize === null || customize === void 0 || (_customize$sidebar2 = customize.sidebar) === null || _customize$sidebar2 === void 0 ? void 0 : _customize$sidebar2.is_show_subscribe)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "cs_side_header_box",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Widget_Newsletter__WEBPACK_IMPORTED_MODULE_5__["default"], {
          placeholder: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_3__["default"])("Email address"),
          title: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_3__["default"])("Get early access"),
          variant: "cs_type_1",
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_primary_bg",
          titleClass: "cs_side_header_title cs_primary_color"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "cs_newsletter_text",
          style: {
            marginTop: "15px"
          },
          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_3__["default"])("Stay updated with our latest news and offers.")
        })]
      }), Boolean(Number(customize.sidebar.is_show_social_media)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "cs_side_header_box",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
          className: "cs_side_header_title cs_primary_color",
          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_3__["default"])("Follow Us")
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_2__["default"], {})]
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Header/index.jsx":
/*!***********************************************************!*\
  !*** ./resources/js/Frontend/Components/Header/index.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/organizeMenusIntoHierarchy */ "./resources/js/utils/organizeMenusIntoHierarchy.js");
/* harmony import */ var _Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/Admin/Components/Header/MenuItem */ "./resources/js/Admin/Components/Header/MenuItem.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _SideHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SideHeader */ "./resources/js/Frontend/Components/Header/SideHeader.js");
/* harmony import */ var _GlobalSearch__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./GlobalSearch */ "./resources/js/Frontend/Components/Header/GlobalSearch.jsx");
/* harmony import */ var _LanguageDropdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./LanguageDropdown */ "./resources/js/Frontend/Components/Header/LanguageDropdown.js");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _Admin_Utils_SweetAlert__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/Admin/Utils/SweetAlert */ "./resources/js/Admin/Utils/SweetAlert.js");
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }













function Header(_ref) {
  var _customize$general, _customize$general2, _auth$user, _auth$user2, _auth$user3;
  var cart = _ref.cart;
  var cart_slug = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props.cart_slug;
  var _useSelector = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.carts;
    }),
    carts = _useSelector.carts;
  var _usePage$props = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.usePage)().props,
    lang = _usePage$props.lang,
    auth = _usePage$props.auth;
  var _useSelector2 = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
      return state.pages;
    }),
    currentLang = _useSelector2.currentLang,
    pageInfo = _useSelector2.pageInfo;
  var currentLangPageInfo = pageInfo[currentLang];
  var customize = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(function (state) {
    return state.customize;
  });
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    sideHeaderToggle = _useState2[0],
    setSideHeaderToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    mobileToggle = _useState4[0],
    setMobileToggle = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),
    _useState6 = _slicedToArray(_useState5, 2),
    isSticky = _useState6[0],
    setIsSticky = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    profileDropdownOpen = _useState8[0],
    setProfileDropdownOpen = _useState8[1];
  var currentLanguage = currentLang !== null && currentLang !== void 0 ? currentLang : lang.default_lang;
  var mainMenus = localStorage.getItem("main_menu") ? JSON.parse(localStorage.getItem("main_menu")) : [];
  var menus = mainMenus ? (0,_utils_organizeMenusIntoHierarchy__WEBPACK_IMPORTED_MODULE_2__["default"])(mainMenus[currentLanguage]) : [];
  var cartItemCount = (carts === null || carts === void 0 ? void 0 : carts.reduce(function (total, item) {
    return total + (item.quantity || 1);
  }, 0)) || 0;
  var handleProfileDropdownToggle = function handleProfileDropdownToggle() {
    return setProfileDropdownOpen(!profileDropdownOpen);
  };

  // handle logout
  var handleLogout = function handleLogout() {
    (0,_Admin_Utils_SweetAlert__WEBPACK_IMPORTED_MODULE_9__.showAlert)("".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Are you sure"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("You want to logout this session"), "?"), "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Logout"), "!"), function () {
      _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route("logout"));
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("scroll", function () {
      if (window.scrollY > 0) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handleClickOutside = function handleClickOutside(event) {
      if (!event.target.closest(".cs_dropdown_wrap")) {
        setProfileDropdownOpen(false);
      }
    };
    if (profileDropdownOpen) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }
    return function () {
      return document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [profileDropdownOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("header", {
      className: "cs_site_header cs_style_1 cs_primary_color cs_sticky_header cs_white_bg".concat(isSticky ? " cs_sticky_active" : ""),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
        className: "cs_main_header",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
          className: "container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
            className: "cs_main_header_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
              className: "cs_main_header_left",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                className: "cs_site_branding",
                to: "/",
                href: "/",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("img", {
                  src: customize === null || customize === void 0 || (_customize$general = customize.general) === null || _customize$general === void 0 ? void 0 : _customize$general.site_logo_dark,
                  alt: customize === null || customize === void 0 || (_customize$general2 = customize.general) === null || _customize$general2 === void 0 ? void 0 : _customize$general2.site_name
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
                className: "cs_nav",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("nav", {
                  className: "cs_nav_list_wrap".concat(mobileToggle ? " cs_active" : ""),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("ul", {
                    className: "cs_nav_list",
                    children: menus.map(function (menuItem) {
                      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_Admin_Components_Header_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        setMobileToggle: setMobileToggle,
                        item: menuItem
                      }, menuItem.id);
                    })
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {
                  className: "cs_menu_toggle".concat(mobileToggle ? " cs_toggle_active" : ""),
                  onClick: function onClick() {
                    return setMobileToggle(!mobileToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {})
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
              className: "cs_main_header_right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
                className: "cs_toolbox",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_GlobalSearch__WEBPACK_IMPORTED_MODULE_6__["default"], {}), auth !== null && auth !== void 0 && auth.is_loggedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
                  className: "cs_dropdown_wrap",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
                    onClick: handleProfileDropdownToggle,
                    className: "cs_header_user_btn ".concat(profileDropdownOpen ? "active" : ""),
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_11__.Icon, {
                      icon: "lucide:circle-user",
                      width: "20",
                      height: "20"
                    })
                  }), profileDropdownOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
                    className: "cs_header_user_dropdown",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
                      className: "cs_header_user_info",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("img", {
                        src: gravatar_url__WEBPACK_IMPORTED_MODULE_8___default()(auth === null || auth === void 0 || (_auth$user = auth.user) === null || _auth$user === void 0 ? void 0 : _auth$user.email),
                        alt: ""
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("h4", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user2 = auth.user) === null || _auth$user2 === void 0 ? void 0 : _auth$user2.name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("p", {
                        className: "",
                        children: auth === null || auth === void 0 || (_auth$user3 = auth.user) === null || _auth$user3 === void 0 ? void 0 : _auth$user3.email
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("ul", {
                      className: "cs_header_user_list cs_mp0",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.dashboard"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Dashboard")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.orders"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("My Orders")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                          href: route("user.profile.edit"),
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Profile")
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("li", {
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("a", {
                          href: "#",
                          onClick: handleLogout,
                          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Log out")
                        })
                      })]
                    })]
                  })]
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
                  className: "cs_header_user_btn active d-flex",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                    href: route("login.create"),
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_10__["default"])("Login")
                  })
                }), (cart || (currentLangPageInfo === null || currentLangPageInfo === void 0 ? void 0 : currentLangPageInfo.is_show_shopping_cart)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.Link, {
                  href: route("pages.show", {
                    slug: cart_slug
                  }),
                  className: "cart-counter",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("svg", {
                    width: 22,
                    height: 22,
                    viewBox: "0 0 22 22",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("g", {
                      clipPath: "url(#clip0_293_142)",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("path", {
                        d: "M19.25 5.5H16.5C16.5 4.04131 15.9205 2.64236 14.8891 1.61091C13.8576 0.579463 12.4587 0 11 0C9.54131 0 8.14236 0.579463 7.11091 1.61091C6.07946 2.64236 5.5 4.04131 5.5 5.5H2.75C2.02065 5.5 1.32118 5.78973 0.805456 6.30546C0.289731 6.82118 0 7.52065 0 8.25L0 17.4167C0.00145554 18.6318 0.484808 19.7967 1.34403 20.656C2.20326 21.5152 3.3682 21.9985 4.58333 22H17.4167C18.6318 21.9985 19.7967 21.5152 20.656 20.656C21.5152 19.7967 21.9985 18.6318 22 17.4167V8.25C22 7.52065 21.7103 6.82118 21.1945 6.30546C20.6788 5.78973 19.9793 5.5 19.25 5.5ZM11 1.83333C11.9725 1.83333 12.9051 2.21964 13.5927 2.90728C14.2804 3.59491 14.6667 4.52754 14.6667 5.5H7.33333C7.33333 4.52754 7.71964 3.59491 8.40728 2.90728C9.09491 2.21964 10.0275 1.83333 11 1.83333ZM20.1667 17.4167C20.1667 18.146 19.8769 18.8455 19.3612 19.3612C18.8455 19.8769 18.146 20.1667 17.4167 20.1667H4.58333C3.85399 20.1667 3.15451 19.8769 2.63879 19.3612C2.12306 18.8455 1.83333 18.146 1.83333 17.4167V8.25C1.83333 8.00688 1.92991 7.77373 2.10182 7.60182C2.27373 7.42991 2.50688 7.33333 2.75 7.33333H5.5V9.16667C5.5 9.40978 5.59658 9.64294 5.76849 9.81485C5.94039 9.98676 6.17355 10.0833 6.41667 10.0833C6.65978 10.0833 6.89294 9.98676 7.06485 9.81485C7.23676 9.64294 7.33333 9.40978 7.33333 9.16667V7.33333H14.6667V9.16667C14.6667 9.40978 14.7632 9.64294 14.9352 9.81485C15.1071 9.98676 15.3402 10.0833 15.5833 10.0833C15.8264 10.0833 16.0596 9.98676 16.2315 9.81485C16.4034 9.64294 16.5 9.40978 16.5 9.16667V7.33333H19.25C19.4931 7.33333 19.7263 7.42991 19.8982 7.60182C20.0701 7.77373 20.1667 8.00688 20.1667 8.25V17.4167Z",
                        fill: "#121212"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("defs", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("clipPath", {
                        id: "clip0_293_142",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("rect", {
                          width: 22,
                          height: 22,
                          fill: "white"
                        })
                      })
                    })]
                  }), cartItemCount === 0 ? "" : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {
                    children: cartItemCount
                  })]
                }), Object.entries(lang.languages).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_LanguageDropdown__WEBPACK_IMPORTED_MODULE_7__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("button", {
                  className: "cs_hamburger_btn cs_hamburger_info_btn ",
                  onClick: function onClick() {
                    return setSideHeaderToggle(!sideHeaderToggle);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("span", {
                    className: "cs_hamburger_btn_in",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {})]
                  })
                })]
              })
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_SideHeader__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sideHeaderToggle: sideHeaderToggle,
      setSideHeaderToggle: setSideHeaderToggle,
      customize: customize
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero10.jsx":
/*!**********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero10.jsx ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero10)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }




function Hero10(_ref) {
  var data = _ref.data;
  var casestudy_list = data.casestudy_list;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    activeIndex = _useState2[0],
    setActiveIndex = _useState2[1];
  var handleMouseEnter = function handleMouseEnter(index) {
    setActiveIndex(index);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("section", {
    className: "cs_case_study_2_wrap cs_primary_bg position-relative",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "container-fluid cs_padding_120_120",
      children: casestudy_list === null || casestudy_list === void 0 ? void 0 : casestudy_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "cs_case_study cs_style_2 cs_hover_active ".concat(activeIndex === index ? "active" : ""),
          onMouseEnter: function onMouseEnter() {
            return handleMouseEnter(index);
          },
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "cs_case_study_in",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "cs_case_study_left",
              children: [item.casestudy_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h2", {
                className: "cs_case_study_number cs_fs_53 cs_white_color cs_normal mb-0",
                children: item.casestudy_number
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
                className: "cs_case_study_category cs_fs_18 cs_ternary_color cs_medium mb-0",
                dangerouslySetInnerHTML: {
                  __html: item.casestudy_category
                }
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "cs_case_study_center",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h1", {
                className: "cs_case_study_title cs_fs_53 cs_normal cs_white_color mb-0",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_1__["default"], {
                  href: item.casestudy_action_url,
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                    dangerouslySetInnerHTML: {
                      __html: item.casestudy_title
                    }
                  })
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "cs_case_study_right",
              children: (item.casestudy_action_url || item.casestudy_action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__["default"], {
                href: item.casestudy_action_url,
                btnClass: "cs_btn cs_style_1 cs_type_4 cs_white_color cs_fs_18 cs_medium",
                btnText: item.casestudy_action_text
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "cs_case_study_bg cs_bg_filed",
            style: {
              backgroundImage: "url(".concat(item.casestudy_image_url, ")")
            }
          })]
        }, index);
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero11.jsx":
/*!**********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero11.jsx ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero11)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





function Hero11(_ref) {
  var data = _ref.data;
  var slider_list = data.slider_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "cs_fullscreen_swiper_wrap",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_swiper_button_next cs_down_btn"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_2__.Swiper, {
      direction: "vertical",
      slidesPerView: 1,
      spaceBetween: 0,
      mousewheel: true,
      pagination: {
        type: "custom",
        renderCustom: function renderCustom(swiper, current, total) {
          return "\n                        <div class=\"cs_swiper_pagination cs_number_pagination cs_primary_font\">\n                          <span class=\"swiper-pagination-current\">".concat(current, "</span> / <span class=\"swiper-pagination-total\">").concat(total, "</span>\n                        </div>");
        }
      },
      speed: 1000,
      loop: true,
      modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_3__.Mousewheel, swiper_modules__WEBPACK_IMPORTED_MODULE_3__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_3__.Navigation],
      className: "mySwiper",
      navigation: {
        nextEl: ".cs_swiper_button_next",
        prevEl: ".image-swiper-button-prev",
        disabledClass: "swiper-button-disabled"
      },
      children: slider_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_2__.SwiperSlide, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
            className: "cs_fullscreen_slide cs_dark_section cs_hero cs_style_10 position-relative cs_center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "container",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                className: "cs_section_heading cs_style_1",
                children: [item.sub_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
                  className: "cs_section_subtitle cs_fs_18 cs_medium cs_ternary_color",
                  dangerouslySetInnerHTML: {
                    __html: item.sub_title
                  }
                }), item.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h1", {
                  className: "cs_section_title cs_fs_120 cs_bold cs_white_color",
                  dangerouslySetInnerHTML: {
                    __html: item.title
                  }
                }), (item.action_url || item.action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
                  href: item.action_url,
                  btnClass: "cs_btn cs_style_1 cs_type_4 cs_white_color cs_fs_18 cs_medium",
                  btnText: item.action_text
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "cs_hero_thumb cs_bg_filed",
              style: {
                backgroundImage: "url(".concat(item.imageUrl, ")")
              }
            })]
          })
        }, index);
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero12.jsx":
/*!**********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero12.jsx ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero12)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var _Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Widget/SocialWidget */ "./resources/js/Frontend/Components/Widget/SocialWidget.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);






function Hero12(_ref) {
  var data = _ref.data;
  var slider_list = data.slider_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
    className: "cs_hero cs_style_11 position-relative",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
      pagination: {
        clickable: true
      },
      modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.EffectCube],
      effect: "cube",
      cubeEffect: {
        shadow: true,
        slideShadows: true,
        shadowOffset: 20,
        shadowScale: 0.94
      },
      speed: 1500,
      className: "mySwiper cs_swiper_pagination_wrap_4",
      children: slider_list === null || slider_list === void 0 ? void 0 : slider_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "cs_hero_in cs_center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "cs_hero_bg cs_bg_filed",
              style: {
                backgroundImage: "url(".concat(item.imageUrl, ")")
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "container",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                className: "cs_hero_text",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h1", {
                  className: "cs_hero_title cs_white_color cs_fs_60 cs_bold",
                  dangerouslySetInnerHTML: {
                    __html: item.title
                  }
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
                  className: "cs_hero_subtitle cs_ternary_color",
                  dangerouslySetInnerHTML: {
                    __html: item.sub_title
                  }
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "cs_hero_btns",
                  children: [(item.action_text || item.action_url) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_3__["default"], {
                    href: item.action_url,
                    btnText: item.action_text,
                    btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_color cs_white_bg"
                  }), (item.action_url_2 || item.action_text_2) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_3__["default"], {
                    href: item.action_url_2,
                    btnText: item.action_text_2,
                    btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_primary_bg"
                  })]
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "cs_hero_info container-fluid cs_padding_120_120",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                children: [item.phone_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h4", {
                  className: "cs_hero_contact_number cs_fs_24 cs_normal cs_white_color mb-0",
                  children: item.phone_number
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_4__["default"], {})]
              })
            })]
          })
        }, index);
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero13.jsx":
/*!**********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero13.jsx ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero13)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_youtube_background__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-youtube-background */ "react-youtube-background");
/* harmony import */ var react_youtube_background__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_youtube_background__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var _Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Widget/SocialWidget */ "./resources/js/Frontend/Components/Widget/SocialWidget.jsx");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);






function Hero13(_ref) {
  var data = _ref.data;
  var background_image_url = data.background_image_url,
    youtube_id = data.youtube_id,
    title = data.title,
    action_text = data.action_text,
    action_url = data.action_url,
    phone_number = data.phone_number;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "cs_style_9_wrap position-relative",
    children: [youtube_id && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)((react_youtube_background__WEBPACK_IMPORTED_MODULE_1___default()), {
      videoId: youtube_id,
      className: "cs_video_bg"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "cs_video_bg_placeholder cs_bg_filed cs_primary_bg",
      style: {
        backgroundImage: "url(".concat(background_image_url, ")")
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "cs_hero cs_style_9 cs_type_1 cs_center position-relative",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "cs_hero_text",
          children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h1", {
            className: "cs_hero_title cs_fs_120 cs_white_color",
            dangerouslySetInnerHTML: {
              __html: title
            }
          }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__["default"], {
            href: action_url,
            btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_accent_bg",
            btnText: action_text
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "cs_hero_social_wrap cs_hide_lg",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_3__["default"], {}), phone_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "cs_hero_phone_number cs_primary_font cs_fs_24 cs_white_color",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
          className: "cs_secondary_bg cs_white_color cs_center",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("i", {
            className: "cs_center",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_4__.Icon, {
              icon: "fa6-solid:phone"
            })
          })
        }), phone_number]
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero14.jsx":
/*!**********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero14.jsx ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero14)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Hero14(_ref) {
  var data = _ref.data;
  var title = data.title,
    sub_title = data.sub_title,
    background_image_url = data.background_image_url,
    action_text = data.action_text,
    action_url = data.action_url,
    action_text_2 = data.action_text_2,
    action_url_2 = data.action_url_2,
    background_attachment = data.background_attachment;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("section", {
    className: "cs_hero cs_style_1 cs_type_1 cs_center cs_bg_filed",
    style: {
      backgroundImage: "url(".concat(background_image_url, ")"),
      backgroundAttachment: background_attachment
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h1", {
        className: "cs_hero_title cs_fs_120",
        dangerouslySetInnerHTML: {
          __html: title
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_hero_subtitle cs_fs_18 cs_medium",
        dangerouslySetInnerHTML: {
          __html: sub_title
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_hero_btns",
        children: [(action_text || action_url) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
          href: action_url,
          btnText: action_text,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_accent_bg cs_w_100_sm"
        }), (action_url_2 || action_text_2) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
          href: action_url_2,
          btnText: action_text_2,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_primary_bg cs_w_100_sm"
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero15.jsx":
/*!**********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero15.jsx ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero15)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Hero15(_ref) {
  var data = _ref.data;
  var background_image_url = data.background_image_url,
    title = data.title,
    sub_title = data.sub_title,
    action_text = data.action_text,
    action_url = data.action_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("section", {
    className: "cs_hero cs_style_8 cs_type_1",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_hero_thumb cs_bg_filed",
      style: {
        backgroundImage: "url(".concat(background_image_url, ")")
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_hero_right",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_1",
        children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          className: "cs_section_title cs_fs_80 cs_bold",
          dangerouslySetInnerHTML: {
            __html: title
          }
        }), sub_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          className: "cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: sub_title
          }
        }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
          href: action_url,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_accent_bg",
          btnText: action_text
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero16.jsx":
/*!**********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero16.jsx ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero16)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Hero16(_ref) {
  var data = _ref.data;
  var title = data.title,
    sub_title = data.sub_title,
    background_image_url = data.background_image_url,
    action_text = data.action_text,
    action_url = data.action_url,
    action_text_2 = data.action_text_2,
    action_url_2 = data.action_url_2,
    background_attachment = data.background_attachment;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("section", {
    className: "cs_hero cs_style_1 cs_type_1 cs_center cs_bg_filed",
    style: {
      backgroundImage: "url(".concat(background_image_url, ")"),
      backgroundAttachment: background_attachment
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h1", {
        className: "cs_hero_title cs_fs_120 cs_white_color",
        dangerouslySetInnerHTML: {
          __html: title
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_hero_subtitle cs_fs_18 cs_medium  cs_white_color",
        dangerouslySetInnerHTML: {
          __html: sub_title
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_hero_btns",
        children: [(action_text || action_url) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
          href: action_url,
          btnText: action_text,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_color cs_white_bg cs_w_100_sm"
        }), (action_url_2 || action_text_2) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
          href: action_url_2,
          btnText: action_text_2,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_primary_bg cs_w_100_sm"
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero2.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero2.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Widget/SocialWidget */ "./resources/js/Frontend/Components/Widget/SocialWidget.jsx");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);







function Hero2(_ref) {
  var data = _ref.data;
  var phone_number = data.phone_number,
    slider_list = data.slider_list;
  var pagination = {
    clickable: true,
    renderBullet: function renderBullet(index, className) {
      return '<span class="cs_primary_font cs_fs_30 cs_white_color ' + className + '">' + (index + 1) + "</span>";
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("section", {
    className: "position-relative cs_swiper_number_pagination_wtap",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
      slidesPerView: 1,
      pagination: pagination,
      modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination],
      className: "mySwiper",
      speed: 800,
      loop: true,
      children: slider_list === null || slider_list === void 0 ? void 0 : slider_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
            className: "swiper-slide",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "cs_hero cs_style_2 cs_center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
                className: "cs_swiper_parallax_bg cs_primary_bg",
                style: {
                  backgroundImage: "url(".concat(item.imageUrl, ")")
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
                className: "container",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                  className: "cs_hero_text",
                  children: [item.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h1", {
                    className: "cs_hero_title cs_fs_60 cs_white_color",
                    dangerouslySetInnerHTML: {
                      __html: item.title
                    }
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
                    className: "cs_hero_btn_wrap",
                    children: item.action_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_5__["default"], {
                      href: item.action_url,
                      className: "cs_btn cs_style_1 cs_type_4 cs_primary_color cs_fs_18 cs_medium",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("span", {
                        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("i", {
                          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("svg", {
                            width: 61,
                            height: 61,
                            viewBox: "0 0 61 61",
                            fill: "none",
                            xmlns: "http://www.w3.org/2000/svg",
                            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                              d: "M3 58L58 3M58 3L3 3M58 3L58 58",
                              stroke: "currentColor",
                              strokeWidth: 5,
                              strokeLinecap: "round",
                              strokeLinejoin: "round"
                            })
                          })
                        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("i", {
                          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("svg", {
                            width: 61,
                            height: 61,
                            viewBox: "0 0 61 61",
                            fill: "none",
                            xmlns: "http://www.w3.org/2000/svg",
                            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                              d: "M3 58L58 3M58 3L3 3M58 3L58 58",
                              stroke: "currentColor",
                              strokeWidth: 5,
                              strokeLinecap: "round",
                              strokeLinejoin: "round"
                            })
                          })
                        })]
                      })
                    })
                  })]
                })
              })]
            })
          })
        }, index);
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "cs_hero_social_wrap cs_hide_lg",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_3__["default"], {}), phone_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "cs_hero_phone_number cs_primary_font cs_fs_24 cs_white_color",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
          className: "cs_secondary_bg cs_white_color cs_center",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("i", {
            className: "cs_center",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_4__.Icon, {
              icon: "fa6-solid:phone"
            })
          })
        }), phone_number]
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero3.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero3.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero3)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }




function Hero3(_ref) {
  var data = _ref.data;
  var background_image_url = data.background_image_url,
    avatar_image_url = data.avatar_image_url,
    title = data.title,
    conference_date = data.conference_date,
    location_date = data.location_date,
    conference_time = data.conference_time,
    conference_place = data.conference_place,
    avatar_name = data.avatar_name,
    avatar_designation = data.avatar_designation,
    action_url = data.action_url;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""),
    _useState2 = _slicedToArray(_useState, 2),
    transform1 = _useState2[0],
    setTransform1 = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""),
    _useState4 = _slicedToArray(_useState3, 2),
    transform2 = _useState4[0],
    setTransform2 = _useState4[1];
  var handleMouseMove = function handleMouseMove(event) {
    var target = event.currentTarget;
    var halfW = target.clientWidth / 2;
    var halfH = target.clientHeight / 2;
    var coorX = halfW - (event.pageX - target.offsetLeft);
    var coorY = halfH - (event.pageY - target.offsetTop);
    var degX1 = coorY / halfH * -10 + "px";
    var degY1 = coorX / halfW * 10 + "px";
    var degX2 = coorY / halfH * 15 + "deg";
    var degY2 = coorX / halfW * -15 + "deg";
    setTransform1("perspective(800px) translateX(".concat(degX1, ") translateY(").concat(degY1, ") scale(1.02)"));
    setTransform2("perspective(800px) translate3d(0, 0, 0) rotateX(".concat(degX2, ") rotateY(").concat(degY2, ")"));
  };
  var handleMouseOut = function handleMouseOut() {
    setTransform1("");
    setTransform2("");
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("section", {
    className: "cs_hero cs_style_3 cs_bg_filed cs_primary_bg",
    style: {
      backgroundImage: "url(".concat(background_image_url, ")")
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "cs_hero_text",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "cs_hero_text_left",
          children: [(conference_date || location_date) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("ul", {
            className: "cs_hero_info cs_mp0 cs_primary_font cs_fs_53 cs_white_color cs_normal",
            children: [conference_date && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("li", {
              children: conference_date
            }), location_date && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("li", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("i", {
                className: "cs_center",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_1__.Icon, {
                  icon: "fa6-solid:location-dot"
                })
              }), location_date]
            })]
          }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h1", {
            className: "cs_hero_title cs_fs_120 cs_bold cs_white_color mb-0",
            dangerouslySetInnerHTML: {
              __html: title
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "cs_hero_text_right cs_hobble",
          onMouseMove: handleMouseMove,
          onMouseOut: handleMouseOut,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
            href: action_url,
            className: "cs_hero_btn text-center cs_white_color cs_center cs_hover_layer_2",
            style: {
              transform: transform2
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "cs_hover_layer_1",
              style: {
                transform: transform1
              },
              children: [conference_time && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                className: "cs_fs_30 cs_primary_font d-block",
                children: conference_time
              }), conference_place && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                className: "d-block cs_fs_18 cs_medium",
                children: conference_place
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("svg", {
                width: 44,
                height: 44,
                viewBox: "0 0 44 44",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("path", {
                  d: "M3 3L41 41M41 41V3M41 41H3",
                  stroke: "white",
                  strokeWidth: 5,
                  strokeLinecap: "round",
                  strokeLinejoin: "round"
                })
              })]
            })
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "cs_hero_avatar_wrap",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "cs_hero_avatar",
          children: [avatar_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
            src: avatar_image_url,
            alt: avatar_name
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "cs_hero_avatar_right",
            children: [avatar_name && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h3", {
              className: "cs_normal cs_white_color cs_fs_53 mb-0",
              dangerouslySetInnerHTML: {
                __html: avatar_name
              }
            }), avatar_designation && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
              className: "mb-0 cs_fs_18 cs_medium cs_ternary_color",
              dangerouslySetInnerHTML: {
                __html: avatar_designation
              }
            })]
          })]
        })
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero4.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero4.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero4)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Hero4(_ref) {
  var data = _ref.data;
  var background_image_url = data.background_image_url,
    title = data.title,
    sub_title = data.sub_title,
    action_text = data.action_text,
    action_url = data.action_url,
    action_text_2 = data.action_text_2,
    action_url_2 = data.action_url_2;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_hero cs_style_4 text-center cs_center cs_bg_filed cs_bg_fixed cs_primary_bg",
      style: {
        backgroundImage: "url(".concat(background_image_url, ")")
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "cs_hero_text",
          children: [sub_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
            className: "cs_hero_subtitle cs_ternary_color cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: sub_title
            }
          }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h1", {
            className: "cs_hero_title cs_white_color cs_fs_120 cs_bold",
            dangerouslySetInnerHTML: {
              __html: title
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "cs_hero_btns",
            children: [(action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
              href: action_url,
              btnText: action_text,
              btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_color cs_white_bg cs_w_100_sm"
            }), (action_url_2 || action_text_2) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
              href: action_url_2,
              btnText: action_text_2,
              btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_accent_bg cs_w_100_sm"
            })]
          })]
        })
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero5.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero5.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero5)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var _Rating__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Rating */ "./resources/js/Frontend/Components/Rating.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }






function Hero5(_ref) {
  var data = _ref.data;
  var slider_list = data.slider_list;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""),
    _useState2 = _slicedToArray(_useState, 2),
    transform1 = _useState2[0],
    setTransform1 = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""),
    _useState4 = _slicedToArray(_useState3, 2),
    transform2 = _useState4[0],
    setTransform2 = _useState4[1];
  var handleMouseMove = function handleMouseMove(event) {
    var target = event.currentTarget;
    var halfW = target.clientWidth / 2;
    var halfH = target.clientHeight / 2;
    var coorX = halfW - (event.pageX - target.offsetLeft);
    var coorY = halfH - (event.pageY - target.offsetTop);
    var degX1 = coorY / halfH * -10 + "px";
    var degY1 = coorX / halfW * 10 + "px";
    var degX2 = coorY / halfH * 15 + "deg";
    var degY2 = coorX / halfW * -15 + "deg";
    setTransform1("perspective(800px) translateX(".concat(degX1, ") translateY(").concat(degY1, ") scale(1.02)"));
    setTransform2("perspective(800px) translate3d(0, 0, 0) rotateX(".concat(degX2, ") rotateY(").concat(degY2, ")"));
  };
  var handleMouseOut = function handleMouseOut() {
    setTransform1("");
    setTransform2("");
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
    pagination: {
      clickable: true
    },
    modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.EffectFade],
    effect: "fade",
    speed: 700,
    className: "mySwiper cs_swiper_pagination_wrap_1 cs_type_1",
    children: slider_list === null || slider_list === void 0 ? void 0 : slider_list.map(function (item, index) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "cs_hero cs_style_5 cs_center cs_hobble",
          onMouseMove: handleMouseMove,
          onMouseOut: handleMouseOut,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: "cs_hero_img",
            children: item.imageUrl && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
              src: item.imageUrl,
              alt: item.title,
              className: "cs_hover_layer_1",
              style: {
                transform: transform1
              }
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: "container",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "cs_hero_text",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                className: "cs_section_heading cs_style_1",
                children: [item.sub_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
                  className: "cs_section_subtitle cs_fs_18 cs_medium",
                  dangerouslySetInnerHTML: {
                    __html: item.sub_title
                  }
                }), item.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h1", {
                  className: "cs_section_title cs_fs_120 cs_bold mb-0",
                  dangerouslySetInnerHTML: {
                    __html: item.title
                  }
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                className: "cs_hero_btns",
                children: [(item.action_text || item.action_url) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_3__["default"], {
                  href: item.action_url,
                  btnText: item.action_text,
                  btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_color cs_white_bg cs_w_100_sm"
                }), (item.action_url_2 || item.action_text_2) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_3__["default"], {
                  href: item.action_url_2,
                  btnText: item.action_text_2,
                  btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_accent_bg cs_w_100_sm"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                className: "cs_hero_review_box",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "cs_hero_review_avatars",
                  children: [item.avatar_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
                      src: item.avatar_image_url,
                      alt: "Avatar"
                    })
                  }), item.avatar_image_url_2 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
                      src: item.avatar_image_url_2,
                      alt: "Avatar"
                    })
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "cs_hero_review_right",
                  children: [item.review_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
                    className: "mb-0 cs_fs_18 cs_medium cs_primary_color",
                    children: item.review_title
                  }), item.review_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                    className: "cs_hero_review",
                    children: [item.review_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                      children: [item.review_number > 5 ? 5 : item.review_number, " of 5"]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Rating__WEBPACK_IMPORTED_MODULE_4__["default"], {
                      className: "cs_rating cs_accent_color",
                      ratingNumber: item.review_number
                    })]
                  })]
                })]
              })]
            })
          })]
        })
      }, index);
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero6.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero6.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero6)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function Hero6(_ref) {
  var data = _ref.data;
  var background_image_url = data.background_image_url,
    title = data.title,
    funfact_list = data.funfact_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("section", {
    className: "cs_hero cs_style_6",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "container",
      children: title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h1", {
        className: "cs_hero_title cs_bold cs_fs_120",
        dangerouslySetInnerHTML: {
          __html: title
        }
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "cs_hero_counter_wrap cs_bg_filed",
      style: {
        backgroundImage: "url(".concat(background_image_url, ")")
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "cs_hero_counter_in",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
            className: "cs_hero_counter_list cs_accent_bg text-center",
            children: funfact_list.map(function (item, index) {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "cs_hero_counter",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
                  className: "cs_fs_60 cs_bold cs_white_color mb-0 cs_primary_font",
                  children: item.funfact_value
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
                  className: "mb-0 cs_fs_18 cs_medium",
                  children: item.funfact_title
                })]
              }, index);
            })
          })
        })
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero7.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero7.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero7)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_water_wave__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-water-wave */ "react-water-wave");
/* harmony import */ var react_water_wave__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_water_wave__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Hero7(_ref) {
  var data = _ref.data;
  var background_image_url = data.background_image_url,
    title = data.title,
    feature_list = data.feature_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "cs_bg_filed cs_primary_bg",
    style: {
      backgroundImage: "url(".concat(background_image_url, ")")
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)((react_water_wave__WEBPACK_IMPORTED_MODULE_1___default()), {
      imageUrl: background_image_url,
      className: "cs_hero cs_style_7 cs_bg_filed",
      children: function children() {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_hero_up",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              className: "container",
              children: title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h1", {
                className: "cs_hero_title text-center cs_fs_60 cs_white_color mb-0",
                dangerouslySetInnerHTML: {
                  __html: title
                }
              })
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
            className: "cs_hero_info_list cs_mp0",
            children: feature_list === null || feature_list === void 0 ? void 0 : feature_list.map(function (item, index) {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
                children: [item.feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h3", {
                  className: "cs_fs_24 cs_normal cs_white_color cs_normal",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
                    dangerouslySetInnerHTML: {
                      __html: item.feature_title
                    }
                  })
                }), item.feature_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
                  className: "mb-0 cs_white_color",
                  dangerouslySetInnerHTML: {
                    __html: item.feature_subtitle
                  }
                })]
              }, index);
            })
          })]
        });
      }
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero8.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero8.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero8)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Hero8(_ref) {
  var data = _ref.data;
  var background_image_url = data.background_image_url,
    title = data.title,
    sub_title = data.sub_title,
    action_text = data.action_text,
    action_url = data.action_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("section", {
    className: "cs_hero cs_style_8",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_hero_thumb cs_bg_filed",
      style: {
        backgroundImage: "url(".concat(background_image_url, ")")
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_hero_right",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_1",
        children: [sub_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: sub_title
          }
        }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          className: "cs_section_title cs_fs_120 cs_bold mb-0",
          dangerouslySetInnerHTML: {
            __html: title
          }
        }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
          href: action_url,
          btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_accent_bg",
          btnText: action_text
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/Hero9.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/Hero9.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero9)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_youtube_background__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-youtube-background */ "react-youtube-background");
/* harmony import */ var react_youtube_background__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_youtube_background__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function Hero9(_ref) {
  var data = _ref.data;
  var background_image_url = data.background_image_url,
    youtube_id = data.youtube_id,
    title = data.title,
    action_text = data.action_text,
    action_url = data.action_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "cs_style_9_wrap position-relative",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)((react_youtube_background__WEBPACK_IMPORTED_MODULE_1___default()), {
      videoId: youtube_id,
      className: "cs_video_bg"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "cs_video_bg_placeholder cs_bg_filed cs_primary_bg",
      style: {
        backgroundImage: "url(".concat(background_image_url, ")")
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("section", {
      className: "cs_hero cs_style_9 cs_center position-relative",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "cs_hero_text",
          children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h1", {
            className: "cs_hero_title cs_fs_120 cs_white_color",
            dangerouslySetInnerHTML: {
              __html: title
            }
          }), (action_url || action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__["default"], {
            href: action_url,
            btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_accent_bg",
            btnText: action_text
          })]
        })
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Hero/index.jsx":
/*!*********************************************************!*\
  !*** ./resources/js/Frontend/Components/Hero/index.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Hero)
/* harmony export */ });
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function Hero(_ref) {
  var data = _ref.data;
  var title = data.title,
    phone_number = data.phone_number,
    sub_title = data.sub_title,
    background_image_url = data.background_image_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("section", {
    className: "cs_hero cs_style_1 cs_center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "cs_hero_title_box_wrap",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "cs_hero_title_box",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "cs_hero_title_box_in",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "container",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h1", {
              className: "cs_hero_title cs_fs_120 mb-0",
              dangerouslySetInnerHTML: {
                __html: title
              }
            })
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "cs_hero_title_box cs_title_cloned",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "cs_hero_title_box_in",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "container",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h1", {
              className: "cs_hero_title cs_fs_120 mb-0",
              dangerouslySetInnerHTML: {
                __html: title
              }
            })
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "cs_hero_text",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "cs_hero_bottom",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "cs_hero_phone_number cs_primary_font cs_fs_24 cs_primary_color",
            children: phone_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                className: "cs_accent_bg cs_white_color cs_center",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("i", {
                  className: "cs_center",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_1__.Icon, {
                    icon: "fa6-solid:phone"
                  })
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__["default"], {
                href: "tel:".concat(phone_number),
                children: data.phone_number
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "cs_hero_subtitle cs_white_color cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: sub_title
            }
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "cs_hero_thumb cs_bg_filed cs_primary_bg",
      style: {
        backgroundImage: "url(".concat(background_image_url, ")")
      }
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalAditionalFeature.jsx":
/*!******************************************************************************************!*\
  !*** ./resources/js/Frontend/Components/HorizontalScroll/HorizontalAditionalFeature.jsx ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HorizontalAditionalFeature)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function HorizontalAditionalFeature(_ref) {
  var item = _ref.item;
  var inner_slide_list = item.inner_slide_list,
    section_title = item.section_title,
    section_subtitle = item.section_subtitle,
    image_url = item.image_url;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "row align-items-center cs_gap_y_40",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "col-lg-6",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
              className: "cs_height_26 cs_height_lg_20"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "d-flex cs_gap_y_30 flex-wrap",
          children: inner_slide_list === null || inner_slide_list === void 0 ? void 0 : inner_slide_list.map(function (featureItem, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), {
              children: (featureItem.inner_feature_icon_url || featureItem.inner_feature_title || featureItem.inner_feature_subtitle) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                className: "cs_iconbox cs_style_3 w-100",
                children: [featureItem.inner_feature_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                  className: "cs_iconbox_icon",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                    src: featureItem.inner_feature_icon_url,
                    alt: "Icon"
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                  className: "cs_iconbox_right",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h3", {
                    className: "cs_iconbox_title cs_normal cs_fs_24",
                    dangerouslySetInnerHTML: {
                      __html: featureItem.inner_feature_title
                    }
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
                    className: "cs_iconbox_subtitle mb-0",
                    dangerouslySetInnerHTML: {
                      __html: featureItem.inner_feature_subtitle
                    }
                  })]
                })]
              })
            }, index);
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "col-lg-6",
        children: image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "cs_right_full_width cs_space_120",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
            src: image_url,
            alt: "Thumb"
          })
        })
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalContactInfo.jsx":
/*!*************************************************************************************!*\
  !*** ./resources/js/Frontend/Components/HorizontalScroll/HorizontalContactInfo.jsx ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HorizontalContactInfo)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Widget/SocialWidget */ "./resources/js/Frontend/Components/Widget/SocialWidget.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function HorizontalContactInfo(_ref) {
  var item = _ref.item;
  var section_title = item.section_title,
    section_subtitle = item.section_subtitle,
    inner_slide_list = item.inner_slide_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "row align-items-center cs_gap_y_50",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "col-lg-6",
        children: (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "cs_section_heading cs_style_1",
            children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
              className: "cs_section_subtitle cs_fs_18 cs_medium",
              dangerouslySetInnerHTML: {
                __html: section_subtitle
              }
            }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "col-lg-6",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
          className: "cs_mp0 cs_contact_info",
          children: inner_slide_list === null || inner_slide_list === void 0 ? void 0 : inner_slide_list.map(function (contactItem, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
                dangerouslySetInnerHTML: {
                  __html: contactItem.contact_title
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h3", {
                className: "cs_fs_24 cs_normal",
                dangerouslySetInnerHTML: {
                  __html: contactItem.contact_description
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
                dangerouslySetInnerHTML: {
                  __html: contactItem.contact_info
                }
              }), contactItem.social_link_show && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_1__["default"], {})]
            }, index);
          })
        })
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalFunFact.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/HorizontalScroll/HorizontalFunFact.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HorizontalFunFact)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function HorizontalFunFact(_ref) {
  var item = _ref.item;
  var section_subtitle = item.section_subtitle,
    section_title = item.section_title,
    inner_slide_list = item.inner_slide_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "row align-items-center cs_gap_y_50",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "col-lg-6",
        children: (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
            className: "cs_section_heading cs_style_1",
            children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
              className: "cs_section_subtitle cs_fs_18 cs_medium",
              dangerouslySetInnerHTML: {
                __html: section_subtitle
              }
            }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "col-lg-6 position-relative",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "cs_counter_1_wrap cs_type_1",
          children: inner_slide_list === null || inner_slide_list === void 0 ? void 0 : inner_slide_list.map(function (funfactItem, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
              className: "cs_counter cs_style_1 position-relative d-flex",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                children: [funfactItem.funfact_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                  className: "cs_fs_60 cs_primary_font cs_bold cs_primary_color d-flex",
                  dangerouslySetInnerHTML: {
                    __html: funfactItem.funfact_number
                  }
                }), funfactItem.inner_feature_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
                  className: "cs_fs_18 cs_medium mb-0",
                  dangerouslySetInnerHTML: {
                    __html: funfactItem.inner_feature_title
                  }
                })]
              })
            }, index);
          })
        })
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalHero.jsx":
/*!******************************************************************************!*\
  !*** ./resources/js/Frontend/Components/HorizontalScroll/HorizontalHero.jsx ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HorizontalHero)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Widget/SocialWidget */ "./resources/js/Frontend/Components/Widget/SocialWidget.jsx");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function HorizontalHero(_ref) {
  var item = _ref.item;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "cs_hero cs_style_11 w-100",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "cs_hero_text",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h1", {
          className: "cs_hero_title cs_white_color cs_fs_60 cs_bold",
          dangerouslySetInnerHTML: {
            __html: item.section_title
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
          className: "cs_hero_subtitle cs_ternary_color",
          dangerouslySetInnerHTML: {
            __html: item.section_subtitle
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "cs_hero_btns",
          children: [(item.action_text || item.action_url) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__["default"], {
            href: item.action_url,
            btnText: item.action_text,
            btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_color cs_white_bg"
          }), (item.action_url_2 || item.action_text_2) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__["default"], {
            href: item.action_url_2,
            btnText: item.action_text_2,
            btnClass: "cs_btn cs_style_1 cs_type_2 cs_white_color cs_primary_bg"
          })]
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "cs_hero_info container-fluid cs_padding_120_120",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        children: [item.phone_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("h4", {
          className: "cs_hero_contact_number cs_fs_24 cs_normal cs_white_color mb-0",
          children: item.phone_number
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Widget_SocialWidget__WEBPACK_IMPORTED_MODULE_1__["default"], {})]
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalScroll1.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/HorizontalScroll/HorizontalScroll1.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HorizontalScroll1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _HorizontalHero__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./HorizontalHero */ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalHero.jsx");
/* harmony import */ var _HorizontalAditionalFeature__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./HorizontalAditionalFeature */ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalAditionalFeature.jsx");
/* harmony import */ var _HorizontalService__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./HorizontalService */ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalService.jsx");
/* harmony import */ var _HorizontalTestimonial__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./HorizontalTestimonial */ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalTestimonial.jsx");
/* harmony import */ var _HorizontalFunFact__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./HorizontalFunFact */ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalFunFact.jsx");
/* harmony import */ var _HorizontalContactInfo__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./HorizontalContactInfo */ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalContactInfo.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }










function HorizontalScroll1(_ref) {
  var data = _ref.data;
  var slide_list = data.slide_list;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("about:blank"),
    _useState2 = _slicedToArray(_useState, 2),
    iframeSrc = _useState2[0],
    setIframeSrc = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    toggle = _useState4[0],
    setToggle = _useState4[1];
  var handleVideoClick = function handleVideoClick(videoUrl) {
    if (!videoUrl) {
      console.error("No video URL provided");
      return;
    }
    try {
      var embedUrl = videoUrl;

      // Handle YouTube URLs
      if (videoUrl.includes("youtube.com") || videoUrl.includes("youtu.be")) {
        var videoId = "";

        // Different YouTube URL formats
        if (videoUrl.includes("youtube.com/watch?v=")) {
          videoId = videoUrl.split("v=")[1].split("&")[0];
        } else if (videoUrl.includes("youtu.be/")) {
          videoId = videoUrl.split("youtu.be/")[1].split("?")[0];
        } else if (videoUrl.includes("youtube.com/embed/")) {
          videoId = videoUrl.split("embed/")[1].split("?")[0];
        }
        if (videoId) {
          embedUrl = "https://www.youtube.com/embed/".concat(videoId, "?autoplay=1&rel=0");
        } else {
          console.error("Could not extract YouTube video ID");
          return;
        }
      }
      // You can add other video providers (Vimeo, etc.) here

      setIframeSrc(embedUrl);
      setToggle(true);
    } catch (error) {
      console.error("Error processing video URL:", error);
    }
  };
  var handleClose = function handleClose() {
    setIframeSrc("about:blank");
    setToggle(false);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      className: "position-relative",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
        pagination: {
          clickable: true
        },
        modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Mousewheel],
        mousewheel: true,
        speed: 1200,
        loop: true,
        className: "mySwiper cs_swiper_pagination_wrap_4",
        children: slide_list === null || slide_list === void 0 ? void 0 : slide_list.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "cs_fullscreen_slide cs_bg_filed cs_dark_section cs_primary_bg cs_fullscreen_section",
              style: {
                backgroundImage: "url(".concat(item.background_image_url, ")")
              },
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: "cs_fullscreen_slide_in",
                children: [item.slide_type === "Hero" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_HorizontalHero__WEBPACK_IMPORTED_MODULE_3__["default"], {
                  item: item
                }), item.slide_type === "AditionalFeature" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_HorizontalAditionalFeature__WEBPACK_IMPORTED_MODULE_4__["default"], {
                  item: item
                }), item.slide_type === "Service" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_HorizontalService__WEBPACK_IMPORTED_MODULE_5__["default"], {
                  item: item
                }), item.slide_type === "Testimonial" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_HorizontalTestimonial__WEBPACK_IMPORTED_MODULE_6__["default"], {
                  item: item,
                  onVideoClick: handleVideoClick
                }), item.slide_type === "FunFact" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_HorizontalFunFact__WEBPACK_IMPORTED_MODULE_7__["default"], {
                  item: item
                }), item.slide_type === "ContactInfo" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_HorizontalContactInfo__WEBPACK_IMPORTED_MODULE_8__["default"], {
                  item: item
                })]
              })
            })
          }, index);
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: toggle ? "cs_video_popup active" : "cs_video_popup",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "cs_video_popup_overlay",
        onClick: handleClose
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "cs_video_popup_content",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
          className: "cs_video_popup_layer"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "cs_video_popup_container",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
            className: "cs_video_popup_align",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "embed-responsive embed-responsive-16by9",
              children: iframeSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("iframe", {
                className: "embed-responsive-item",
                src: iframeSrc,
                title: "video modal",
                allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture",
                allowFullScreen: true,
                frameBorder: "0"
              })
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("button", {
            className: "cs_video_popup_close",
            onClick: handleClose,
            children: "\xD7"
          })]
        })]
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalService.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/HorizontalScroll/HorizontalService.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HorizontalService)
/* harmony export */ });
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function HorizontalService(_ref) {
  var item = _ref.item;
  var section_subtitle = item.section_subtitle,
    section_title = item.section_title,
    inner_slide_list = item.inner_slide_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "row cs_gap_y_40",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "col-lg-7",
        children: (section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "cs_section_heading cs_style_1",
            children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
              className: "cs_section_subtitle cs_fs_18 cs_medium",
              dangerouslySetInnerHTML: {
                __html: section_subtitle
              }
            }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
              className: "cs_section_title cs_fs_53 cs_normal mb-0",
              dangerouslySetInnerHTML: {
                __html: section_title
              }
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "col-lg-5",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
          className: "cs_list cs_style_2 cs_mp0",
          children: inner_slide_list === null || inner_slide_list === void 0 ? void 0 : inner_slide_list.map(function (featureItem, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
              children: (featureItem.inner_feature_title || featureItem.inner_feature_action_url) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__["default"], {
                href: featureItem.inner_feature_action_url,
                className: "cs_btn cs_style_1 cs_type_2",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
                  className: "mb-0 cs_fs_30 cs_normal",
                  dangerouslySetInnerHTML: {
                    __html: featureItem.inner_feature_title
                  }
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
                      width: 11,
                      height: 11,
                      viewBox: "0 0 11 11",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
                        d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                        stroke: "currentColor",
                        strokeWidth: "1.5",
                        strokeLinecap: "round",
                        strokeLinejoin: "round"
                      })
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
                      width: 11,
                      height: 11,
                      viewBox: "0 0 11 11",
                      fill: "none",
                      xmlns: "http://www.w3.org/2000/svg",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
                        d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                        stroke: "currentColor",
                        strokeWidth: "1.5",
                        strokeLinecap: "round",
                        strokeLinejoin: "round"
                      })
                    })
                  })]
                })]
              })
            }, index);
          })
        })
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/HorizontalScroll/HorizontalTestimonial.jsx":
/*!*************************************************************************************!*\
  !*** ./resources/js/Frontend/Components/HorizontalScroll/HorizontalTestimonial.jsx ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HorizontalTestimonial)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Rating__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Rating */ "./resources/js/Frontend/Components/Rating.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





function HorizontalTestimonial(_ref) {
  var item = _ref.item,
    onVideoClick = _ref.onVideoClick;
  var image_url = item.image_url,
    video_url = item.video_url,
    inner_slide_list = item.inner_slide_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "row align-items-center cs_gap_y_40",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "col-lg-5",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
            className: "cs_testimonial_2_video cs_type_1",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              className: "cs_testimonial_2_video_shape cs_ternary_color",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("svg", {
                width: 77,
                height: 84,
                viewBox: "0 0 77 84",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("g", {
                  opacity: "0.5",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
                    d: "M15.0071 18.6364C17.1053 22.4928 20.17 25.7713 22.4964 29.4918C24.7743 33.1394 27.5233 36.5393 30.2334 39.8469C35.7169 46.5544 42.1571 52.6791 49.8019 56.8124C50.8169 57.3612 51.9195 56.0207 51.0549 55.1853C44.9013 49.2792 38.9127 43.2128 33.0359 37.0444C30.1671 34.0428 27.3355 30.9991 24.5412 27.9133C21.593 24.6494 19.1986 20.9046 16.2407 17.6844C15.6191 17.0142 14.5894 17.8738 15.0071 18.6364Z",
                    fill: "currentColor"
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
                    d: "M43.7756 1.09195C43.7531 5.4822 44.8559 9.83247 45.0989 14.2137C45.3345 18.5077 46.1022 22.8121 46.8805 27.0168C48.4477 35.5376 51.1342 44.0094 55.8365 51.3181C56.4609 52.2886 58.0733 51.6463 57.7191 50.4974C55.1781 42.3552 52.8591 34.1524 50.6872 25.914C49.6224 21.9008 48.6105 17.8686 47.6515 13.8175C46.6437 9.53625 46.3529 5.10092 45.3155 0.853256C45.0943 -0.0337773 43.7776 0.222497 43.7756 1.09195Z",
                    fill: "currentColor"
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
                    d: "M0.725625 51.1746C4.57366 53.2881 8.92326 54.3933 12.89 56.269C16.7766 58.1097 20.926 59.4875 24.9929 60.8086C33.2296 63.4943 41.9571 65.173 50.6234 64.5251C51.7742 64.439 51.9786 62.7154 50.7999 62.4789C42.4316 60.8296 34.1158 58.9562 25.8389 56.9366C21.8037 55.9587 17.7771 54.9253 13.7591 53.8364C9.51545 52.6806 5.47833 50.8211 1.25014 49.7073C0.365001 49.4787 -0.0376274 50.7583 0.725625 51.1746Z",
                    fill: "currentColor"
                  })]
                })
              })
            }), video_url ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "cs_video_block cs_style_1 cs_bg_filed",
              style: {
                backgroundImage: "url(".concat(image_url, ")")
              },
              onClick: function onClick() {
                return onVideoClick(video_url);
              },
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
                className: "cs_player_btn cs_accent_color",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {})
              })
            }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "cs_video_block cs_style_1 cs_bg_filed",
              style: {
                backgroundImage: "url(".concat(image_url, ")"),
                cursor: "initial"
              }
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "col-xl-6 offset-xl-1 col-lg-7 position-relative",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
            slidesPerView: 1,
            spaceBetween: 10,
            pagination: false,
            navigation: {
              nextEl: ".cs_right_arrow",
              prevEl: ".cs_left_arrow",
              disabledClass: "swiper-button-disabled"
            },
            modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Navigation],
            speed: 800,
            loop: true,
            className: "mySwiper",
            children: inner_slide_list === null || inner_slide_list === void 0 ? void 0 : inner_slide_list.map(function (testimonialItem, index) {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                  className: "cs_testimonial cs_style_1",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                    className: "cs_testimonial_text cs_primary_font cs_fs_30 cs_primary_color fst-italic",
                    dangerouslySetInnerHTML: {
                      __html: testimonialItem.testimonial_text
                    }
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                    className: "cs_height_45 cs_height_lg_30"
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                    className: "cs_testimonial_info d-flex align-testimonialItems-center",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h3", {
                        className: "cs_fs_24 cs_normal mb-0",
                        children: testimonialItem.avatar_name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                        className: "cs_height_5 cs_height_lg_5"
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
                        className: "mb-0",
                        children: testimonialItem.avatar_designation
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                        className: "cs_height_12 cs_height_lg_12"
                      }), testimonialItem.review_number && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Rating__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        className: "cs_rating cs_accent_color",
                        ratingNumber: testimonialItem.review_number
                      })]
                    })
                  })]
                })
              }, index);
            })
          }), (inner_slide_list === null || inner_slide_list === void 0 ? void 0 : inner_slide_list.length) > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "cs_height_60 cs_height_lg_35"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
              className: "cs_slider_arrows cs_style1",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                className: "cs_left_arrow cs_accent_bg rounded-circle cs_center cs_white_color",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("svg", {
                  width: 17,
                  height: 12,
                  viewBox: "0 0 17 12",
                  fill: "none",
                  xmlns: "http://www.w3.org/2000/svg",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
                    d: "M0.469669 5.46967C0.176777 5.76256 0.176777 6.23744 0.469669 6.53033L5.24264 11.3033C5.53553 11.5962 6.01041 11.5962 6.3033 11.3033C6.59619 11.0104 6.59619 10.5355 6.3033 10.2426L2.06066 6L6.3033 1.75736C6.59619 1.46447 6.59619 0.989593 6.3033 0.696699C6.01041 0.403806 5.53553 0.403806 5.24264 0.696699L0.469669 5.46967ZM17 5.25L1 5.25V6.75L17 6.75V5.25Z",
                    fill: "currentColor"
                  })
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                className: "cs_right_arrow cs_accent_bg rounded-circle cs_center cs_white_color",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("svg", {
                  width: 17,
                  height: 12,
                  viewBox: "0 0 17 12",
                  fill: "none",
                  xmlns: "http://www.w3.org/2000/svg",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
                    d: "M16.5303 6.53033C16.8232 6.23744 16.8232 5.76256 16.5303 5.46967L11.7574 0.696698C11.4645 0.403805 10.9896 0.403805 10.6967 0.696698C10.4038 0.989592 10.4038 1.46447 10.6967 1.75736L14.9393 6L10.6967 10.2426C10.4038 10.5355 10.4038 11.0104 10.6967 11.3033C10.9896 11.5962 11.4645 11.5962 11.7574 11.3033L16.5303 6.53033ZM6.55671e-08 6.75L16 6.75L16 5.25L-6.55671e-08 5.25L6.55671e-08 6.75Z",
                    fill: "currentColor"
                  })
                })
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
            className: "cs_testimonial_1_2_quote cs_ternary_color",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("svg", {
              width: 162,
              height: 122,
              viewBox: "0 0 162 122",
              fill: "none",
              xmlns: "http://www.w3.org/2000/svg",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
                d: "M54 0H27C19.8392 0 12.9716 2.84463 7.90812 7.90812C2.84464 12.9716 0 19.8392 0 27L0 54C0 57.5804 1.42232 61.0142 3.95406 63.5459C6.4858 66.0777 9.91958 67.5 13.5 67.5H47.25C47.2393 76.4478 43.6801 85.026 37.353 91.353C31.026 97.6801 22.4478 101.239 13.5 101.25C10.8147 101.25 8.23935 102.317 6.34054 104.216C4.44174 106.114 3.375 108.69 3.375 111.375C3.375 114.06 4.44174 116.636 6.34054 118.534C8.23935 120.433 10.8147 121.5 13.5 121.5C27.8168 121.484 41.5425 115.789 51.666 105.666C61.7895 95.5425 67.4839 81.8168 67.5 67.5V13.5C67.5 9.91958 66.0777 6.4858 63.5459 3.95406C61.0142 1.42232 57.5804 0 54 0Z",
                fill: "currentColor"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("path", {
                d: "M148.5 0H121.5C114.339 0 107.472 2.84463 102.408 7.90812C97.3446 12.9716 94.5 19.8392 94.5 27V54C94.5 57.5804 95.9223 61.0142 98.4541 63.5459C100.986 66.0777 104.42 67.5 108 67.5H141.75C141.739 76.4478 138.18 85.026 131.853 91.353C125.526 97.6801 116.948 101.239 108 101.25C105.315 101.25 102.739 102.317 100.841 104.216C98.9417 106.114 97.875 108.69 97.875 111.375C97.875 114.06 98.9417 116.636 100.841 118.534C102.739 120.433 105.315 121.5 108 121.5C122.317 121.484 136.043 115.789 146.166 105.666C156.289 95.5425 161.984 81.8168 162 67.5V13.5C162 9.91958 160.578 6.4858 158.046 3.95406C155.514 1.42232 152.08 0 148.5 0Z",
                fill: "currentColor"
              })]
            })
          })]
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/JobListings/JobListings.jsx":
/*!**********************************************************************!*\
  !*** ./resources/js/Frontend/Components/JobListings/JobListings.jsx ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ JobListings)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function JobListings(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    job_list = data.job_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "container",
    children: [(section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
      className: "cs_list cs_style_5 cs_mp0",
      children: job_list === null || job_list === void 0 ? void 0 : job_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "cs_list_left",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
              className: "cs_fs_30 cs_normal",
              dangerouslySetInnerHTML: {
                __html: item.job_title
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
              dangerouslySetInnerHTML: {
                __html: item.job_description
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
              className: "cs_list_meta",
              children: [item.job_duration && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
                    width: 20,
                    height: 20,
                    viewBox: "0 0 20 20",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
                      d: "M9.99 0C4.47 0 0 4.48 0 10C0 15.52 4.47 20 9.99 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 9.99 0ZM10 18C5.58 18 2 14.42 2 10C2 5.58 5.58 2 10 2C14.42 2 18 5.58 18 10C18 14.42 14.42 18 10 18ZM9.78 5H9.72C9.32 5 9 5.32 9 5.72V10.44C9 10.79 9.18 11.12 9.49 11.3L13.64 13.79C13.98 13.99 14.42 13.89 14.62 13.55C14.83 13.21 14.72 12.76 14.37 12.56L10.5 10.26V5.72C10.5 5.32 10.18 5 9.78 5Z",
                      fill: "#FE5B2C"
                    })
                  })
                }), item.job_duration]
              }), item.job_status && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
                    width: 20,
                    height: 19,
                    viewBox: "0 0 20 19",
                    fill: "none",
                    xmlns: "http://www.w3.org/2000/svg",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
                      fillRule: "evenodd",
                      clipRule: "evenodd",
                      d: "M12 4V2H8V4H12ZM2 6V17H18V6H2ZM18 4C19.11 4 20 4.89 20 6V17C20 18.11 19.11 19 18 19H2C0.89 19 0 18.11 0 17L0.00999999 6C0.00999999 4.89 0.89 4 2 4H6V2C6 0.89 6.89 0 8 0H12C13.11 0 14 0.89 14 2V4H18Z",
                      fill: "#FE5B2C"
                    })
                  })
                }), item.job_status]
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_list_right",
            children: (item.job_action_url || item.job_action_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
              href: item.job_action_url,
              btnText: item.job_action_text,
              btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color"
            })
          })]
        }, index);
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/LoginLink.jsx":
/*!********************************************************!*\
  !*** ./resources/js/Frontend/Components/LoginLink.jsx ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LoginLink)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function LoginLink(_ref) {
  var _ref$className = _ref.className,
    className = _ref$className === void 0 ? 'underline' : _ref$className,
    _ref$email = _ref.email,
    email = _ref$email === void 0 ? null : _ref$email,
    _ref$guard = _ref.guard,
    guard = _ref$guard === void 0 ? null : _ref$guard,
    _ref$keyId = _ref.keyId,
    keyId = _ref$keyId === void 0 ? null : _ref$keyId,
    _ref$label = _ref.label,
    label = _ref$label === void 0 ? 'Login' : _ref$label,
    _ref$redirectUrl = _ref.redirectUrl,
    redirectUrl = _ref$redirectUrl === void 0 ? null : _ref$redirectUrl,
    _ref$userAttributes = _ref.userAttributes,
    userAttributes = _ref$userAttributes === void 0 ? null : _ref$userAttributes;
  function submit(event) {
    _inertiajs_react__WEBPACK_IMPORTED_MODULE_1__.router.post(route('loginLinkLogin'), {
      email: email,
      key: keyId,
      redirect_url: redirectUrl,
      guard: guard,
      user_attributes: userAttributes
    });
  }
  ;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "quick-login-link",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("button", {
      onClick: submit,
      className: className,
      style: {
        borderRadius: "20px !important"
      },
      children: label
    })
  });
}
;

/***/ }),

/***/ "./resources/js/Frontend/Components/Map/Map1.jsx":
/*!*******************************************************!*\
  !*** ./resources/js/Frontend/Components/Map/Map1.jsx ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Map1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Map1(_ref) {
  var data = _ref.data;
  var google_map_iframe = data.google_map_iframe;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "cs_google_map cs_gray_bg",
    dangerouslySetInnerHTML: {
      __html: google_map_iframe
    }
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Marquee/Marquee1.jsx":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/Marquee/Marquee1.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Marquee1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Marquee1(_ref) {
  var data = _ref.data;
  var text = data.text;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "cs_moving_section_wrap",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "cs_moving_section_in cs_primary_font cs_primary_color cs_fs_120",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_moving_section cs_moving_duration_40",
        dangerouslySetInnerHTML: {
          __html: text
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_moving_section cs_moving_duration_40",
        dangerouslySetInnerHTML: {
          __html: text
        }
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Marquee/Marquee2.jsx":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/Marquee/Marquee2.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Marquee2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Marquee2(_ref) {
  var data = _ref.data;
  var text = data.text;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "cs_moving_section_wrap",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "cs_moving_section_in cs_primary_font cs_outline_style cs_bold cs_fs_120",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_moving_section cs_moving_duration_40",
        dangerouslySetInnerHTML: {
          __html: text
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_moving_section cs_moving_duration_40",
        dangerouslySetInnerHTML: {
          __html: text
        }
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Marquee/Marquee3.jsx":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/Marquee/Marquee3.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Marquee3)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Marquee3(_ref) {
  var data = _ref.data;
  var text = data.text;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "cs_moving_section_wrap",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "cs_moving_section_in cs_primary_font cs_gradient_style cs_bold cs_fs_120",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_moving_section cs_moving_duration_40",
        dangerouslySetInnerHTML: {
          __html: text
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_moving_section cs_moving_duration_40",
        dangerouslySetInnerHTML: {
          __html: text
        }
      })]
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/PageHeading/index.jsx":
/*!****************************************************************!*\
  !*** ./resources/js/Frontend/Components/PageHeading/index.jsx ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PageHeading)
/* harmony export */ });
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function PageHeading(_ref) {
  var _data$breadcrumb;
  var data = _ref.data,
    bgSrc = _ref.bgSrc,
    variant = _ref.variant;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_page_heading cs_style_1 cs_bg_filed cs_primary_bg ".concat(variant ? variant : ""),
      style: {
        backgroundImage: "url(".concat(bgSrc, ")")
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "cs_section_heading cs_style_1",
          children: [data.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h1", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0 cs_white_color",
            children: data.title
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ol", {
            className: "breadcrumb cs_white_color",
            children: data === null || data === void 0 || (_data$breadcrumb = data.breadcrumb) === null || _data$breadcrumb === void 0 ? void 0 : _data$breadcrumb.map(function (item) {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
                className: "breadcrumb-item",
                children: item.url ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_0__.Link, {
                  href: item.url,
                  children: item.label
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
                  className: "search current-item",
                  children: item.label
                })
              });
            })
          })]
        })
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Pagination/index.jsx":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/Pagination/index.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Pagination)
/* harmony export */ });
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function Pagination(_ref) {
  var links = _ref.links;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("ul", {
    className: "cs_pagination_box cs_center cs_white_color cs_mp0",
    children: links.map(function (link, index) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("li", {
        children: link.url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_2__.Link, {
          className: "cs_pagination_item cs_center ".concat(link.active ? "active" : ""),
          href: link.url,
          children: link.label === "Next &raquo;" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_0__.Icon, {
            icon: "lucide:chevron-right",
            width: "20",
            height: "20"
          }) : link.label === "&laquo; Previous" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_0__.Icon, {
            icon: "lucide:chevron-left",
            width: "20",
            height: "20"
          }) : "".concat(link.label)
        })
      }, index);
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Partner/Partner1.jsx":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/Partner/Partner1.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Partner1)
/* harmony export */ });
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function Partner1(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    partner_list = data.partner_list,
    pagination_style = data.pagination_style;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "container",
    children: [section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
        className: "text-center cs_primary_color cs_fs_18 cs_medium mb-0",
        dangerouslySetInnerHTML: {
          __html: section_title
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_height_65 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_0__.Swiper, {
      slidesPerView: 2,
      spaceBetween: 24,
      pagination: {
        clickable: true
      },
      speed: 800,
      loop: true,
      modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_1__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_1__.Navigation],
      navigation: {
        nextEl: ".cs_right_arrow",
        prevEl: ".cs_left_arrow",
        disabledClass: "swiper-button-disabled"
      },
      className: "mySwiper".concat(pagination_style === "pagination_0" || !pagination_style ? " cs_swiper_pagination_wrap_0" : "").concat(pagination_style === "pagination_1" ? " cs_swiper_pagination_wrap_1" : "").concat(pagination_style === "pagination_2" ? " cs_swiper_pagination_wrap_2" : "").concat(pagination_style === "pagination_3" ? " cs_swiper_pagination_wrap_3" : ""),
      breakpoints: {
        575: {
          slidesPerView: 3,
          spaceBetween: 24
        },
        991: {
          slidesPerView: 4
        },
        1199: {
          slidesPerView: 5
        }
      },
      children: partner_list === null || partner_list === void 0 ? void 0 : partner_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_0__.SwiperSlide, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_brand cs_style_1 text-center",
            children: item.partner_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
              src: item.partner_image_url,
              alt: "Brand"
            })
          })
        }, index);
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Partner/Partner2.jsx":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/Partner/Partner2.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Partner2)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function Partner2(_ref) {
  var data = _ref.data;
  var partner_list = data.partner_list,
    animation_direction = data.animation_direction;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "cs_moving_section_wrap",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "cs_moving_section_in",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "cs_moving_section cs_moving_duration_40 cs_brand_2_wrap".concat(animation_direction ? " cs_reverse_animation" : ""),
          children: partner_list === null || partner_list === void 0 ? void 0 : partner_list.map(function (item, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_brand cs_style_2",
              children: item.partner_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
                src: item.partner_image_url,
                alt: "Brand"
              })
            }, index);
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "cs_moving_section cs_moving_duration_40 cs_brand_2_wrap".concat(animation_direction ? " cs_reverse_animation" : ""),
          children: partner_list === null || partner_list === void 0 ? void 0 : partner_list.map(function (item, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
              className: "cs_brand cs_style_2",
              children: item.partner_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
                src: item.partner_image_url,
                alt: "Brand"
              })
            }, index);
          })
        })]
      })
    })
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/PhotoGallery/LightGallery.jsx":
/*!************************************************************************!*\
  !*** ./resources/js/Frontend/Components/PhotoGallery/LightGallery.jsx ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LightGallery)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @iconify/react */ "@iconify/react");
/* harmony import */ var _iconify_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_iconify_react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }





function LightGallery(_ref) {
  var modalToggle = _ref.modalToggle,
    setModalToggle = _ref.setModalToggle,
    galleryList = _ref.galleryList,
    initialSlideIndex = _ref.initialSlideIndex;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPlaying = _useState2[0],
    setIsPlaying = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(1),
    _useState4 = _slicedToArray(_useState3, 2),
    zoomLevel = _useState4[0],
    setZoomLevel = _useState4[1];
  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
    _useState6 = _slicedToArray(_useState5, 2),
    swiperRef = _useState6[0],
    setSwiperRef = _useState6[1];
  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    isFullscreen = _useState8[0],
    setIsFullscreen = _useState8[1];
  var handleZoomIn = function handleZoomIn() {
    setZoomLevel(function (prevZoom) {
      return prevZoom * 1.1;
    });
  };
  var handleZoomOut = function handleZoomOut() {
    if (zoomLevel > 1) {
      setZoomLevel(function (prevZoom) {
        return prevZoom / 1.1;
      });
    }
  };
  var handleDownload = function handleDownload(imageUrl) {
    var link = document.createElement("a");
    link.href = imageUrl;
    link.download = imageUrl.substring(imageUrl.lastIndexOf("/") + 1);
    link.click();
  };
  var toggleAutoplay = function toggleAutoplay() {
    if (swiperRef && swiperRef.autoplay) {
      if (isPlaying) {
        swiperRef.autoplay.stop();
      } else {
        swiperRef.autoplay.start();
      }
      setIsPlaying(!isPlaying);
    }
  };
  var toggleFullScreen = function toggleFullScreen() {
    if (!document.fullscreenElement) {
      document.documentElement.requestFullscreen();
    } else {
      document.exitFullscreen();
    }
  };
  var handleFullscreenChange = function handleFullscreenChange() {
    setIsFullscreen(!!document.fullscreenElement);
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    document.addEventListener("fullscreenchange", handleFullscreenChange);
    return function () {
      document.removeEventListener("fullscreenchange", handleFullscreenChange);
    };
  }, []);
  var handleCloseModal = function handleCloseModal() {
    setModalToggle(false);
    setZoomLevel(1);
  };
  return modalToggle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "cs_gallery_modal",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_gallery_modal_overlay"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_gallery_modal_slider_wrap",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
        onSwiper: setSwiperRef,
        pagination: {
          type: "fraction"
        },
        navigation: true,
        modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Mousewheel, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Navigation, swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Autoplay],
        loop: true,
        mousewheel: true,
        className: "mySwiper",
        speed: 1000,
        initialSlide: initialSlideIndex,
        autoplay: isPlaying ? {
          delay: 3000,
          disableOnInteraction: false
        } : false,
        children: galleryList === null || galleryList === void 0 ? void 0 : galleryList.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "cs_gallery_modal_item",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
                src: item.gallery_image_url,
                alt: "",
                style: {
                  transform: "scale(".concat(zoomLevel, ")"),
                  transition: "transform 0.3s ease"
                }
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h4", {
              className: "cs_gallery_modal_title",
              children: item.gallery_title
            })]
          }, index);
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "cs_gallery_controler",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("button", {
        onClick: handleZoomIn,
        className: "cs_gallery_controler_btn",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_3__.Icon, {
          icon: "lucide:zoom-in",
          width: "22",
          height: "22"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("button", {
        onClick: handleZoomOut,
        className: "cs_gallery_controler_btn",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_3__.Icon, {
          icon: "lucide:zoom-out",
          width: "22",
          height: "22"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("button", {
        onClick: function onClick() {
          var _galleryList$initialS;
          return handleDownload((_galleryList$initialS = galleryList[initialSlideIndex]) === null || _galleryList$initialS === void 0 ? void 0 : _galleryList$initialS.gallery_image_url);
        },
        className: "cs_gallery_controler_btn",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_3__.Icon, {
          icon: "lucide:download",
          width: "22",
          height: "22"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("button", {
        onClick: toggleAutoplay,
        className: "cs_gallery_controler_btn ".concat(isPlaying ? "active" : ""),
        children: isPlaying ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_3__.Icon, {
          icon: "lucide:circle-pause",
          width: "22",
          height: "22"
        }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_3__.Icon, {
          icon: "lucide:circle-play",
          width: "22",
          height: "22"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("button", {
        onClick: toggleFullScreen,
        className: "cs_gallery_controler_btn",
        children: isFullscreen ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_3__.Icon, {
          icon: "lucide:scan-line",
          width: "22",
          height: "22"
        }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_3__.Icon, {
          icon: "lucide:scan",
          width: "22",
          height: "22"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("button", {
        onClick: handleCloseModal,
        className: "cs_gallery_controler_btn",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_iconify_react__WEBPACK_IMPORTED_MODULE_3__.Icon, {
          icon: "lucide:x",
          width: "22",
          height: "22"
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/PhotoGallery/PhotoGallery1.jsx":
/*!*************************************************************************!*\
  !*** ./resources/js/Frontend/Components/PhotoGallery/PhotoGallery1.jsx ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PhotoGallery1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _LightGallery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LightGallery */ "./resources/js/Frontend/Components/PhotoGallery/LightGallery.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }



function PhotoGallery1(_ref) {
  var data = _ref.data;
  var section_subtitle = data.section_subtitle,
    section_title = data.section_title,
    gallery_list = data.gallery_list;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    modalToggle = _useState2[0],
    setModalToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0),
    _useState4 = _slicedToArray(_useState3, 2),
    initialSlideIndex = _useState4[0],
    setInitialSlideIndex = _useState4[1];
  var slideTo = function slideTo(index) {
    setInitialSlideIndex(index);
    setModalToggle(true);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [(section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_gallery cs_style_1",
        children: gallery_list === null || gallery_list === void 0 ? void 0 : gallery_list.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_gallery_item cs_bg_filed",
            style: {
              backgroundImage: "url(".concat(item.gallery_image_url, ")")
            },
            onClick: function onClick() {
              return slideTo(index);
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
              className: "cs_gallery_hover",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {})]
            })
          }, index);
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_LightGallery__WEBPACK_IMPORTED_MODULE_1__["default"], {
      modalToggle: modalToggle,
      setModalToggle: setModalToggle,
      galleryList: gallery_list,
      initialSlideIndex: initialSlideIndex
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/PhotoGallery/PhotoGallery2.jsx":
/*!*************************************************************************!*\
  !*** ./resources/js/Frontend/Components/PhotoGallery/PhotoGallery2.jsx ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PhotoGallery2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _LightGallery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LightGallery */ "./resources/js/Frontend/Components/PhotoGallery/LightGallery.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }



function PhotoGallery2(_ref) {
  var data = _ref.data;
  var section_subtitle = data.section_subtitle,
    section_title = data.section_title,
    gallery_list = data.gallery_list;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    modalToggle = _useState2[0],
    setModalToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0),
    _useState4 = _slicedToArray(_useState3, 2),
    initialSlideIndex = _useState4[0],
    setInitialSlideIndex = _useState4[1];
  var slideTo = function slideTo(index) {
    setInitialSlideIndex(index);
    setModalToggle(true);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [(section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_gallery cs_style_2",
        children: gallery_list === null || gallery_list === void 0 ? void 0 : gallery_list.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_gallery_item cs_bg_filed",
            style: {
              backgroundImage: "url(".concat(item.gallery_image_url, ")")
            },
            onClick: function onClick() {
              return slideTo(index);
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
              className: "cs_gallery_hover",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {})]
            })
          }, index);
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_LightGallery__WEBPACK_IMPORTED_MODULE_1__["default"], {
      modalToggle: modalToggle,
      setModalToggle: setModalToggle,
      galleryList: gallery_list,
      initialSlideIndex: initialSlideIndex
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/PhotoGallery/PhotoGallery3.jsx":
/*!*************************************************************************!*\
  !*** ./resources/js/Frontend/Components/PhotoGallery/PhotoGallery3.jsx ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PhotoGallery3)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _LightGallery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LightGallery */ "./resources/js/Frontend/Components/PhotoGallery/LightGallery.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }



function PhotoGallery3(_ref) {
  var data = _ref.data;
  var section_subtitle = data.section_subtitle,
    section_title = data.section_title,
    gallery_list = data.gallery_list;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    modalToggle = _useState2[0],
    setModalToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0),
    _useState4 = _slicedToArray(_useState3, 2),
    initialSlideIndex = _useState4[0],
    setInitialSlideIndex = _useState4[1];
  var slideTo = function slideTo(index) {
    setInitialSlideIndex(index);
    setModalToggle(true);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [(section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_gallery cs_style_3",
        children: gallery_list === null || gallery_list === void 0 ? void 0 : gallery_list.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "cs_gallery_item",
            onClick: function onClick() {
              return slideTo(index);
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
              src: item.gallery_image_url,
              alt: ""
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
              className: "cs_gallery_hover",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {})]
            })]
          }, index);
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_LightGallery__WEBPACK_IMPORTED_MODULE_1__["default"], {
      modalToggle: modalToggle,
      setModalToggle: setModalToggle,
      galleryList: gallery_list,
      initialSlideIndex: initialSlideIndex
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/PhotoGallery/PhotoGallery4.jsx":
/*!*************************************************************************!*\
  !*** ./resources/js/Frontend/Components/PhotoGallery/PhotoGallery4.jsx ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PhotoGallery4)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _LightGallery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LightGallery */ "./resources/js/Frontend/Components/PhotoGallery/LightGallery.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }



function PhotoGallery4(_ref) {
  var data = _ref.data;
  var section_subtitle = data.section_subtitle,
    section_title = data.section_title,
    gallery_list = data.gallery_list;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    modalToggle = _useState2[0],
    setModalToggle = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0),
    _useState4 = _slicedToArray(_useState3, 2),
    initialSlideIndex = _useState4[0],
    setInitialSlideIndex = _useState4[1];
  var slideTo = function slideTo(index) {
    setInitialSlideIndex(index);
    setModalToggle(true);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [(section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_gallery cs_style_4",
        children: gallery_list === null || gallery_list === void 0 ? void 0 : gallery_list.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "cs_gallery_item cs_bg_filed",
            style: {
              backgroundImage: "url(".concat(item.gallery_image_url, ")")
            },
            onClick: function onClick() {
              return slideTo(index);
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
              className: "cs_gallery_hover",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {})]
            })
          }, index);
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_LightGallery__WEBPACK_IMPORTED_MODULE_1__["default"], {
      modalToggle: modalToggle,
      setModalToggle: setModalToggle,
      galleryList: gallery_list,
      initialSlideIndex: initialSlideIndex
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/PopularProduct/PopularProduct1.jsx":
/*!*****************************************************************************!*\
  !*** ./resources/js/Frontend/Components/PopularProduct/PopularProduct1.jsx ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PopularProduct1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var _Components_Amount__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/Components/Amount */ "./resources/js/Components/Amount.jsx");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-redux */ "react-redux");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _Redux_features_Cart_cart__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/Redux/features/Cart/cart */ "./resources/js/Redux/features/Cart/cart.js");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }










function PopularProduct1(_ref) {
  var data = _ref.data;
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    action_text = data.action_text,
    pagination_style = data.pagination_style,
    navigation_style = data.navigation_style,
    is_auto_play = data.is_auto_play;
  var dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_5__.useDispatch)();
  var popularProducts = localStorage.getItem("popular_products") ? JSON.parse(localStorage.getItem("popular_products")) : [];

  // Get shop page URL with popular filter
  var shopUrl = "/shop?filter[type]=popular";
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "cs_section_heading cs_style_3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "cs_section_heading_left",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0 cs_normal",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
          className: "cs_section_heading_right",
          children: action_text && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
            href: shopUrl,
            btnText: action_text,
            btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm"
          })
        })]
      }), (action_text || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "cs_height_80 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      className: "position-relative cs_hover_show_arrow",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "container",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_7__.Swiper, {
          slidesPerView: 1,
          spaceBetween: 24,
          pagination: {
            clickable: true
          },
          autoplay: is_auto_play ? {
            delay: 5000,
            disableOnInteraction: false
          } : false,
          navigation: {
            nextEl: ".cs_right_arrow",
            prevEl: ".cs_left_arrow",
            disabledClass: "swiper-button-disabled"
          },
          modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_8__.Pagination, swiper_modules__WEBPACK_IMPORTED_MODULE_8__.Navigation, swiper_modules__WEBPACK_IMPORTED_MODULE_8__.Autoplay],
          speed: 800,
          loop: true,
          className: "mySwiper".concat(pagination_style === "pagination_0" ? " cs_swiper_pagination_wrap_0" : "").concat(pagination_style === "pagination_1" ? " cs_swiper_pagination_wrap_1" : "").concat(pagination_style === "pagination_2" ? " cs_swiper_pagination_wrap_2" : "").concat(pagination_style === "pagination_3" ? " cs_swiper_pagination_wrap_3" : ""),
          breakpoints: {
            575: _defineProperty({
              slidesPerView: 1
            }, "slidesPerView", 2),
            991: {
              slidesPerView: 3,
              spaceBetween: 24
            },
            1400: {
              slidesPerView: 4,
              spaceBetween: 24
            }
          },
          children: popularProducts === null || popularProducts === void 0 ? void 0 : popularProducts.map(function (product, index) {
            var _product$content, _product$discount_pri;
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_7__.SwiperSlide, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: "cs_product_card cs_style_1",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                  className: "cs_product_thumb",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
                    src: product.thumbnail_image,
                    alt: product.seo_title || "Product Image"
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
                    className: "cs_product_overlay"
                  }), product.quantity === 0 ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
                    className: "cs_out_of_stock_message",
                    children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_3__["default"])("Out of Stock")
                  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                    className: "cs_card_btns",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("a", {
                      href: "javascript:void(0)",
                      onClick: function onClick() {
                        dispatch((0,_Redux_features_Cart_cart__WEBPACK_IMPORTED_MODULE_6__.addCart)(product));
                      },
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("svg", {
                        width: 24,
                        height: 24,
                        viewBox: "0 0 24 24",
                        fill: "none",
                        xmlns: "http://www.w3.org/2000/svg",
                        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("g", {
                          clipPath: "url(#a1)",
                          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("path", {
                            d: "M7 18C5.9 18 5.01 18.9 5.01 20C5.01 21.1 5.9 22 7 22C8.1 22 9 21.1 9 20C9 18.9 8.1 18 7 18ZM1 2V4H3L6.6 11.59L5.25 14.04C5.09 14.32 5 14.65 5 15C5 16.1 5.9 17 7 17H19V15H7.42C7.28 15 7.17 14.89 7.17 14.75L7.2 14.63L8.1 13H15.55C16.3 13 16.96 12.59 17.3 11.97L20.88 5.48C20.96 5.34 21 5.17 21 5C21 4.45 20.55 4 20 4H5.21L4.27 2H1ZM17 18C15.9 18 15.01 18.9 15.01 20C15.01 21.1 15.9 22 17 22C18.1 22 19 21.1 19 20C19 18.9 18.1 18 17 18Z",
                            fill: "currentColor"
                          })
                        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("defs", {
                          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("clipPath", {
                            id: "a1",
                            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("rect", {
                              width: 24,
                              height: 24,
                              fill: "currentColor"
                            })
                          })
                        })]
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_2__.Link, {
                      href: "/product/".concat(product.slug),
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("svg", {
                        width: 22,
                        height: 16,
                        viewBox: "0 0 22 16",
                        fill: "none",
                        xmlns: "http://www.w3.org/2000/svg",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("path", {
                          d: "M11 0.5C6 0.5 1.73 3.61 0 8C1.73 12.39 6 15.5 11 15.5C16 15.5 20.27 12.39 22 8C20.27 3.61 16 0.5 11 0.5ZM11 13C8.24 13 6 10.76 6 8C6 5.24 8.24 3 11 3C13.76 3 16 5.24 16 8C16 10.76 13.76 13 11 13ZM11 5C9.34 5 8 6.34 8 8C8 9.66 9.34 11 11 11C12.66 11 14 9.66 14 8C14 6.34 12.66 5 11 5Z",
                          fill: "currentColor"
                        })
                      })
                    })]
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                  className: "cs_product_info",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("h2", {
                    className: "cs_product_title",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_inertiajs_react__WEBPACK_IMPORTED_MODULE_2__.Link, {
                      href: "/product/".concat(product.slug),
                      children: product === null || product === void 0 || (_product$content = product.content) === null || _product$content === void 0 ? void 0 : _product$content.title
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("p", {
                    className: "cs_product_price",
                    children: [(0,_utils_translate__WEBPACK_IMPORTED_MODULE_3__["default"])("Price"), ":", " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
                      className: "cs_present_price",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_Components_Amount__WEBPACK_IMPORTED_MODULE_4__["default"], {
                        amount: (_product$discount_pri = product.discount_price) !== null && _product$discount_pri !== void 0 ? _product$discount_pri : product.price
                      })
                    }), product.discount_price && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
                      className: "cs_discunt_price",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_Components_Amount__WEBPACK_IMPORTED_MODULE_4__["default"], {
                        amount: product.price
                      })
                    })]
                  })]
                })]
              })
            }, index);
          })
        }), navigation_style === "navigation_0" && "", (popularProducts === null || popularProducts === void 0 ? void 0 : popularProducts.length) > 4 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
          children: navigation_style === "navigation_1" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "cs_slider_arrows cs_style2 cs_mobile_hide",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "cs_left_arrow cs_accent_color",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("svg", {
                width: 52,
                height: 24,
                viewBox: "0 0 52 24",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("path", {
                  d: "M0.939339 10.9393C0.353554 11.5251 0.353554 12.4749 0.939339 13.0607L10.4853 22.6066C11.0711 23.1924 12.0208 23.1924 12.6066 22.6066C13.1924 22.0208 13.1924 21.0711 12.6066 20.4853L4.12132 12L12.6066 3.51472C13.1924 2.92893 13.1924 1.97919 12.6066 1.3934C12.0208 0.807611 11.0711 0.807611 10.4853 1.3934L0.939339 10.9393ZM52 10.5L2 10.5V13.5L52 13.5V10.5Z",
                  fill: "currentColor"
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "cs_right_arrow cs_accent_color",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("svg", {
                width: 52,
                height: 24,
                viewBox: "0 0 52 24",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("path", {
                  d: "M51.0607 13.0607C51.6464 12.4749 51.6464 11.5251 51.0607 10.9393L41.5147 1.3934C40.9289 0.807611 39.9792 0.807611 39.3934 1.3934C38.8076 1.97919 38.8076 2.92893 39.3934 3.51472L47.8787 12L39.3934 20.4853C38.8076 21.0711 38.8076 22.0208 39.3934 22.6066C39.9792 23.1924 40.9289 23.1924 41.5147 22.6066L51.0607 13.0607ZM0 13.5H50V10.5H0V13.5Z",
                  fill: "currentColor"
                })
              })
            })]
          })
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Portfolio/Portfolio1.jsx":
/*!*******************************************************************!*\
  !*** ./resources/js/Frontend/Components/Portfolio/Portfolio1.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Portfolio1)
/* harmony export */ });
/* harmony import */ var _Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/Components/NavigationLink */ "./resources/js/Components/NavigationLink.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Portfolio1(_ref) {
  var data = _ref.data;
  var section_subtitle = data.section_subtitle,
    section_title = data.section_title,
    portfolio_list = data.portfolio_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [(section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "row cs_gap_y_80",
        children: portfolio_list === null || portfolio_list === void 0 ? void 0 : portfolio_list.map(function (item, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
            className: "col-sm-4",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
              className: "cs_post cs_style_1",
              children: [item.portfolio_image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__["default"], {
                href: item.action_url,
                className: "cs_post_thumb",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
                  src: item.portfolio_image_url,
                  alt: item.portfolio_title
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
                className: "cs_post_info",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
                  className: "cs_post_meta",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
                    className: "cs_medium cs_fs_16 cs_primary_color",
                    children: item.portfolio_category
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("h2", {
                  className: "cs_post_title cs_fs_30 cs_normal mb-0",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Components_NavigationLink__WEBPACK_IMPORTED_MODULE_0__["default"], {
                    href: item.action_url,
                    children: item.portfolio_title
                  })
                })]
              })]
            })
          }, index);
        })
      })
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/PortfolioDetails/PortfolioDetails1.jsx":
/*!*********************************************************************************!*\
  !*** ./resources/js/Frontend/Components/PortfolioDetails/PortfolioDetails1.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PortfolioDetails1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! swiper/react */ "swiper/react");
/* harmony import */ var swiper_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(swiper_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! swiper/modules */ "swiper/modules");
/* harmony import */ var swiper_modules__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(swiper_modules__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_youtube_background__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-youtube-background */ "react-youtube-background");
/* harmony import */ var react_youtube_background__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_youtube_background__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





function PortfolioDetails1(_ref) {
  var data = _ref.data;
  var image_url = data.image_url,
    text_editor_content = data.text_editor_content,
    banner_type = data.banner_type,
    gallery_list = data.gallery_list,
    youtube_id = data.youtube_id,
    title = data.title,
    product_info_list = data.product_info_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "container",
    children: [banner_type === "static" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
      children: image_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
        src: image_url,
        alt: "Casestudy",
        className: "cs_radius_50_0_0_0",
        style: {
          marginBottom: "30px"
        }
      })
    }), banner_type === "slider" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_radius_50_0_0_0 overflow-hidden cs_case_study_slider",
      style: {
        marginBottom: "30px"
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.Swiper, {
        navigation: true,
        modules: [swiper_modules__WEBPACK_IMPORTED_MODULE_2__.Navigation],
        className: "mySwiper",
        loop: true,
        speed: 800,
        children: gallery_list === null || gallery_list === void 0 ? void 0 : gallery_list.map(function (galleryItem, index) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(swiper_react__WEBPACK_IMPORTED_MODULE_1__.SwiperSlide, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
              src: galleryItem.gallery_image_url,
              alt: "Casestudy"
            })
          }, index);
        })
      })
    }), banner_type === "video" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "cs_case_study_video cs_radius_50_0_0_0",
      style: {
        marginBottom: "30px"
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)((react_youtube_background__WEBPACK_IMPORTED_MODULE_3___default()), {
        videoId: youtube_id,
        className: "cs_video_bg"
      })
    }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h1", {
      "class": "cs_post_title cs_fs_60 cs_normal",
      style: {
        marginBottom: "40px"
      },
      dangerouslySetInnerHTML: {
        __html: title
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "cs_project_details_wrap",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "cs_project_details_info",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h3", {
          className: "cs_project_details_info_title cs_fs_24",
          style: {
            marginBottom: "15px"
          },
          children: "Project Info"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("ul", {
          className: "cs_project_details_info_list cs_mp0",
          children: product_info_list === null || product_info_list === void 0 ? void 0 : product_info_list.map(function (item, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("li", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
                className: "cs_primary_color mb-0 cs_medium",
                dangerouslySetInnerHTML: {
                  __html: item.product_info_title
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
                className: "mb-0",
                dangerouslySetInnerHTML: {
                  __html: item.product_info_subtitle
                }
              })]
            }, index);
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "cs_project_details_right",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "cs_casestudy_details",
          style: {
            paddingLeft: "0"
          },
          dangerouslySetInnerHTML: {
            __html: text_editor_content
          }
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Post/PostComent.jsx":
/*!**************************************************************!*\
  !*** ./resources/js/Frontend/Components/Post/PostComent.jsx ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BlogComment)
/* harmony export */ });
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/react */ "@inertiajs/react");
/* harmony import */ var _inertiajs_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_inertiajs_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! gravatar-url */ "gravatar-url");
/* harmony import */ var gravatar_url__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(gravatar_url__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! moment */ "moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_translate__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/utils/translate */ "./resources/js/utils/translate.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }






function BlogComment(_ref) {
  var blog = _ref.blog,
    commnets = _ref.commnets;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isReplay = _useState2[0],
    setIsReplay = _useState2[1];
  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(""),
    _useState4 = _slicedToArray(_useState3, 2),
    replayAuthName = _useState4[0],
    setReplayAuthName = _useState4[1];
  var _useForm = (0,_inertiajs_react__WEBPACK_IMPORTED_MODULE_0__.useForm)({
      full_name: "",
      email: "",
      website: "",
      comment: "",
      post_id: blog.id,
      comment_parent: null
    }),
    data = _useForm.data,
    setData = _useForm.setData,
    post = _useForm.post,
    errors = _useForm.errors,
    processing = _useForm.processing,
    reset = _useForm.reset;
  // handle comment
  var handleSubmit = function handleSubmit(e) {
    e.preventDefault();
    post(route("blog.comment"), {
      onSuccess: function onSuccess() {
        reset("full_name", "email", "website", "comment", "comment_parent");
        setIsReplay(false);
      }
    });
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [commnets.length ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "comment-wrap",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "comment-wrap-title mb-35",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("h5", {
          className: "title",
          children: [blog.comment_count_string, " "]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "latest-comments mb-65",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("ul", {
          className: "list-wrap",
          children: commnets.map(function (comment, index) {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("li", {
              id: "comment-".concat(comment.id),
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                className: "comments-box",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                  className: "comments-avatar",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
                    alt: "",
                    src: gravatar_url__WEBPACK_IMPORTED_MODULE_1___default()(comment.comment_author_email),
                    className: "avatar avatar-110 photo",
                    height: 110,
                    width: 110,
                    loading: "lazy",
                    decoding: "async"
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "comment-text",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                    className: "avatar-name mb-10",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("h6", {
                      className: "name",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("a", {
                        href: comment.comment_author_website,
                        rel: "external nofollow ugc",
                        className: "url",
                        children: comment.comment_author_name
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("span", {
                        onClick: function onClick() {
                          setIsReplay(true);
                          setReplayAuthName(comment.comment_author_name);
                          setData("comment_parent", comment.id);
                        },
                        style: {
                          cursor: "pointer"
                        },
                        className: "comment-reply-link",
                        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("svg", {
                          width: 18,
                          height: 14,
                          viewBox: "0 0 18 14",
                          fill: "none",
                          xmlns: "http://www.w3.org/2000/svg",
                          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("path", {
                            d: "M6.54375 0.234322C6.25938 -0.0656777 5.78438 -0.0781777 5.48438 0.206197L1.05625 4.41245C0.434375 5.00307 0.434375 5.99682 1.05625 6.58745L5.48438 10.7937C5.78438 11.0781 6.25938 11.0656 6.54375 10.7656C6.82813 10.4656 6.81563 9.99057 6.51563 9.7062L2.0875 5.49995L6.51563 1.2937C6.81563 1.00932 6.82813 0.534322 6.54375 0.234322ZM11 0.999947C11 0.606197 10.7688 0.246822 10.4063 0.0874474C10.0438 -0.0719277 9.625 -0.0063026 9.33125 0.256197L4.33125 4.7562C4.12188 4.94682 4 5.21557 4 5.49995C4 5.78432 4.12188 6.05307 4.33125 6.2437L9.33125 10.7437C9.625 11.0093 10.0469 11.0749 10.4063 10.9124C10.7656 10.7499 11 10.3937 11 9.99995V7.99995H12C13.6563 7.99995 15 9.3437 15 10.9999C15 11.9499 14.6 12.4968 14.3063 12.7718C14.1344 12.9312 14 13.1468 14 13.3812C14 13.7218 14.275 13.9968 14.6156 13.9968C14.7031 13.9968 14.7906 13.9781 14.8688 13.9374C15.4531 13.6218 18 12.0406 18 8.49995C18 5.46245 15.5375 2.99995 12.5 2.99995H11V0.999947Z",
                            fill: "currentColor"
                          })
                        }), (0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Reply")]
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
                      className: "date",
                      children: moment__WEBPACK_IMPORTED_MODULE_2___default()(comment.created_at).format("ll")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
                    children: comment.comment_content
                  })]
                })]
              })
            }, index);
          })
        })
      })]
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("h2", {
      className: "cs_font_50 cs_m0 cs_normal",
      id: "response",
      children: isReplay ? "".concat((0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Replay to"), ": ").concat(replayAuthName) : (0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Leave A Reply")
    }), isReplay ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("small", {
      onClick: function onClick() {
        setIsReplay(false);
        setData("comment_parent", null);
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
        style: {
          cursor: "pointer"
        },
        children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Cancel reply")
      })
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "cs_height_5 cs-height_lg_5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("p", {
      className: "cs_m0",
      children: [(0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Your email address will not be published. Required fields are marked"), " *"]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "cs_height_40 cs_height_lg_30"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("form", {
      className: "row",
      onSubmit: handleSubmit,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "col-lg-6",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("label", {
          children: [(0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Full Name"), "*"]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("input", {
          type: "text",
          className: "cs_form_field",
          value: data.full_name,
          onChange: function onChange(e) {
            return setData("full_name", e.target.value);
          },
          required: true
        }), errors.full_name && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
          className: "text-danger",
          children: errors.full_name
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_height_20 cs_height_lg_20"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          "data-lastpass-icon-root": "true",
          style: {
            position: "relative !important",
            height: "0px !important",
            width: "0px !important",
            "float": "left !important"
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "col-lg-6",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("label", {
          children: [(0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Email"), "*"]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("input", {
          type: "email",
          className: "cs_form_field",
          value: data.email,
          onChange: function onChange(e) {
            return setData("email", e.target.value);
          },
          required: true
        }), errors.email && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
          className: "text-danger",
          children: errors.email
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_height_20 cs_height_lg_20"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "col-lg-12",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
          children: (0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Website")
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("input", {
          type: "text",
          className: "cs_form_field",
          value: data.website,
          onChange: function onChange(e) {
            return setData("website", e.target.value);
          }
        }), errors.website && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
          className: "text-danger",
          children: errors.website
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_height_20 cs_height_lg_20"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "col-lg-12",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("label", {
          children: [(0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Write Your Comment"), "*"]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("textarea", {
          cols: 30,
          rows: 7,
          className: "cs_form_field",
          value: data.comment,
          onChange: function onChange(e) {
            return setData("comment", e.target.value);
          },
          required: true
        }), errors.comment && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
          className: "text-danger",
          children: errors.comment
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "cs_height_25 cs_height_lg_25"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "col-lg-12",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("button", {
          className: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color",
          disabled: processing,
          children: [(0,_utils_translate__WEBPACK_IMPORTED_MODULE_4__["default"])("Post Comment"), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("span", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("i", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("svg", {
                width: 11,
                height: 11,
                viewBox: "0 0 11 11",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("path", {
                  d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                  stroke: "currentColor",
                  strokeWidth: "1.5",
                  strokeLinecap: "round",
                  strokeLinejoin: "round"
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("i", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("svg", {
                width: 11,
                height: 11,
                viewBox: "0 0 11 11",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("path", {
                  d: "M1 10L10 1M10 1L1 1M10 1L10 10",
                  stroke: "currentColor",
                  strokeWidth: "1.5",
                  strokeLinecap: "round",
                  strokeLinejoin: "round"
                })
              })
            })]
          })]
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Pricing/Pricing1.jsx":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/Pricing/Pricing1.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Pricing1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }




function Pricing1(_ref) {
  var data = _ref.data;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    active = _useState2[0],
    setActive = _useState2[1];
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    section_description = data.section_description,
    pricing_list = data.pricing_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "container",
    children: [(section_subtitle || section_title || section_description) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_2",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "cs_section_heading_left",
          children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
            className: "cs_section_subtitle cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_subtitle
            }
          }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
            className: "cs_section_title cs_fs_53 cs_normal mb-0 cs_normal",
            dangerouslySetInnerHTML: {
              __html: section_title
            }
          })]
        }), section_description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "cs_section_heading_right",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
            className: "cs_section_heading_text mb-0 cs_fs_18 cs_medium",
            dangerouslySetInnerHTML: {
              __html: section_description
            }
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), (pricing_list === null || pricing_list === void 0 ? void 0 : pricing_list.length) > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_price_tab_btns",
      children: pricing_list === null || pricing_list === void 0 ? void 0 : pricing_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
          className: "cs_price_tab_btn".concat(index === active ? " active" : ""),
          onClick: function onClick() {
            return setActive(index);
          },
          children: item.package_type
        }, index);
      })
    }), pricing_list === null || pricing_list === void 0 ? void 0 : pricing_list.map(function (pricingItem, pricingIndex) {
      if (pricingIndex === active) {
        var _pricingItem$package_;
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "row cs_row_gap_60 cs_gap_y_40",
          children: (_pricingItem$package_ = pricingItem.package_list) === null || _pricingItem$package_ === void 0 ? void 0 : _pricingItem$package_.map(function (item, index) {
            var _item$package_feature;
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              className: "col-lg-6",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                className: "cs_pricing_table cs_style_1",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("h2", {
                  className: "cs_pricing_title cs_fs_53 cs_normal",
                  children: [item.package_name, item.package_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                    className: "cs_center",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
                      src: item.package_icon_url,
                      alt: ""
                    })
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
                  className: "cs_pricing_feature cs_mp0 cs_fs_18 cs_medium",
                  children: (_item$package_feature = item.package_feature) === null || _item$package_feature === void 0 ? void 0 : _item$package_feature.map(function (featureItem, featureIndex) {
                    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
                      className: featureItem.package_feature_icon_url ? "" : "p-0",
                      children: [featureItem.package_feature_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                        className: "cs_feature_icon cs_accent_color",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
                          src: featureItem.package_feature_icon_url,
                          alt: ""
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
                        children: featureItem.package_feature_text
                      })]
                    }, featureIndex);
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                  className: "cs_pricing_info",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                    className: "cs_price",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h3", {
                      className: "cs_fs_53 cs_normal mb-0",
                      children: item.package_price
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
                      children: item.package_per
                    })]
                  }), (item.package_btn_url || item.package_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
                    href: item.package_btn_url,
                    btnText: item.package_btn_text,
                    btnClass: "cs_btn cs_style_1 cs_type_2 cs_primary_bg cs_white_color cs_w_100_sm"
                  })]
                })]
              })
            }, index);
          })
        }, pricingIndex);
      }
      return null; // Skip rendering for other indices
    })]
  });
}

/***/ }),

/***/ "./resources/js/Frontend/Components/Pricing/Pricing2.jsx":
/*!***************************************************************!*\
  !*** ./resources/js/Frontend/Components/Pricing/Pricing2.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Pricing2)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./resources/js/Frontend/Components/Button.jsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }




function Pricing2(_ref) {
  var data = _ref.data;
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    active = _useState2[0],
    setActive = _useState2[1];
  var section_title = data.section_title,
    section_subtitle = data.section_subtitle,
    pricing_list = data.pricing_list;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "container",
    children: [(section_subtitle || section_title) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "cs_section_heading cs_style_1 text-center",
        children: [section_subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
          className: "cs_section_subtitle cs_fs_18 cs_medium",
          dangerouslySetInnerHTML: {
            __html: section_subtitle
          }
        }), section_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
          className: "cs_section_title cs_fs_53 cs_normal mb-0",
          dangerouslySetInnerHTML: {
            __html: section_title
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "cs_height_85 cs_height_lg_50"
      })]
    }), (pricing_list === null || pricing_list === void 0 ? void 0 : pricing_list.length) > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "cs_price_tab_btns",
      children: pricing_list === null || pricing_list === void 0 ? void 0 : pricing_list.map(function (item, index) {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
          className: "cs_price_tab_btn".concat(index === active ? " active" : ""),
          onClick: function onClick() {
            return setActive(index);
          },
          children: item.package_type
        }, index);
      })
    }), pricing_list === null || pricing_list === void 0 ? void 0 : pricing_list.map(function (pricingItem, pricingIndex) {
      if (pricingIndex === active) {
        var _pricingItem$package_;
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "row cs_row_gap_60 cs_gap_y_40",
          children: (_pricingItem$package_ = pricingItem.package_list) === null || _pricingItem$package_ === void 0 ? void 0 : _pricingItem$package_.map(function (item, index) {
            var _item$package_feature;
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              className: "col-lg-6",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                className: "cs_pricing_table cs_style_1",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("h2", {
                  className: "cs_pricing_title cs_fs_53 cs_normal",
                  children: [item.package_name, item.package_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                    className: "cs_center",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
                      src: item.package_icon_url,
                      alt: ""
                    })
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
                  className: "cs_pricing_feature cs_mp0 cs_fs_18 cs_medium",
                  children: (_item$package_feature = item.package_feature) === null || _item$package_feature === void 0 ? void 0 : _item$package_feature.map(function (featureItem, featureIndex) {
                    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
                      className: featureItem.package_feature_icon_url ? "" : "p-0",
                      children: [featureItem.package_feature_icon_url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                        className: "cs_feature_icon cs_accent_color",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
                          src: featureItem.package_feature_icon_url,
                          alt: ""
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
                        children: featureItem.package_feature_text
                      })]
                    }, featureIndex);
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                  className: "cs_pricing_info",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                    className: "cs_price",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h3", {
                      className: "cs_fs_53 cs_normal mb-0",
                      children: item.package_price
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
                      children: item.package_per
                    })]
                  }), (item.package_btn_url || item.package_btn_text) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Button__WEBPA